<?php
session_start();

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');







/**
* Prijungiama ../classes/SiteConfig.class.php Globalių parametrų valdymo klasių biblioteka
*/
require_once('../classes/SiteConfig.class.php');


/**
* Prijungiama Logging.class.php istorijos žurnalų valdymo klasių biblioteka
*/
require_once('../classes/Logging.class.php');

/**
* Prijungiama Customer.class.php klientų valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');


$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));


$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);



$customer = new Customer();
$customerData = $customer->getCustomer($_GET['id']);



//id,company_name,code,vat_code,name,surname,address,phone,username,password,is_company,registred

$name = $customerData[4];
$surname = $customerData[5];
$code = $customerData[2];
$address = $customerData[6];
$phone = $customerData[7];
$username = $customerData[8];
$password = $customerData[9];
$company_name = $customerData[1];
$vat_code = $customerData[3];

	$smarty->assign('name',$name);
	$smarty->assign('surname',$surname);
	$smarty->assign('code',$code);
	$smarty->assign('address',$address);
	$smarty->assign('phone',$phone);
	$smarty->assign('username',$username);
	$smarty->assign('password',$password);
	$smarty->assign('vat_code',$vat_code);
	$smarty->assign('company_name',$company_name);
	
	//echo "DB:".strlen($customerData[2])."POST:".strlen($_POST['code']);
	

$smarty->assign('customer',$customerData);




if ($_SERVER['REQUEST_METHOD'] == 'POST' && $customerData[10] == 'f') {
	
	$smarty->assign('name',$_POST['name']);
	$smarty->assign('surname',$_POST['surname']);
	$smarty->assign('code',$_POST['code']);
	$smarty->assign('address',$_POST['address']);
	$smarty->assign('phone',$_POST['phone']);
	$smarty->assign('username',$_POST['username']);
	$smarty->assign('password',$_POST['password']);
	$error = 0;
	if (!$customer->checkNaturalPersonNameSurname($_POST['name']))  {
		$smarty->assign('name_error',1);
		$error++;
	}
	if (!$customer->checkNaturalPersonNameSurname($_POST['surname']))  {
		$smarty->assign('surname_error',1);
		$error++;
	}
	if (!$customer->checkIdentityCode($_POST['code']))  {
		$smarty->assign('code_error',1);
		$error++;
	}
	if (!$customer->checkAddress($_POST['address']))  {
		$smarty->assign('address_error',1);
		$error++;
	}
	if (!$customer->checkPhone($_POST['phone']) && strlen($_POST['phone']) > 0)  {
		$smarty->assign('phone_error',1);
		$error++;
	}
	if (!$customer->checkUsername($_POST['username']))  {
		$smarty->assign('username_error',1);
		$error++;
	} elseif ($customer->checkCustomerExistence($customerData[0],$_POST['username'])) {
		$smarty->assign('username_exist_error',1);
		$error++;
	}
	if (!$customer->checkPassword($_POST['password']))  {
		$smarty->assign('password_error',1);
		$error++;
	}
	
	if ($error == 0) {
		$customer->updateCustomer($customerData[0],null,$_POST['code'],null,$_POST['name'],$_POST['surname'],$_POST['address'],$_POST['phone'],$_POST['username'],$_POST['password'],false);
		$smarty->assign('success',1);
	}
	$smarty->assign('error',$error);
}


if ($_SERVER['REQUEST_METHOD'] == 'POST' && $customerData[10] == 't') {
	
	$smarty->assign('company_name',$_POST['company_name']);
	$smarty->assign('name',$_POST['name']);
	$smarty->assign('surname',$_POST['surname']);
	$smarty->assign('code',$_POST['code']);
	$smarty->assign('vat_code',$_POST['vat_code']);
	$smarty->assign('address',$_POST['address']);
	$smarty->assign('phone',$_POST['phone']);
	$smarty->assign('username',$_POST['username']);
	$smarty->assign('password',$_POST['password']);
	$error = 0;
	if (!$customer->checkCompanyName($_POST['company_name']))  {
		$smarty->assign('company_name_error',1);
		$error++;
	}
	if (!$customer->checkNaturalPersonNameSurname($_POST['name']))  {
		$smarty->assign('name_error',1);
		$error++;
	}
	if (!$customer->checkNaturalPersonNameSurname($_POST['surname']))  {
		$smarty->assign('surname_error',1);
		$error++;
	}
	if (!$customer->checkVATCode($_POST['vat_code']))  {
		$smarty->assign('vat_code_error',1);
		$error++;
	}
	if (!$customer->checkCode($_POST['code']))  {
		$smarty->assign('code_error',1);
		$error++;
	}
	if (!$customer->checkAddress($_POST['address']))  {
		$smarty->assign('address_error',1);
		$error++;
	}
	if (!$customer->checkPhone($_POST['phone']) && strlen($_POST['phone']) > 0)  {
		$smarty->assign('phone_error',1);
		$error++;
	}
	if (!$customer->checkUsername($_POST['username']))  {
		$smarty->assign('username_error',1);
		$error++;
	} elseif ($customer->checkCustomerExistence($customerData[0],$_POST['username'])) {
		$smarty->assign('username_exist_error',1);
		$error++;
	}
	if (!$customer->checkPassword($_POST['password']))  {
		$smarty->assign('password_error',1);
		$error++;
	}
	//echo "klaidos:".$error;
	if ($error == 0) {
		$customer->updateCustomer($customerData[0],$_POST['company_name'],$_POST['code'],$_POST['vat_code'],$_POST['name'],$_POST['surname'],$_POST['address'],$_POST['phone'],$_POST['username'],$_POST['password'],true);
		$smarty->assign('success',1);
	}
	$smarty->assign('error',$error);
}


$contracts = $customer->getCustomerContracts($_GET['id']);

$smarty->assign('contracts',$contracts);

if (@strlen($_GET['delete']) > 0) {
	$customer->deleteCustomer($_GET['id'],$contracts);
	echo "<script language='javascript'>this.location = 'customers.php?deletesuccess=1'</script>";
	return;
} 




//echo "<pre>";
//print_r($customer->getCustomerContracts($_GET['id']));
//echo "<pre>";

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/customer_detail.tpl');
}

?>