<?php
session_start();
//error_reporting(E_ALL);

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');

/**
* Prijungiama ../classes/Customer.class.php Klientų informacijos valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');





$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));

$customer = new Customer();


$smarty->assign('plans',$customer->getPlans());
$smarty->assign('owners',$customer->getOwners());




$contract = $customer->getCustomerContract($_GET['id']);

if (@strlen($_GET['delete']) > 0) {
	//echo "($contract[0],$contract[12],$contract[16])";
	$customer->deleteContract($contract[0],$contract[12],$contract[16]);
	//$smarty->assign('file_del_success',1);

	echo "<script language='javascript'>this.location = 'customer_detail.php?id=".$contract[0]."&deletesuccess=1'</script>";
	return;
}

if (@strlen($_GET['file_del']) > 0) {
	//echo "($contract[0],$contract[12],$contract[16])";
	$customer->deleteContractFile($contract[0],$contract[12],$contract[16]);
	$smarty->assign('file_del_success',1);

	//echo "<script language='javascript'>this.location = 'customers.php?deletesuccess=1'</script>";
	//return;
}

$contract = $customer->getCustomerContract($_GET['id']);




$smarty->assign('contract',$contract);

//echo "<pre>";
//print_r($contract);
//echo "<pre>";
$smarty->assign('plan_id',$contract[26]);
$smarty->assign('mountly_fee',$contract[13]);
$smarty->assign('owner_id',$contract[21]);
$smarty->assign('valid_from',$contract[14]);
$smarty->assign('valid_to',$contract[15]);
$smarty->assign('contract_path',$contract[16]);
$smarty->assign('suspend_from',$contract[17]);
$smarty->assign('suspend_to',$contract[18]);
$smarty->assign('is_active',$contract[19]);
$smarty->assign('other_info',$contract[34]);


if ($_SERVER['REQUEST_METHOD'] == 'POST' && @$_GET['main'] == 1) {
	
	$smarty->assign('plan_id',$_POST['plan_id']);
	$smarty->assign('mountly_fee',$_POST['mountly_fee']);
	$smarty->assign('owner_id',$_POST['owner_id']);
	
	$smarty->assign('valid_from',$_POST['valid_from']);
	$smarty->assign('valid_to',$_POST['valid_to']);
	
	$smarty->assign('suspend_from',$_POST['suspend_from']);
	$smarty->assign('suspend_to',$_POST['suspend_to']);
	
	$smarty->assign('is_active',$_POST['is_active']);
	$smarty->assign('other_info',$_POST['other_info']);

	$error = 0;
	if (strlen($_POST['plan_id']) == 0)  {
		$smarty->assign('plan_id_error',1);
		$error++;
	}
	if (!$customer->checkDigit($_POST['mountly_fee']))  {
		$smarty->assign('mountly_fee_error',1);
		$error++;
	}
	if (strlen($_POST['owner_id']) == 0)  {
		$smarty->assign('owner_id_error',1);
		$error++;
	}
	if (strlen($_POST['valid_from']) == 0)  {
		$smarty->assign('valid_from_error',1);
		$error++;
	}
	if (strlen($_POST['valid_from']) > 0 && strlen($_POST['valid_to']) > 0)  {
		//echo $customer->checkDates($_POST['valid_from'],$_POST['valid_to']);
		if (!$customer->checkDates($_POST['valid_to'],$_POST['valid_from'])) {
			//echo "blogai";
			$smarty->assign('dates_error',1);
			$error++;			
		}
	}
	
	if (strlen($_POST['suspend_from']) == 0 && strlen($_POST['suspend_to']) != 0)  {
		$smarty->assign('suspend_from_error',1);
		$error++;
	}
	
	if (strlen($_FILES['contract_path']['tmp_name']) > 0 && !is_uploaded_file($_FILES['contract_path']['tmp_name']) ) {
		$error++;
		$smarty->assign('contract_path_error',1);
	}
	
	if (strlen($_POST['suspend_from']) > 0 && strlen($_POST['suspend_to']) > 0)  {
		//echo $customer->checkDates($_POST['valid_from'],$_POST['valid_to']);
		
		if (!$customer->checkDates($_POST['suspend_to'],$_POST['suspend_from'])) {
			//echo "blogai";
			$smarty->assign('suspend_dates_error',1);
			$error++;			
		}
	}	
	
	
	
	
	if (strlen($_POST['suspend_from']) > 0 && strlen($_POST['valid_from']) > 0)  {
		//echo $customer->checkDates($_POST['valid_from'],$_POST['valid_to']);
		
		if (!$customer->checkDates($_POST['suspend_from'],$_POST['valid_from'])) {
			//echo "blogai";
			$smarty->assign('invalid_suspend_error',1);
			$error++;			
		}
	}	
	
	
	if (strlen($_POST['suspend_to']) > 0 && strlen($_POST['valid_to']) > 0)  {
		//echo $customer->checkDates($_POST['valid_from'],$_POST['valid_to']);
		
		if (!$customer->checkDates($_POST['valid_to'],$_POST['suspend_to'])) {
			//echo "blogai";
			$smarty->assign('invalid_to_suspend_error',1);
			$error++;			
		}
	}
	

	if ($error == 0) {
		//echo "gerai";
		//echo time();
		
		$contract_path = "";
		if (is_uploaded_file($_FILES['contract_path']['tmp_name'])) {
			$contract_path = '../contracts/'.time().$_FILES['contract_path']['name'];
			move_uploaded_file($_FILES['contract_path']['tmp_name'], $contract_path);
			@unlink($contract[16]);
		}
		
		//$customer_id,$plan_id,$mountly_fee,$owner_id,$valid_from,$valid_to,$contract_path,$suspend_from,$suspend_to,$is_active
		$customer->updateContract($contract[12],$contract[0],$_POST['plan_id'],$_POST['mountly_fee'],$_POST['owner_id'],$_POST['valid_from'],$_POST['valid_to'],$contract_path,$_POST['suspend_from'],$_POST['suspend_to'],$_POST['is_active'],$_POST['other_info']);
		$smarty->assign('success_update',1);
		//echo "<script language='javascript'>this.location = 'customer_detail.php?id=".$_GET['id']."&type=".$_GET['type']."&success=1'</script>";
		//return ;
		$contract = $customer->getCustomerContract($_GET['id']);
		$smarty->assign('contract',$contract);
		$smarty->assign('contract_path',$contract[16]);
	}
	$smarty->assign('error',$error);
}

if (@strlen($_GET['delete_address']) > 0) {
	//echo "($contract[0],$contract[12],$contract[16])";
	$customer->deleteAddress($_GET['delete_address']);
	$smarty->assign('address_del_success',1);

	
}

if (@strlen($_GET['update_address']) > 0 && $_SERVER['REQUEST_METHOD'] == 'POST') {
	
	$error = 0;
	if (!$customer->checkIPv4($_POST['ipv4']))  {
		$smarty->assign('ipv4_error',1);
		$error++;
	}
	if (!$customer->checkIPv4($_POST['mask']))  {
		$smarty->assign('mask_error',1);
		$error++;
	}
	if (!$customer->checkIPv4($_POST['gateway']))  {
		$smarty->assign('gateway_error',1);
		$error++;
	}
	if (!$customer->checkIPv4($_POST['dns1']))  {
		$smarty->assign('dns1_error',1);
		$error++;
	}
	if (!$customer->checkIPv4($_POST['dns2']) && strlen($_POST['dns2']) > 0 )  {
		$smarty->assign('dns2_error',1);
		$error++;
	}
	
	if (!$customer->checkMAC($_POST['mac']))  {
		$smarty->assign('mac_error',1);
		$error++;
	}

//
	if ($error == 0) {
	
		$customer->updateAddress($_GET['update_address'],$_POST['ipv4'],$_POST['mask'],$_POST['gateway'],$_POST['dns1'],$_POST['dns2'],$_POST['other'],$_GET['id'],$_POST['mac']);
		$smarty->assign('update_success',1);
	}

	
}




$smarty->assign('ips',$customer->getAddresses($_GET['id']));

$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/contract_detail.tpl');
}


?>