<?php

/*
 * RESSIO Responsive Server Side Optimizer
 * https://github.com/ressio/
 *
 * @copyright   Copyright (C) 2013-2018 Kuneri, Ltd. All rights reserved.
 * @license     GNU General Public License version 2
 */

interface IRessio_HtmlOptimizer
{
    const DOCTYPE_HTML4 = 1;
    const DOCTYPE_HTML5 = 2;
    const DOCTYPE_XHTML = 3;

    /**
     * @param string $buffer
     * @return string
     */
    public function run($buffer);

    /**
     * @param string $file
     * @param array|null $attribs
     */
    public function appendScript($file, $attribs = null);

    /**
     * @param string $content
     * @param array|null $attribs
     * @param bool $head
     */
    public function appendScriptDeclaration($content, $attribs = null, $head = null);

    /**
     * @param string $file
     * @param array|null $attribs
     */
    public function appendStylesheet($file, $attribs = null);

    /**
     * @param string $content
     * @param array|null $attribs
     */
    public function appendStyleDeclaration($content, $attribs = null);

    /**
     * @param IRessio_HtmlNode $node
     * @return string
     */
    public function nodeToString($node);

    /**
     * @param IRessio_HtmlNode $node
     */
    public function nodeDetach(&$node);

    /**
     * @param IRessio_HtmlNode $node
     * @return bool
     */
    public function nodeIsDetached($node);

    /**
     * @param IRessio_HtmlNode $node
     * @param string $text
     */
    public function nodeSetInnerText(&$node, $text);

    /**
     * @param IRessio_HtmlNode $node
     * @return string
     */
    public function nodeGetInnerText(&$node);

    /**
     * @param IRessio_HtmlNode $node
     * @param string $tag
     * @param array $attribs
     */
    public function nodeWrap(&$node, $tag, $attribs = null);

    /**
     * @param IRessio_HtmlNode $node
     * @param string $tag
     * @param array $attribs
     * @param string $content
     */
    public function nodeInsertBefore(&$node, $tag, $attribs = null, $content = null);

    /**
     * @param IRessio_HtmlNode $node
     * @param string $tag
     * @param array $attribs
     * @param string $content
     */
    public function nodeInsertAfter(&$node, $tag, $attribs = null, $content = null);

    /**
     * @param array $nodedata (string $tag, array $attribs, string $content)
     * @return bool return false if no <head> found
     */
    public function prependHead($nodedata);

    /**
     * @param array $nodedata (string $tag, array $attribs, string $content)
     * @return bool return false if no <link rel=stylesheet>, <style>, <script>, or combining wrappers
     */
    public function insertBeforeStyleScript($nodedata);

    /**
     * @return bool
     */
    public function isNoscriptState();
}
