<?php

/*
 * RESSIO Responsive Server Side Optimizer
 * https://github.com/ressio/
 *
 * @copyright   Copyright (C) 2013-2018 Kuneri, Ltd. All rights reserved.
 * @license     GNU General Public License version 2
 */

interface IRessio_Dispatcher
{
    const ORDER_FIRST = -5;
    const ORDER_STANDARD = 0;
    const ORDER_LAST = 5;

    /**
     * @param array|string $eventNames
     * @param array|string $callableObj
     * @param int $priority
     */
    public function addListener($eventNames, $callableObj, $priority = self::ORDER_STANDARD);

    /**
     * @param array|string $eventNames
     * @param array|string $callableObj
     */
    public function removeListener($eventNames, $callableObj);

    /**
     * @param array|string $eventNames
     */
    public function clearListeners($eventNames);

    /**
     * @param string $eventName
     * @param array $params
     */
    public function triggerEvent($eventName, $params = array());
}