<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die('Restricted access');

require_once JPATH_COMPONENT . '/classes/mjcontroller.php';

// @todo Step-by-step installer

class MjInstallController extends MjController
{
    public function display()
    {
        $this->loadFramework();

        if (is_dir(JPATH_SITE . '/templates/mobile_basic')) {
            JFactory::getApplication()->redirect('index.php?option=com_mobilejoomla');
            return;
        }

        echo $this->renderView('global/page', array(
            'sidebar' => '',
            'content' => $this->renderView('install')
        ));
    }

    private function initStatus()
    {
        // @todo rewrite to exclude JError
        JError::setErrorHandling(E_ERROR, 'Message');
        set_time_limit(1200);
        ini_set('max_execution_time', 1200);
    }

    private function sendStatus()
    {
        $msg = array();
        /** @var JException $error */
        // @todo rewrite to exclude JError
        foreach (JError::getErrors() as $error) {
            if ($error->get('level')) {
                $msg[] = $error->get('message');
            }
        }
        if (count($msg)) {
            $msg = '<p>' . implode('</p><p>', $msg) . '</p>';
        } else {
            $msg = 'ok';
        }
        echo $msg;
        jexit();
    }

    public function download()
    {
        jimport('joomla.installer.helper');

        $app = JFactory::getApplication();
        $this->initStatus();

        $mobile_basic_url = 'http://www.mobilejoomla.com/get_package.php?pkg=mobile_basic&j=' . JVERSION . '&mj=2.1.51';
        $filename = JInstallerHelper::downloadPackage($mobile_basic_url);
        if ($filename) {
            $app->setUserState('com_mobilejoomla.updatefilename', $filename);
        }
        $this->sendStatus();
    }

    public function unpack()
    {
        jimport('joomla.installer.helper');

        $app = JFactory::getApplication();
        $this->initStatus();

        $filename = $app->getUserState('com_mobilejoomla.updatefilename', false);
        if ($filename) {
            $config = JFactory::getConfig();
            if (strncmp(JVERSION, '1.5.', 4) === 0) {
                $path = $config->getValue('config.tmp_path');
            } else {
                $path = $config->get('tmp_path');
            }
            $path .= '/' . $filename;
            $result = JInstallerHelper::unpack($path);
            $app->setUserState('com_mobilejoomla.updatefilename', false);
            if ($result !== false) {
                /** @var array $result */
                $app->setUserState('com_mobilejoomla.updatedir', $result['dir']);
                JFile::delete($path);
            }
        } else {
            // @todo rewrite to exclude JError
            JError::raiseWarning(1, JText::_('COM_MJ__UPDATE_UNKNOWN_PATH'));
        }
        $this->sendStatus();
    }

    public function install()
    {
        jimport('joomla.installer.helper');
        jimport('joomla.installer.installer');

        $app = JFactory::getApplication();
        $this->initStatus();

        $dir = $app->getUserState('com_mobilejoomla.updatedir', false);
        if ($dir) {
            $installer = new JInstaller();
            $installer->install($dir);
            $app->setUserState('com_mobilejoomla.updatedir', false);
            JFolder::delete($dir);

            include_once JPATH_COMPONENT . '/models/settings.php'; // load before mjinstaller.php
            include_once JPATH_COMPONENT . '/classes/mjquerybuilder.php';
            include_once JPATH_COMPONENT . '/classes/mjinstaller.php';

            $template_id = MjInstaller::getTemplateStyleId('mobile_basic');
            $mjSettings = new MjSettingsModel($this->joomlaWrapper);
            $mjSettings->def('mobile.template', $template_id);
            $mjSettings->save();
            if (is_file(JPATH_SITE . '/templates/mobile_basic/media/install.php')) {
                include JPATH_SITE . '/templates/mobile_basic/media/install.php';
            }
        } else {
            // @todo rewrite to exclude JError
            JError::raiseWarning(1, JText::_('COM_MJ__UPDATE_UNKNOWN_PATH'));
        }
        $this->sendStatus();
    }
}