<?php
session_start();

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');

/**
* Prijungiama ../classes/ArticleManager.class.php Straipsnių valdymo klasių biblioteka
*/
require_once('../classes/ArticleManager.class.php');

/**
* Prijungiamos FCKEditoriaus klasių bibliotekos
*/
require_once('../FCKeditor/fckeditor.php');


$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));

$article = new Article();
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	$article_text_lt = trim($_POST['lt']);
	$article_text_ru = trim($_POST['ru']);
	$article_text_en = trim($_POST['en']);
	$article->updateArticle(9,$article_text_lt,$article_text_en,$article_text_ru);
	//echo time();
}

$aboutUs = $article->getArticle(9);

$oFCKeditorLt = new FCKeditor('lt') ;
$oFCKeditorLt->BasePath = '../FCKeditor/';
$oFCKeditorLt->Value = $aboutUs[0];
$oFCKeditorLt->Height = '400' ;


$oFCKeditorEn = new FCKeditor('en') ;
$oFCKeditorEn->BasePath = '../FCKeditor/';
$oFCKeditorEn->Value = $aboutUs[1];
$oFCKeditorEn->Height = '400' ;


$oFCKeditorRu = new FCKeditor('ru') ;
$oFCKeditorRu->BasePath = '../FCKeditor/';
$oFCKeditorRu->Value = $aboutUs[2];
$oFCKeditorRu->Height = '400' ;



$smarty->assign('editor_lt',$oFCKeditorLt->CreateHtml());
$smarty->assign('editor_en',$oFCKeditorEn->CreateHtml());
$smarty->assign('editor_ru',$oFCKeditorRu->CreateHtml());

$admin = new Admin();
$adminID = $admin->getAdminID($_SESSION['username'],$_SESSION['password']);

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php?error=1'</script>";
} else {
	$smarty->display('admin/spa.tpl');
}



?>