<?php
// $HeadURL: https://joomgallery.org/svn/joomgallery/JG-1.5/Module/JoomImages/trunk/mod_joomimg.php $
// $Id: mod_joomimg.php 2146 2010-05-10 16:07:46Z aha $
/**
* Module JoomImages 1.5
* by JoomGallery::Project Team
* based on module for PonyGallery ML by Benjamin Malte Meier 10/08/2007"
* @package JoomGallery
* @Copyright JoomGallery team and b2m
* @ All rights reserved
* @ Joomla Open Source is Free Stuff
* @ Released under GnuGPL License.
**/

/// no direct access
defined('_JEXEC') or die('Restricted access');
jimport('joomla.filesystem.file');

// Check existence of interface to decide if joomgallery is installed
if (!JFile::exists(JPATH_ROOT.DS.'components'.DS.'com_joomgallery'.DS.'interface.php'))
{
  echo JText::_('JIJGNOTINSTALLED');
  return;
}
// Check the version of JoomGallery and the minimum requirements
if (!JFile::exists(JPATH_ROOT.DS
                   .'administrator'.DS
                   .'components'.DS
                   .'com_joomgallery'.DS
                   .'joomgallery.xml'))
{
  echo JText::_('JIJGNOTINSTALLED');
  return;
}

//get the interface
require_once(JPATH_ROOT.DS.'components'.DS.'com_joomgallery'.DS.'interface.php');

// Include the helper class only once
require_once (dirname(__FILE__).DS.'helper.php');

//id of actual module instance
$moduleid = $module->id;

//create helper object
$joomimgObj = new modJoomImagesHelper();

if($joomimgObj->getGalleryVersion() < "1.5.5")
{
  echo JText::sprintf('JIJOOMGALLERY_NOT_UPTODATE', '1.5.5');
  return;
}

//fill the interface object and get the images
$imgobjects = $joomimgObj->fillObject($params,$moduleid);

//slideshow or default view
if($joomimgObj->getConfig('slideshowthis') == 1)
{
  $path = JModuleHelper::getLayoutPath('mod_joomimg', 'slideshow');
}
else
{
  $path = JModuleHelper::getLayoutPath('mod_joomimg', 'default');
}
if (JFile::exists($path))
{
  require($path);
}
?>