/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.net.ftp.FTPReply;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.DefaultFileUploadThread;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFilePacket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadThreadFTP
extends DefaultFileUploadThread {
    private OutputStream ftpOutputStream = null;
    private BufferedOutputStream bufferedOutputStream = null;
    private Matcher uriMatch;
    private FTPClient ftp = new FTPClient();
    private String user;
    private String pass;
    private String host;
    private String port;
    private String ftpRootFolder;
    private boolean bConnected = false;
    public final Pattern ftpPattern = Pattern.compile("^ftp://(([^:]+):([^\\@]+)\\@)?([^/:]+):?([0-9]+)?(/(.*))?$");

    public FileUploadThreadFTP(UploadPolicy uploadPolicy, BlockingQueue<UploadFilePacket> packetQueue, FileUploadManagerThread fileUploadManagerThread) throws JUploadException {
        super("FileUploadThreadFTP thread", packetQueue, uploadPolicy, fileUploadManagerThread);
        this.uploadPolicy.displayDebug("[FileUploadThreadFTP]  Using " + this.getClass().getName(), 30);
        if (uploadPolicy.getStringUploadSuccess() != null) {
            uploadPolicy.displayWarn("FTP mode: stringUploadSuccess parameter ignored (forced to null)");
            uploadPolicy.setProperty("stringUploadSuccess", null);
        }
        if (uploadPolicy.getNbFilesPerRequest() != 1) {
            uploadPolicy.displayWarn("FTP mode: nbFilesPerRequest parameter ignored (forced to 1)");
            uploadPolicy.setProperty("nbFilesPerRequest", "1");
        }
        if (uploadPolicy.getMaxChunkSize() != Long.MAX_VALUE) {
            uploadPolicy.displayWarn("FTP mode: maxChunkSize parameter ignored (forced to Long.MAX_VALUE)");
            uploadPolicy.setProperty("maxChunkSize", Long.toString(Long.MAX_VALUE));
        }
    }

    @Override
    void beforeRequest(UploadFilePacket packet) throws JUploadException {
        if (this.bConnected) {
            try {
                this.ftp.sendNoOp();
            }
            catch (FTPConnectionClosedException eClosed) {
                this.bConnected = false;
            }
            catch (IOException e) {
                throw new JUploadIOException(e.getClass().getName() + " while checking FTP connection to the server", e);
            }
        }
        if (!this.bConnected) {
            String url = this.uploadPolicy.getPostURL();
            this.uriMatch = this.ftpPattern.matcher(url);
            if (!this.uriMatch.matches()) {
                throw new JUploadException("invalid URI: " + url);
            }
            this.user = this.uriMatch.group(2) == null ? "anonymous" : this.uriMatch.group(2);
            this.pass = this.uriMatch.group(3) == null ? "JUpload" : this.uriMatch.group(3);
            this.host = this.uriMatch.group(4);
            this.port = this.uriMatch.group(5) == null ? "21" : this.uriMatch.group(5);
            String string = this.ftpRootFolder = this.uriMatch.group(7) == null ? null : "/" + this.uriMatch.group(7);
            if (this.ftpRootFolder != null && !this.ftpRootFolder.endsWith("/")) {
                this.ftpRootFolder = this.ftpRootFolder + "/";
            }
            try {
                this.ftp.setDefaultPort(Integer.parseInt(this.port));
                this.ftp.connect(this.host);
                this.uploadPolicy.displayDebug("[FileUploadThreadFTP] Connected to " + this.host, 10);
                this.uploadPolicy.displayDebug(this.ftp.getReplyString(), 80);
                if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                    throw new JUploadException("FTP server refused connection.");
                }
                this.ftp.login(this.user, this.pass);
                this.uploadPolicy.displayDebug("[FileUploadThreadFTP] " + this.ftp.getReplyString(), 80);
                if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                    throw new JUploadException("Invalid ftp username / password");
                }
                this.bConnected = true;
            }
            catch (JUploadException jue) {
                throw jue;
            }
            catch (IOException ioe) {
                throw new JUploadIOException(ioe.getClass().getName() + "[FTP] Could not connect to server (" + ioe.getMessage() + ")", ioe);
            }
            catch (Exception e) {
                throw new JUploadException(e.getClass().getName() + "[FTP] Could not connect to server (" + e.getMessage() + ")", e);
            }
            if (this.uploadPolicy.getFtpTransfertPassive()) {
                this.ftp.enterLocalPassiveMode();
            } else {
                this.ftp.enterLocalActiveMode();
            }
        }
    }

    @Override
    void afterFile(UploadFileData uploadFileData) {
    }

    @Override
    void beforeFile(UploadFilePacket uploadFilePacket, UploadFileData uploadFileData) throws JUploadException {
        String workingDir = null;
        try {
            if (this.uploadPolicy.getFtpCreateDirectoryStructure()) {
                this.createDirectoryStructure(uploadFilePacket);
                workingDir = this.ftpRootFolder + uploadFileData.getRelativeDir();
                workingDir = workingDir.replace("\\", "/");
                this.uploadPolicy.displayDebug("[FileUploadThreadFTP] ftpCreateDirectoryStructure: Changing working directory to: " + workingDir, 80);
            } else {
                workingDir = this.ftpRootFolder;
            }
            if (workingDir != null && !workingDir.equals("") && !workingDir.equals(".")) {
                this.ftp.changeWorkingDirectory(workingDir);
                this.uploadPolicy.displayDebug("[FileUploadThreadFTP] " + this.ftp.getReplyString(), 80);
            }
            if (!FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                throw new JUploadException("[FTP] Error while changing directory to: " + workingDir + " (" + this.ftp.getReplyString() + ")");
            }
            this.setTransferType(uploadFileData);
            this.ftpOutputStream = this.ftp.storeFileStream(uploadFileData.getFileName());
            if (this.ftpOutputStream == null) {
                throw new JUploadIOException("Stream connection to the server error. Check that your path on the URL is valid. postURL used is: " + this.uploadPolicy.getPostURL());
            }
            this.bufferedOutputStream = new BufferedOutputStream(this.ftpOutputStream);
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void cleanAll() {
        try {
            block4: {
                try {
                    if (!this.ftp.isConnected()) break block4;
                    this.ftp.disconnect();
                    this.uploadPolicy.displayDebug("[FileUploadThreadFTP] disconnected", 50);
                }
                catch (IOException e) {
                    this.uploadPolicy.displayDebug("[FileUploadThreadFTP] Not connected", 50);
                    Object var3_2 = null;
                    this.ftpOutputStream = null;
                    this.bufferedOutputStream = null;
                }
            }
            Object var3_1 = null;
            this.ftpOutputStream = null;
            this.bufferedOutputStream = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.ftpOutputStream = null;
            this.bufferedOutputStream = null;
            throw throwable;
        }
    }

    @Override
    void cleanRequest() throws JUploadException {
        if (this.bufferedOutputStream != null) {
            try {
                try {
                    this.bufferedOutputStream.close();
                    this.ftpOutputStream.close();
                    if (!this.ftp.completePendingCommand()) {
                        throw new JUploadExceptionUploadFailed("ftp.completePendingCommand() returned false");
                    }
                    Object var3_1 = null;
                    this.bufferedOutputStream = null;
                }
                catch (IOException e) {
                    throw new JUploadException(e);
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                this.bufferedOutputStream = null;
                throw throwable;
            }
        }
    }

    @Override
    int finishRequest() throws JUploadException {
        try {
            this.getOutputStream().flush();
            return 200;
        }
        catch (IOException ioe) {
            throw new JUploadIOException("FileUploadThreadFTP.finishRequest()", ioe);
        }
        catch (Exception e) {
            throw new JUploadException("FileUploadThreadFTP.finishRequest()  (check the user permission on the server)", e);
        }
    }

    @Override
    long getAdditionnalBytesForUpload(UploadFileData uploadFileData) {
        return 0L;
    }

    @Override
    OutputStream getOutputStream() {
        return this.bufferedOutputStream;
    }

    @Override
    void startRequest(long contentLength, boolean bChunkEnabled, int chunkPart, boolean bLastChunk) {
    }

    private void setTransferType(UploadFileData uploadFileData) throws JUploadIOException {
        try {
            if (this.uploadPolicy.getFtpTransfertBinary()) {
                this.ftp.setFileType(2);
            } else {
                this.ftp.setFileType(0);
            }
        }
        catch (IOException ioe) {
            throw new JUploadIOException("Cannot set transfert binary or ascii mode (binary: " + this.uploadPolicy.getFtpTransfertBinary() + ")", ioe);
        }
    }

    private void createDirectoryStructure(UploadFilePacket packet) throws JUploadIOException {
        TreeSet<String> foldersToCreate = new TreeSet<String>();
        for (UploadFileData uploadFileData : packet) {
            if (this.isInterrupted()) break;
            String folderName = uploadFileData.getRelativeDir();
            if (foldersToCreate.contains(folderName = folderName.replaceAll("\\\\", "/"))) continue;
            StringTokenizer st = new StringTokenizer(folderName, "/");
            String intermediateFolderName = this.ftpRootFolder;
            while (st.hasMoreTokens()) {
                if (foldersToCreate.contains(intermediateFolderName = intermediateFolderName + st.nextToken() + "/")) continue;
                this.uploadPolicy.displayDebug("FTP structure identification: Adding subfolder " + intermediateFolderName, 80);
                foldersToCreate.add(intermediateFolderName);
            }
        }
        try {
            for (String folder : foldersToCreate) {
                this.ftp.changeWorkingDirectory(folder);
                if (FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) {
                    this.uploadPolicy.displayDebug("[FileUploadThreadFTP] Folder " + folder + " already exist", 80);
                    continue;
                }
                this.ftp.mkd(folder);
                this.uploadPolicy.displayDebug("[FileUploadThreadFTP] Folder " + folder + " created", 80);
                if (FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode())) continue;
                throw new JUploadIOException("Error while creating folder '" + folder + "' (" + this.ftp.getReplyString().replaceAll("\r\n", "") + ")");
            }
        }
        catch (IOException ioe) {
            throw new JUploadIOException(ioe.getClass().getName() + " in FileUploadThreadFTP.createDirectoryStructure()", ioe);
        }
    }

    @Override
    void interruptionReceived() {
        this.cleanAll();
    }
}

