<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**

* Puslapio konfigūracijos valdymo klasė
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class SiteConfig
{
	/**
	*
	*
	*Gražinamas euro kaina litais
	*@return Numeric(7;4) euro kaina litais
	*/
	public function getEuroPrice()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$customerID = trim($customerID);
		$result= $db->query('select euro_price from site_options');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: SiteConfig->getEuroPrice()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*
	*
	*Gražinama pristatymo kaina litais
	*@return Numeric(7;4) pristatymo kaina litais
	*/
	public function getShipmentPrice()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$customerID = trim($customerID);
		$result= $db->query('select shipment_price from site_options');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: SiteConfig->getShipmentPrice()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	
	/**
	*Tikrinama ar nuotrauka
	*@param String $mimeType Failo tipas
	*@return Boolean true - picture $mimeType, false - not picture $mimeType
	*/
	public function checkMimeType($mimeType) 
	{
		if (strlen($mimeType) == 0) {
			return true;
		}
		$mimeType = trim($mimeType);
		if (preg_match("/image/",$mimeType)) {
			return true;
		} else {
			return false;
		}
	}
	
}


//$a = new Customer();
//print_r($a->checkNaturalPersonNameSurname('23232'));

?>