<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**

* Šioje klasėje realizuotos visos operacijos susijusios su administratoriaus valdymu
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Admin
{
	/**
	*
	*
	*Gražinamas administratoriaus identifikacinis numeris pagal pateikta vartotojo vardą ir slaptažodį
	*@param String $username administratoriaus pateiktas vartotojo vardas 
	*@param String $password administratoriaus pateiktas slaptažodis
	*@return Integer 0 - administratorius neegzistuoja, 1 ir daugiau - administratoriaus identifikacinis numeris
	*/
	public function getAdminID($username, $password)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		//$username = trim($username);
		//$password = trim($password);
		
		$types = array("text","text");

		$statement = $db->prepare('select id from owners where username=? and password=?',$types, MDB2_PREPARE_RESULT);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Admin->getAdminID(): fail prepare');
		}

		$data = array($username,$password);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Admin->getAdminID(): fail execute');
		}


	
		$db->disconnect();
		if ($result = $resultset->fetchRow()) {
			return $result[0];
		} else {
			return 0;
		}
	}
	
	
	/**
	*
	*
	*Gražinamas administratoriaus detalūs duomenys
	*@param Integer $id administratoriaus identifikacinis numeris
	*@return Array administratoriaus duomenys
	*/
	public function getAdminDetail($id)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		//$username = trim($username);
		//$password = trim($password);
		
		$types = array("integer");

		$statement = $db->prepare('select id,name,surname,username,password from owners where id=?',$types, MDB2_PREPARE_RESULT);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Admin->getAdminDetail(): fail prepare');
		}

		$data = array($id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Admin->getAdminDetail(): fail execute');
		}


	
		$db->disconnect();
		if ($result = $resultset->fetchRow()) {
			return $result;
		} 
	}
	
	/**
	*Slaptažodžio keitimas
	*@param String $password Naujas slaptažodis
	* 
	*/
	
	
	public function changePassword($password)
	{

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update site_admins set password=?');
		$data = array($password);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getDebugInfo();
			die('Kritinė klaida: Admin->changePassword()');
		}
		$db->disconnect();
	}
}