<?php

/**
* Prijungiama ConnectManagerMSSQL.class.php prisijungimo prie duomenų bazės klasių biblioteka 
*/
require_once('../classes/ConnectManagerMSSQL.class.php');

/**
* Prijungiama Logging.class.php istorijos žurnalų valdymo klasių biblioteka
*/
require_once('Logging.class.php');

/**

*Buhalterinės Apskaitos valdymo klasė
*
*@copyright Copyright 2009, Mindaugas Rimkus
*/
class Accountant
{
	
	/**
	*Gražinamas paskutinis DSG serijos sąskaitų numeris iš buhalterinės apskaitos programos 
	*@return Integer 
	*/

	public function checkLastDSGNo()
	{
	
		$connect = new ConnectManagerMSSQL();
		$db = $connect->getConnect();
		$res =  $db->query('SELECT max(cast(trim(\'DSG#\' from [Number]) as int)) FROM [CEPrekyba].[dbo].[BK1$THDocument] where Number like \'DSG#[0-9][0-9][0-9][0-9][0-9][0-9][0-9]\''); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Accountant->checkLastDSGNo()');
		}
		$row = $res->fetchRow();
		$maxNo = $row[0];
		if (strlen($row[0]) == 0) {
			$maxNo = 0;
		}
		$db->disconnect();
		return $maxNo;
	}

	/**
	*Patikriname ar egzistuoja kliento asmens kodas buhalterinėje programoje
	*@param String $code Kliento kodas
	*@return Integer 
	*	return value:
	*	1 - Egzistuoja
	*	0 - Neegzistuoja
	* 	2 - kodai kartojasi
	*/

	public function checkClientCode($code)
	{
	
		$connect = new ConnectManagerMSSQL();
		$db = $connect->getConnect();
		$res =  $db->query('SELECT IDC FROM [CEPrekyba].[dbo].[BK1$REFGenericClient] where Code like \''.$code.'\''); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Accountant->checkClientCode()');
		}
		$i = 0;
		while ($row = $res->fetchRow()) {
			$i++;
		}
		$db->disconnect();
		if ($i == 1) {
			return 1;
		} elseif ($i > 1) {
			return 2;
		} else {
			return 0;
		}	
	}
		
	

		
}
?>
