<?php
session_start();
//error_reporting(E_ALL);

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');

/**
* Prijungiama ../classes/Customer.class.php Klientų informacijos valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');


require_once("../classes/xajax/xajax_core/xajax.inc.php");

$xajax = new xajax();

$xajax->configure('javascript URI', '../classes/xajax/');

$xajax->registerFunction("getContracts");
$xajax->registerFunction("getContractsStatus");




$xajax->processRequest();


$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));

$smarty->assign('js',$xajax->getJavascript());

function getContracts($arg)
{
	$customer = new Customer();
	$contracts = $customer->getActiveCustomersContracts($arg);
	$objResponse = new xajaxResponse();
	$objResponse->script("document.getElementById('contract_id').options.length = 0;");
	for ($i=0; $i <count($contracts); $i++) {
		 //$newContent .= '<option value=\''.$desgi[$i][0].'\'>'.$desgi[$i][1].'</option>';
		 $objResponse->script("addOption('contract_id','".$contracts[$i][8]." - ".$contracts[$i][9]."/".$contracts[$i][10]." (".($contracts[$i][2]+0)." lt/mėn.)"."','".$contracts[$i][0]."')");
		//echo $desgi[$i][0]."<br />";
	}

   
    return $objResponse;
}

function getContractsStatus($arg)
{
	$customer = new Customer();
	$contracts = $customer->getActiveContract($arg);
	$objResponse = new xajaxResponse();
	//$objResponse->script("document.getElementById('contract_id').options.length = 0;");
	//for ($i=0; $i <count($contracts); $i++) {
		 //$newContent .= '<option value=\''.$desgi[$i][0].'\'>'.$desgi[$i][1].'</option>';
		// $objResponse->script("addOption('contract_id','".$contracts[$i][8]." - ".$contracts[$i][9]."/".$contracts[$i][10]." (".($contracts[$i][2]+0)." lt/mėn.)"."','".$contracts[$i][0]."')");
		//echo $desgi[$i][0]."<br />";
	//}

	$html = '';
	if ($contracts[19] == 'f') {
		$html = '<font class="normal" >Sutartis yra </font><font style="FONT-FAMILY: Verdana, Arial, Helvetica, Sans-serif; FONT-SIZE: 12px; COLOR: red;">Nutraukta</font>';
	} elseif ($contracts[33] == 't') {
		$html .= '<font class="normal" >Sutartis yra </font><font style="FONT-FAMILY: Verdana, Arial, Helvetica, Sans-serif; FONT-SIZE: 12px; COLOR: #f79d3c;">Pristabdyta</font><br /><font class="normal" >Pristabdyta nuo '.$contracts[17].' iki '.$contracts[18].'<br />Galiojimas nuo '.$contracts[14].' iki '.$contracts[15].'</font>';
	} elseif ($contracts[32] == 'f') {
		$html .= '<font class="normal" >Sutartis yra </font><font  style="FONT-FAMILY: Verdana, Arial, Helvetica, Sans-serif; FONT-SIZE: 12px; COLOR: #f6a9fb;">Negaliojanti</font>'.'<br /><font class="normal" >Galiojimas nuo '.$contracts[14].' iki '.$contracts[15].'</font>';
	} else {
		$html .= '<font class="normal" >Sutartis yra </font><font  style="FONT-FAMILY: Verdana, Arial, Helvetica, Sans-serif; FONT-SIZE: 12px; COLOR: #000000;">Galiojanti</font>'.'<br /><font class="normal" >Galiojimas nuo '.$contracts[14].' iki '.$contracts[15].'</font>';
	}
	
	
	$other_info = '<textarea rows="15" cols="40" name="">'.$contracts[21].'</textarea>';


	
	$objResponse->assign('payment_quantity', 'value', $contracts[13]+0);
    $objResponse->assign('answer', 'innerHTML', $html);
    $objResponse->assign('answer_1', 'innerHTML', $other_info);
    return $objResponse;
}


$customer = new Customer();





//$smarty->assign('customer',$customer->getCustomer($_GET['id']));

$smarty->assign('customers',@$customer->getActiveCustomers($_GET['owner_id']));
$smarty->assign('owners',$customer->getOwners());

//echo "<pre>";
//print_r($customer->getActiveCustomers());
//echo "</pre>";


$smarty->assign('owner_id',@$_GET['owner_id']);


if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	
	$smarty->assign('customer_regexp',$_POST['regexp']);
	$smarty->assign('customer_id',$_POST['customer_id']);
	
	
	$smarty->assign('contract_id',$_POST['contract_id']);
	
	if (strlen($_POST['customer_id']) > 0) {
		$smarty->assign('contracts',$customer->getActiveCustomersContracts($_POST['customer_id']));
	}
	
	$smarty->assign('payment_quantity',$_POST['payment_quantity']);
	$smarty->assign('inv_date',$_POST['inv_date']);
	
	
	$smarty->assign('purpose',$_POST['purpose']);
	


	$error = 0;
	if (strlen($_POST['customer_id']) == 0)  {
		$smarty->assign('customer_id_error',1);
		$error++;
	}
	if (strlen($_POST['contract_id']) == 0)  {
		$smarty->assign('contract_id_error',1);
		$error++;
	}
	if (!$customer->checkDigit($_POST['payment_quantity']))  {
		$smarty->assign('payment_quantity_error',1);
		$error++;
	}
	
	if (strlen($_POST['inv_date']) == 0)  {
		$smarty->assign('inv_date_error',1);
		$error++;
	}
	
	if (strlen($_POST['purpose']) == 0)  {
		$smarty->assign('purpose_error',1);
		$error++;
	}
	
	
	
	

	if (strlen($_FILES['inv_path']['tmp_name']) > 0 && !is_uploaded_file($_FILES['inv_path']['tmp_name']) ) {
		$error++;
		$smarty->assign('inv_path_error',1);
	}

	if ($error == 0) {
		//echo "gerai";
		//echo time();
		
		$invoice_path = "";
		if (is_uploaded_file($_FILES['inv_path']['tmp_name'])) {
			$invoice_path = '../invoices/'.time().$_FILES['inv_path']['name'];
			move_uploaded_file($_FILES['inv_path']['tmp_name'], $invoice_path);
		}
		$smarty->assign('contr',$customer->getActiveContract($_POST['contract_id']));
		$smarty->assign('insert_success',1);

		
		$customer->insertInvoice($_POST['payment_quantity'],$_POST['contract_id'],$_POST['inv_date'],$invoice_path,$_POST['purpose']);
		$invLast = $customer->getInvoiceLast();
		$smarty->assign('inv_last',$invLast[32]);
		//echo "<script language='javascript'>this.location = 'customer_detail.php?id=".$_GET['id']."&type=".$_GET['type']."&success=1'</script>";
		//return ;
	}
	$smarty->assign('error',$error);
}





$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/insert_invoice.tpl');
}


?>