<?php
session_start();
/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Customer.class.php Klientų informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');

/**
* Prijungiama ../classes/Customer.class.php Klientų informacijos valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');

require_once("../classes/xajax/xajax_core/xajax.inc.php");

$xajax = new xajax();

$xajax->configure('javascript URI', '../classes/xajax/');

$xajax->registerFunction("insertInvoice");
$xajax->registerFunction("generateCustomers");


$xajax->processRequest();



$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));

$smarty->assign('js',$xajax->getJavascript());


$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);

$customer = new Customer();



function insertInvoice($contractID,$money,$date,$payment_id,$useCash)
{
	$objResponse = new xajaxResponse();
	$customer = new Customer();
	$invoice = $customer->getLastInvoiceByContract($contractID);
	$custData = $customer->getCustomerContract($contractID);
	

		
	if ($invoice != null) {

		$res = $customer->setPayment($invoice[32],$contractID,$money,$date,$payment_id,$useCash);
	} else {
		$res = 3;
	}
	$checking = $customer->getSumByBankTransferID($payment_id);
	
	if ($res == 1) {
		$objResponse->assign('button'.$payment_id, 'innerHTML','<table><tr><td valing="center"><img src="pics/full.png" /></td><td valing="center"><font style="color:green;">Importuota '.$checking.'€</font></td></tr></table>');
	} elseif ($res == 3) {
		$objResponse->assign('button'.$payment_id, 'innerHTML',$invoice[32].'<table><tr><td valing="center"><img src="pics/not_pay.png" /></td><td valing="center"><font style="color:red;"><b>Neišrašyta nei viena sąskaita. Neimportuota!</b> </font><a class="cart" href="mailto:mindaugas.rimkus@disigma.lt?subject=Neišrašyta sąskaita!&body='.$custData[1].' '.$custData[4].' '.$custData[5].'%0d%0a'.$custData[12].' '.$date.' '.$money.'">Praneškite!</a></td></tr></table>');
		//'.$custData[1].' '.$custData[4].' '.$custData[5].'%0d%0a'.$custData[12].' '.$date.' '.$money.'
	} else {
		$objResponse->assign('button'.$payment_id, 'innerHTML','<table><tr><td valing="center"><img src="pics/not_pay.png" /></td><td valing="center"><font style="color:red;"><b>Transakcijos klaida. Importuota '.$checking.'€</b></font></td></tr></table>');
	}
	$objResponse->assign('customers'.$payment_id, 'disabled ','true');
	$objResponse->assign('search'.$payment_id, 'disabled ','true');
    return $objResponse;
}

function generateCustomers($payment_id,$search,$paymentDescription,$paymentQuantity,$paymentDate,$useCash)
{
	$objResponse = new xajaxResponse();
	$customer = new Customer();
	$allCustomers = $customer->getActiveCustomersBySwedbankPaymentDescription($search,$paymentDescription);
	$count = count($allCustomers);
	
	$current_select = '<select style="width:280px;"    name="customers'.$payment_id.'" id="customers'.$payment_id.'" size="3" onchange="alert(\'Kritinė klaida. Pranešti!\')">';
	
		foreach ($allCustomers  as $cust){
			if ($count == 1) {
				$current_select .= '<option selected="selected" value="'.$cust[12].'">'.$cust[12].' - '.$cust[1].' '.$cust[4].' '.$cust[5].' - '.$cust[2].' - '.$cust[13].' €/mėn.</option>';
			} else {
				$current_select .= '<option value="'.$cust[12].'">'.$cust[12].' - '.$cust[1].' '.$cust[4].' '.$cust[5].' - '.$cust[2].' - '.$cust[13].' €/mėn.</option>';
			}
		}
	$current_select .= '</select>';
	
	if ($count != 1) {
		$objResponse->assign('button'.$payment_id, 'innerHTML','');
		$objResponse->assign('searchbutton'.$payment_id, 'innerHTML','');
	} else {
		//$invoice = $customer->getLastInvoiceByContract($allCustomers[0][12]);
		$objResponse->assign('button'.$payment_id, 'innerHTML',"<input type='button' onclick='xajax_insertInvoice(".$allCustomers[0][12].",".trim($paymentQuantity).",\"".trim($paymentDate)."\",\"".trim($payment_id)."\",".$useCash.")' value='Importuoti mokėjimą' />");
		$objResponse->assign('searchbutton'.$payment_id, 'innerHTML','<input type=\'button\' target=\'_blank\' onclick="window.open(\'http://mano.bitnet.lt/admin/invoices.php?scroll=1&search='.$allCustomers[0][2].'\')" value=\'Surasti\' />');
		//window.open(http://mano.bitnet.lt/admin/invoices.php?scroll=1&search=)
		
	}
	
	$objResponse->assign('customers'.$payment_id, 'innerHTML',$current_select);

    return $objResponse;
}


$error = 0;
//echo  $customer->setPayment(48732,1,'2022-99-99s');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

	
	

	if (strlen($_FILES['inv_path']['tmp_name']) > 0 && !is_uploaded_file($_FILES['inv_path']['tmp_name']) ) {
		$error++;
		$smarty->assign('inv_path_error',1);
	}
	if (!$customer->checkCsvExt($_FILES['inv_path']['name'])) 
	{
		$error++;
		$smarty->assign('file_type_error',1);
	}
	$smarty->assign('file_name',$_FILES['inv_path']['name']);
	

	if ($error == 0) {
	$lines = @file($_FILES['inv_path']['tmp_name']);
	
	

	unset($lines[0]);
	unset($lines[count($lines)]);
	unset($lines[count($lines)]);
	unset($lines[count($lines)]);




	$error_dates = 0;
	$error_money = 0;
	$output = "<table id='data' cellpadding='3' border='0'>";
	$importArray = array();
	$tableIndex = 1;
	
	$countArray = array();
	$paymentCount = 0;
	$useUtfConvertionFromAnsi = 0;
	$useCash = 0;
	foreach ($lines as $line_num => $line) {

		$payment_line = explode('","', $line);
		$date = $payment_line[2];
		//echo $useUtfConvertionFromAnsi;
		if ($payment_line[3] == '' && $payment_line[4] == 'Likutis pradžiai') {
			$useUtfConvertionFromAnsi = 1;
			$useCash = 1;
			//echo 'ok';
			continue;
		} elseif ($useUtfConvertionFromAnsi != 1) {
			$payer_name = iconv('iso-8859-13', 'UTF-8', $payment_line[3]);
			$pay_description = iconv('iso-8859-13', 'UTF-8', $payment_line[4]);
		} else {
			//echo 'else';
			$payer_name = $payment_line[3];
			$pay_description = $payment_line[4];
		}
 		
		
		$payer_name = str_replace('"', '', $payer_name);
		$payer_name_short_arr = explode('|', $payer_name);

		
		$payment_quantity = $payment_line[5];
		$payment_type = $payment_line[7];
		$payment_id = $payment_line[8];
		
		if ($payment_line[4] == 'Likutis pradžiai') {
			continue;
		}
		
		$count = 0;
		if ($payment_type != 'K') {
			continue;
		}
		$paymentCount++;
		
		$importedCustomersData = $customer->getNamesByBankTransferID($payment_id);
		
		$current_select = '<select style="width:280px;"    name="customers'.$payment_id.'" id="customers'.$payment_id.'" size="3" onchange="generateButton(\''.$payment_id.'\','.trim($payment_quantity).',\''.trim($date).'\','.$useCash.')" >';
		//<input type="button" onclick="xajax_insertInvoice('.$invoice[32].','.$invoice[12].','.trim($payment_quantity).',\''.trim($date).'\',\''.trim($payment_id).'\')" value="Importuoti mokėjimą" />
		$allCustomers = $customer->getActiveCustomersBySwedbankPaymentDescription(trim($payer_name_short_arr[0]),$pay_description);
		$count = count($allCustomers);
		foreach ($allCustomers  as $cust){
			if ($count == 1) {
				$current_select .= '<option selected="selected" value="'.$cust[12].'">'.$cust[12].' - '.$cust[1].' '.$cust[4].' '.$cust[5].' - '.$cust[2].' - '.$cust[13].' €/mėn.</option>';
			} else {
				$current_select .= '<option value="'.$cust[12].'">'.$cust[12].' - '.$cust[1].' '.$cust[4].' '.$cust[5].' - '.$cust[2].' - '.$cust[13].' €/mėn.</option>';
			}
			//$current_select .= '<option value="123">'.$cust[4].'</option>';
		}
		$current_select .= '</select>';
		
		if (count($importedCustomersData)>0 ) {
			$current_select = '';
		}
			
	
		$moneySum = $payment_quantity;

		
		$names = '';
		foreach ($importedCustomersData  as $imp){
			$names .= '<font size=-1>'.$imp[0].' '.$imp[4].' '.$imp[1].' '.$imp[2].' '.$imp[3].' - '.$imp[5].'€<br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</font>';
		}
		
		if (count($importedCustomersData) > 0) {
			$searchButton =  "<input  type='button' value='Surasti' target='_blank' onclick='window.open(\"http://mano.bitnet.lt/admin/invoices.php?scroll=1&search=".$importedCustomersData[0][2]."\")'/>";
		} elseif ($count == 1 ) {
			$searchButton =  "<input  type='button' value='Surasti' target='_blank' onclick='window.open(\"http://mano.bitnet.lt/admin/invoices.php?scroll=1&search=".$allCustomers[0][2]."\")'/>";
		} else {
			$searchButton = '';
		}
			
		
		$name = $customer->getCustomerNameByContract($code+0);
		
		if (!$customer->checkDate1($date)) {$error_dates = 1; $error++;}
		if (!$customer->checkDigit($moneySum)) {$error_money = 1;$error++;}
		//$importArray[] = array($_FILES['inv_path']['name'],$code+0,$date,$moneySum);
		$invoice = null;
		$importedMoney = $customer->getSumByBankTransferID($payment_id);
		if ($count == 1 || $importedMoney > 0) {
			
			
			if ($importedMoney > 0 && $payment_quantity<$importedMoney) {
				$output .= "<tr><td></td><td colspan='5'><font style='color:red;'><b>Mokėjimas anksčiau per daug importuotas ".$importedMoney."€. Patikrinkite! <br />Mokėtojai: ".$names."</b></font></td></tr>";
			}
			if ($importedMoney > 0 && $payment_quantity>$importedMoney) {
				$output .= "<tr><td></td><td colspan='5'><font style='color:red;'><b>Mokėjimas anksčiau importuotas nepilnai ".$importedMoney."€. Patikrinkite! <br />Mokėtojai: ".$names."</b></font></td></tr>";
			}
			if ($importedMoney == $payment_quantity && count($importedCustomersData) > 1) {
				$output .= "<tr><td></td><td colspan='5'><font style='color:red;'><b>Mokėjimas anksčiau importuotas pilnai, tačiau rasta per daug mokėtojų ".$importedMoney."€. Patikrinkite! <br />Mokėtojai: ".$names."</b></font></td></tr>";
			}
			if ($importedMoney == $payment_quantity && count($importedCustomersData) == 1) {
				$output .= "<tr><td></td><td colspan='5'><font style='color:green;'><b>Importuotas sėkmingai! ".$importedMoney."€ <br />Mokėtojas: ".$names."</b></font></td></tr>";
			}
			if ($importedMoney == 0) {
				$invoice = $customer->getLastInvoiceByContract($allCustomers[0][12]);
			}
			$importButton = '';
			if ($importedMoney == 0 && $invoice != null) {
				
				$importButton = "<div id='button".$payment_id."' name='button".$payment_id."'><input type='button' onclick='xajax_insertInvoice(".$invoice[12].",".trim($payment_quantity).",\"".trim($date)."\",\"".trim($payment_id)."\",".$useCash.")' value='Importuoti mokėjimą' /></div>";
			}
			
			if ($invoice == null && $importedMoney == 0) {
				$output .= "<tr><td></td><td colspan='5'><font style='color:red;'><b>Negalima importuoti, kadangi dar neišrašyta nei viena sąskaita.</b> <a class='cart' href='mailto:mindaugas.rimkus@disigma.lt?subject=Neišrašyta sąskaita!&body=".$allCustomers[0][1]." ".$allCustomers[0][4]." ".$allCustomers[0][5]."%0d%0a".$allCustomers[0][12]." ".$date." ".$payment_quantity."'>Praneškite!</a></font></td></tr>";
			}	
			
		} 
		if (strlen($importButton) == 0) {
			$importButton = "<div id='button".$payment_id."' name='button".$payment_id."'></div>";
		}

		$output .=  "<tr id='".$payment_id."'><td rowspan='2' valign=\"top\">".$tableIndex.".</td><td valign=\"top\"><input type='button' value='-' onclick='$(\"#".$payment_id."\").remove();$(\"#".$payment_id."second\").remove();' /></td><td valign=\"top\"><b>".$date."</b></td><td valign=\"top\">    <input id='search".$payment_id."' name=\"regexp\" ".(count($importedCustomersData)>0?"disabled='disabled'":"")." value=\"".trim($payer_name_short_arr[0])."\" onkeyup=\"xajax_generateCustomers('".$payment_id."',this.value,'".$pay_description."','".$payment_quantity."','".$date."',".$useCash.")\"  onkeyup=\"myfilter.set(this.value)\" style=\"width:129px\" />   </td><td>".$current_select." </td><td valign=\"top\"><b>".$moneySum."€</b></td><td valign=\"top\"><div id='searchbutton".$payment_id."'>".$searchButton."</div><hr />".$importButton."</td></tr>";
		$output .= "<tr id='".$payment_id."second'><td></td><td colspan='5'><font color=\"#15786b\"><b>$payer_name</b><br /><b>$date - $payment_quantity Eur</b> &nbsp;&nbsp;ID: $payment_id<br />$pay_description</font><hr /><br /></td></tr>";
		 
		$importButton = '';
		 


		
	$tableIndex++;	
		
	}
	
	$smarty->assign('payments_count',$paymentCount);

	

	
	
	$output .= "</table>";
	$smarty->assign('error_dates',$error_dates);
	$smarty->assign('error_money',$error_money);
	
		
	}
	if ($error == 0) {$smarty->assign('output',$output);}
}

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/bank_generator.tpl');
}



?>