// $HeadURL: https://joomgallery.org/svn/joomgallery/JG-1.5/Module/JoomImages/branches/JGMVC/helper.php $
// $Id: helper.php 2058 2010-04-10 09:40:15Z aha $
/**
* Module JoomImages 1.5
* by JoomGallery::Project Team
* @package JoomGallery
* @Copyright JoomGallery team
* @ All rights reserved
* @ Joomla Open Source is Free Stuff
* @ Released under GnuGPL License.
**/
var JoomImgPagination = new Class({
  options:
  {
      moduleid: 1,
      pagpersite: 2,
      csstag: ''
  },
  initialize: function(options)
  {
    this.setOptions(options);
    this.pagination = $(this.options.csstag+'pagnavi');

    // Visible images
    this.images = $$('div.'+this.options.csstag+'imgct');
    this.imgct = this.images.length;

    // Hidden images
    this.hiddenimages = $$('div.'+this.options.csstag+'pagelem');
    this.hiddenimgct = this.hiddenimages.length;

    // *** Events ***
    // Active pagination link(s)
    this.paglinks= $$('span.'+this.options.csstag+'paglink','span.'+this.options.csstag+'paglinkactive');
    this.paglinks.each(function(link)
    {
      // Mouse hover, not for active link
      link.addEvent('mouseover',function(event){
        if (link.className.indexOf('paglinkactive')==-1)
        {
          this.setStyle('cursor','pointer');
        }
      });
      // Click
      link.addEvent('click',function(event){
        if (link.className.indexOf('paglinkactive')==-1)
        {
          // Get the target element, different in IE
          var target=(event.target) ? event.target.textContent : event.srcElement.innerText;
          destpage=parseInt(target);
          // Calculate the starting hidden image
          starthdimage = (destpage -1) * this.options.pagpersite + 1;
          endhdimage = starthdimage + this.options.pagpersite;
          if (endhdimage > this.hiddenimgct)
          {
            endhdimage = this.hiddenimgct;
          }
          // Change the elements
          tgtimg=0;
          for (srcimg = starthdimage,tgtimg=0; srcimg <= endhdimage; srcimg++,tgtimg++)
          {
            // Check first if target container exists
            if ($chk(this.images[tgtimg]))
            {
              this.changeelemes(this.hiddenimages[srcimg-1], this.images[tgtimg]);
              this.images[tgtimg].setStyle('display','inline');
            }
          }
          // Hide non used containers
          for (x=tgtimg; x <= this.options.pagpersite-1;x++)
          {
            this.images[x].setStyle('display','none');
          }
          // Change class for new active link
          activepaglink=$$('span.'+this.options.csstag+'paglinkactive')[0];
          activepaglink.className=this.options.csstag+'paglink';

          // IE
          if (typeof event.target =='undefined')
          {
            event.srcElement.className = this.options.csstag+'paglinkactive';
          }
          else
          {
            event.target.className = this.options.csstag+'paglinkactive';
          }
        }
      }.bind(this));
    }.bind(this));
  },
  changeelemes: function(source, target)
  {
    clone = source.clone(true, true);
    // Get all children of clone and target
    childrenclone = clone.getChildren();
    childrentarget = target.getChildren();
    // Replace the children if existent
    if($chk(childrentarget[0]) && $chk(childrenclone[0]))
    {
      childrentarget[0].replaceWith(childrenclone[0]);
    }
    if($chk(childrentarget[1]) && $chk(childrenclone[1]))
    {
      childrentarget[1].replaceWith(childrenclone[1]);
    }
  }
});
JoomImgPagination.implement(new Options);
