<?php
/**
* @version $Id: mod_banners.php 6087 2006-12-24 18:59:57Z robs $
* @package Joomla
* @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

global $mainframe;
$document = JFactory::getDocument();

// clientids must be an integer
$api = $params->get( 'api', '' );
$height = $params->get( 'height', '500' );
$width = $params->get( 'width', '500' );
$lat = $params->get( 'lat', '0' );
$long = $params->get( 'long', '0' );
$zoom = $params->get( 'zoom', '5' );
$lat1 = $params->get( 'lat1', '1' );
$lat2 = $params->get( 'lat2', '2' );
$lat3 = $params->get( 'lat3', '3' );
$long1 = $params->get( 'long1', '1' );
$long2 = $params->get( 'long2', '2' );
$long3 = $params->get( 'long3', '3' );
$html1 = $params->get( 'html1', '' );
$html2 = $params->get( 'html2', '' );
$html3 = $params->get( 'html3', '' );
$title1 = $params->get( 'title1', '' );
$title2 = $params->get( 'title2', '' );
$title3 = $params->get( 'title3', '' );
$pub1 = $params->get( 'pub1', '' );
$pub2 = $params->get( 'pub2', '' );
$pub3 = $params->get( 'pub3', '' );
$mapType = $params->get( 'mapType', 'G_NORMAL_MAP' );

$mapCSS = "#map {
	border:		1px solid #ddd;
	height:		".$height."px;
	width:		".$width."px;
}";

$document->addStyleDeclaration($mapCSS);

?>
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;key=<?php echo $api ?>" type="text/javascript"></script>
<div id="map"></div>
   <!-- fail nicely if the browser has no Javascript -->
    <noscript><b>JavaScript must be enabled in order for you to use Google Maps.</b> 
      However, it seems JavaScript is either disabled or not supported by your browser. 
      To view Google Maps, enable JavaScript by changing your browser options, and then 
      try again.
    </noscript>
<script type="text/javascript">
    //<![CDATA[

    // Check to see if this browser can run the Google API
    if (GBrowserIsCompatible()) {

      var gmarkers = [];
      var htmls = [];
      var to_htmls = [];
      var from_htmls = [];
      var i=0;

      // A function to create the marker and set up the event window
      function createMarker(point,name,html) {
        var marker = new GMarker(point);

        // The info window version with the "to here" form open
        to_htmls[i] = html + '<br>Directions: <b>To here</b> - <a href="javascript:fromhere(' + i + ')">From here</a>' +
           '<br>Start address:<form action="http://maps.google.com/maps" method="get" target="_blank">' +
           '<input type="text" SIZE=40 MAXLENGTH=40 name="saddr" id="saddr" value="" /><br>' +
           '<INPUT value="Get Directions" TYPE="SUBMIT">' +
           '<input type="hidden" name="daddr" value="' + point.lat() + ',' + point.lng() + 
                  // "(" + name + ")" + 
           '"/>';
        // The info window version with the "to here" form open
        from_htmls[i] = html + '<br>Directions: <a href="javascript:tohere(' + i + ')">To here</a> - <b>From here</b>' +
           '<br>End address:<form action="http://maps.google.com/maps" method="get"" target="_blank">' +
           '<input type="text" SIZE=40 MAXLENGTH=40 name="daddr" id="daddr" value="" /><br>' +
           '<INPUT value="Get Directions" TYPE="SUBMIT">' +
           '<input type="hidden" name="saddr" value="' + point.lat() + ',' + point.lng() +
                  // "(" + name + ")" + 
           '"/>';
        // The inactive version of the direction info
        html = html + '<br>Directions: <a href="javascript:tohere('+i+')">To here</a> - <a href="javascript:fromhere('+i+')">From here</a>';

        GEvent.addListener(marker, "click", function() {
          marker.openInfoWindowHtml(html);
        });
        gmarkers[i] = marker;
        htmls[i] = html;
        i++;
        return marker;
      }

      // functions that open the directions forms
      function tohere(i) {
        gmarkers[i].openInfoWindowHtml(to_htmls[i]);
      }
      function fromhere(i) {
        gmarkers[i].openInfoWindowHtml(from_htmls[i]);
      }

      // Display the map, with some controls and set the initial location 
      var map = new GMap2(document.getElementById("map"));
	  map.setMapType(<?php echo $mapType;?>);
      map.addControl(new GLargeMapControl());
      map.addControl(new GMapTypeControl());
      map.setCenter(new GLatLng( <?php echo $lat ?>,<?php echo $long ?>), <?php echo $zoom ?>);
    
      // Set up three markers with info windows 
    <?php if ($pub1 == "yes") : ?>
      //1
      var point = new GLatLng( <?php echo $lat1 ?>,<?php echo $long1 ?>);
      var marker = createMarker(point,' <?php echo $title1 ?>','<?php echo $html1 ?>')
      map.addOverlay(marker);
      <?php endif; ?>	
	<?php if ($pub2 == "yes") : ?>
      //2
      var point = new GLatLng( <?php echo $lat2 ?>,<?php echo $long2 ?>);
      var marker = createMarker(point,' <?php echo $title2 ?>','<?php echo $html2 ?>')
      map.addOverlay(marker);
      <?php endif; ?>	
<?php if ($pub3 == "yes") : ?>
      //3
      var point = new GLatLng( <?php echo $lat3 ?>,<?php echo $long3 ?>);
      var marker = createMarker(point,'<?php echo $title3 ?>','<?php echo $html3 ?>')
      map.addOverlay(marker);
      <?php endif; ?>	
    }

    
    // display a warning if the browser was not compatible
    else {
      alert("Sorry, the Google Maps API is not compatible with this browser");
    }

    // This Javascript is based on code provided by the
    // Blackpool Community Church Javascript Team
    // http://www.commchurch.freeserve.co.uk/   
    // http://econym.googlepages.com/index.htm

    //]]>
</script>


