<?php
// $HeadURL: https://joomgallery.org/svn/joomgallery/JG-1.5/Module/JoomImages/trunk/helper.php $
// $Id: helper.php 2343 2010-09-01 17:30:25Z aha $
/**
* Module JoomImages 1.5
* by JoomGallery::Project Team
* @package JoomGallery
* @Copyright JoomGallery team
* @ All rights reserved
* @ Joomla Open Source is Free Stuff
* @ Released under GnuGPL License.
**/

/// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Helper class for module JoomImages
 *
 * @category Modules
 * @package  JoomImages
 * @author   JoomGallery team <team@joomgallery.net>
 * @version  Release <1.5>
 * @link
 * @license GPL
 *
 *
 */
class modJoomImagesHelper extends joominterface
{
  // Own class variable because db->escaped strips the ""
  var $scrollmousecode;

  /**
   * entry function
   *
   * @param object $params - backend parameters
   * @param object $modObject - interface object
   * @return object - picture objects
   */
  function fillObject(&$params,&$moduleid)
  {
    $doc = &JFactory::getDocument();

    // Read the parameters
    $this->getParams($params, $moduleid);

    // Get the images
    if($this->cmttest("sort"))
    {
      if($this->getConfig('sorting')=="commentrand")
      {
        $objects = $this->getDBComments("rand()");
      }
      else
      {
        $objects = $this->getDBComments($this->getConfig('sorting'));
      }
    }
    else
    {
      $objects = $this->getDBImages();
    }

    // *** Slideshow ***
    if($this->getConfig('slideshowthis') == 1)
    {
      // Include javascripts
      JHTML::_('behavior.mootools');
      $doc->addScript(JURI::base().'modules/mod_joomimg/assets/slideshow.js');
    }
    else
    {
      // Modify content of images for default view
      $this->modContent($objects);

      // Include Pagination javascript if activated
      if ($this->getConfig('pagination'))
      {
        JHTML::_('behavior.mootools');
        $doc->addScript(JURI::base().'modules/mod_joomimg/assets/pagination.js');

        $jsstart="window.addEvent('domready', function(){
          var joomimgpagination$moduleid = new JoomImgPagination(
          {
            moduleid:$moduleid,
            pagpersite: ".$this->getConfig('paginationct').",
            csstag: '".$this->getConfig('csstag')."'
            });
        });";
        $doc->addScriptDeclaration($jsstart);
      }
      // Create and include the dynamic css for default view
      // according to backend settings
      $this->renderCSS();
    }
    //include common css
    $doc->addStyleSheet(JURI::base().'modules/mod_joomimg/assets/mod_joomimg.css');
    return $objects;
  }

  /**
   * get the params setted in module backend
   *
   * @param object $params - backend parameters
   */
  function getParams(&$params,&$moduleid)
  {
    //get the parameters and add them to the config
    $this->addConfig('group', 'joomgallerymodji');
    $this->addConfig('Itemid', $params->get('Itemid', ''));
    $this->addConfig('limit', $params->get('limit', 4));
    $this->addConfig('img_per_row', $params->get('img_per_row', 2));
    $this->addConfig('sorting', $params->get('sorting', 'rand()'));
    $this->addConfig('resultbytime', $params->get('resultbytime', 0));
    $this->addConfig('cats', $params->get('cats', ''));
    $this->addConfig('showorhidecats', $params->get('showorhidecats', 1));
    $this->addConfig('includesubcats', $params->get('includesubcats', 0));
    $this->addConfig('dynamiccats', $params->get('dynamiccats', 0));
    $this->addConfig('pagination', $params->get('pagination', 0));
    $this->addConfig('paginationct', $params->get('paginationct', 0));
    $this->addConfig('paginationpos', $params->get('paginationpos', 0));

    // Deactivate pagination if number of images per site >= limit
    if ($this->getConfig('paginationct') >= $this->getConfig('limit'))
    {
      $this->addConfig('pagination', 0);
    }

    $this->addConfig('crop_img', $params->get('crop_img', 0));
    $this->addConfig('crop_sizewidth', $params->get('crop_sizewidth', 50));
    $this->addConfig('crop_sizeheight', $params->get('crop_sizeheight', 150));
    $openimage = $params->get('openimage', 'default');
    if($openimage == 'cat')
    {
      $this->addConfig('catlink', 1);
    }
    else
    {
      if($openimage != 'default' && $openimage != 'none')
      {
        $this->addConfig('openimage', $openimage);
      }
    }
    if($openimage == 'none')
    {
      $this->addConfig('setjilink', 0);
    }
    else
    {
      $this->addConfig('setjilink', 1);
    }

    $this->addConfig('show_empty_message', $params->get('show_empty_message', 1));
    $this->addConfig('image_position', $params->get('image_position', 1));
    $this->addConfig('auto_resize', $params->get('auto_resize', 0));
    $this->addConfig('auto_resize_max', $params->get('auto_resize_max', 100));
    $this->addConfig('imgwidth', $params->get('imgwidth', 0));
    $this->addConfig('imgheight', $params->get('imgheight', 0));
    $this->addConfig('showtext', $params->get('showtext', 1));
    $this->addConfig('showtitle', $params->get('showtitle', 1));
    $this->addConfig('strtitlewrap', $params->get('strtitlewrap', 0));
    $this->addConfig('showdescription', $params->get('showdescription', 0));
    $this->addConfig('strdescount', $params->get('strdescount', 0));
    $this->addConfig('strdeswrap', $params->get('strdeswrap', 0));
    $this->addConfig('showauthor', $params->get('showuser', 0));
    $this->addConfig('showcategory', $params->get('showcatg', 0));
    $this->addConfig('showhits', $params->get('showhits', 0));
    $this->addConfig('showvotesum', $params->get('showvotesum', 0));
    $this->addConfig('showrate', $params->get('showvotes', 0));
    $this->addConfig('showimgdate', $params->get('showimgdate', 0));
    $this->addConfig('showcmtdate', $params->get('showcmtdate', 0));
    $this->addConfig('showcmttext', $params->get('showcmttext', 0));
    $this->addConfig('shownumcomments', $params->get('showcmtcount', 0));
    $this->addConfig('strcmtcount', $params->get('strcmtcount', 0));
    $this->addConfig('strcmtwrap', $params->get('strcmtwrap', 0));
    $this->addConfig('showcmtmore', $params->get('showcmtmore', 0));
    $this->addConfig('scrollthis', $params->get('scrollthis', 0));
    $this->addConfig('scrolldirection', $params->get('scrolldirection', 'left'));
    $this->addConfig('scrollheight', $params->get('scrollheight', 250));
    $this->addConfig('scrollwidth', $params->get('scrollwidth', 230));
    $this->addConfig('scrollamount', $params->get('scrollamount', 1));
    $this->addConfig('scrolldelay', $params->get('scrolldelay', 10));
    $this->scrollmousecode=($params->get('scrollmouse', 1)==1) ? "onmouseover=\"this.stop()\" onmouseout=\"this.start()\"" : "";
    $this->addConfig('dir_hor', $params->get('dir_hor', 'left'));
    $this->addConfig('dir_vert', $params->get('dir_vert', 'top'));
    $this->addConfig('sectiontableentry', $params->get('sectiontableentry', 0));

    $this->addConfig('slideshowthis', $params->get('slideshowthis', 0));

    if(  $this->getConfig('showtext')        == 1
      && $this->getConfig('showtitle')       == 0
      && $this->getConfig('showdescription') == 0
      && $this->getConfig('showauthor')      == 0
      && $this->getConfig('showcategory')    == 0
      && $this->getConfig('showhits')        == 0
      && $this->getConfig('showvotesum')     == 0
      && $this->getConfig('showvotes')       == 0
      && $this->getConfig('showimgdate')     == 0
      && $this->getConfig('showcmtdate')     == 0
      && $this->getConfig('showcmttext')     == 0
      && $this->getConfig('shownumcomments') == 0 )
    {
      $this->addConfig('showtext', 0);
    }
    $this->addConfig('type', $params->get('type', 'thumb'));
    $this->addConfig('piclinkslideshow', $params->get('piclinkslideshow', 0));
    $this->addConfig('showCaption', $params->get('showCaption', 1));
    $this->addConfig('showTitleCaption', $params->get('showTitleCaption', 1));
    $this->addConfig('heightCaption', $params->get('heightCaption', 45));
    $this->addConfig('width', $params->get('width', 400));
    $this->addConfig('height', $params->get('height', 300));
    $this->addConfig('imageDuration', $params->get('imageDuration', 9000));
    $this->addConfig('transDuration', $params->get('transDuration', 2000));
    $this->addConfig('transType', $params->get('transType', 'combo'));
    $this->addConfig('transition', $params->get('transition', 'Expo.easeOut'));
    $this->addConfig('pan', $params->get('pan', 50));
    $this->addConfig('zoom', $params->get('zoom', 50));
    $this->addConfig('loadingDiv', $params->get('loadingDiv', 1));
    $this->addConfig('imageResize', $params->get('imageResize', 1));
    $this->addConfig('titleSize', $params->get('titleSize', '13px'));
    $this->addConfig('titleColor', $params->get('titleColor', '#fff'));
    $this->addConfig('descSize', $params->get('descSize', '11px'));
    $this->addConfig('descColor', $params->get('descColor', '#ccc'));

    $this->addConfig('csstag', "joomimg".$moduleid."_");

    //CSS border
    $this->addConfig('border', $params->get('border', 0));
    $this->addConfig('borderwidth', $params->get('borderwidth', '2px'));
    $this->addConfig('borderstyle', $params->get('borderstyle', 'solid'));
    $this->addConfig('bordercolor', $params->get('bordercolor', '#000'));
    $this->addConfig('borderpadding', $params->get('borderpadding', '2px'));
  }


  /**
   * assemble the query for reading the picture data from database
   * without comments
   *
   * @return object - picture objects
   */
  function getDBImages()
  {
    $database = & JFactory::getDBO();
    $user = & JFactory::getUser();
    $limit=$this->getConfig('limit');
    $sorting=$this->getConfig('sorting');

    // Sorting by date of nametags
    if (stristr($sorting, 'n.ndate'))
    {
      if ($this->getJConfig('jg_nameshields') == 0 )
      {
       return null;
      }
      else if (!$user->get('aid') && !$this->getJConfig('jg_nameshields_unreg'))
      {
       return null;
      }
    }

    $query  = 'SELECT p.id as id, p.catid, p.imgthumbname,p.imgfilename,p.imgdate,'
              .'p.imgtitle, p.imgtext,p.imgauthor,p.owner,p.hits,p.imgvotes,'
              .'(p.imgvotesum/p.imgvotes) AS vote,c.cid AS ccid,c.name AS cattitle,c.catpath as catpath';

    // Check if any comments options activated
    if($this->cmttest("cmttext"))
    {
      $query .= ',count(co.cmtid) AS cmtcount,co.userid as cmtuserid, co.cmttext, co.cmtdate, co.cmtname, co.cmtid as commentid';
    }
    $query .= ' FROM #__joomgallery as p'
             .' JOIN #__joomgallery_catg as c ON c.cid=p.catid';

    // Sorting by date of nametags
    if (stristr($sorting, 'n.ndate'))
    {
      $query .= ' JOIN #__joomgallery_nameshields as n ON n.npicid=p.id';
    }

    // Check if any comments options activated
    if($this->cmttest("cmttext"))
    {
      $query .= ' JOIN #__joomgallery_comments as co ON co.cmtpic=p.id';
    }
    $query .= ' WHERE c.published=1 AND c.access<='.$user->get('aid')
             .' AND p.published=1 AND p.approved=1';

    // Check the current category shown in JoomGallery
    if($this->getConfig('dynamiccats') && $this->checkifincat())
    {
      $query .= ' AND p.catid = '.$this->getactcat();
    }

    // Show or hide categories
    if($this->getConfig('cats'))
    {
      $query .= ' AND p.catid';
      $query .= ($this->getConfig('showorhidecats')==1) ? ' IN' : ' NOT IN';

      if ($this->getConfig('includesubcats'))
      {
        // Include subcategories
        $catsincsubcats = $this->getSubcategories($this->getConfig('cats'));
        $query .= ' ('.$catsincsubcats.')';
      }
      else
      {
        $query .= ' ('.$this->getConfig('cats').')';
      }
    }

    // Timespan filter
    if($this->getConfig('resultbytime') != 0)
    {
      $query .= $this->getSQLTimestring($this->getConfig('resultbytime'));
    }

    // Check if any comments options activated
    if($this->cmttest('cmttext')){
      $query .= ' AND co.published=1 AND co.approved=1'
               .' GROUP BY co.cmtpic';
    }
    $query .= ' ORDER BY '.$sorting;

    $limit = $this->getConfig('limit');

    // Total number of images or pagination set
    if($limit != 0)
    {
      $database->setQuery($query, 0, $limit);
    }
    else
    {
      $database->setQuery($query);
    }
    $objects=$database->loadObjectList("id");

    if ($this->getConfig('showcmtdate') || $this->getConfig('showcmttext'))
    {
      $this->getLastComments($objects);
    }
    // Deactivate pagination if there are not enough images
    if ($this->getConfig('pagination')
        && count($objects) <= $this->getConfig('paginationct'))
    {
      $this->addConfig('pagination', 0);
    }
    return $objects;
  }

   /**
    * assemble the query for reading the picture data from database
    * with comments and comment count
    *
    * @param string $sorting - ORDER in DB
    * @param unknown_type $count
    * @return unknown
    */
  function getDBComments($sorting)
  {
    $database = & JFactory::getDBO();
    $user = & JFactory::getUser();
    $limit=$this->getConfig('limit');

    $cmtdate='co.cmtdate';
    if ($sorting == 'co.cmtdate ASC')
    {
      $cmtdate = 'MAX(co.cmtdate)';
      $sorting = 'cmtdate ASC';
    }
    else if ($sorting == 'co.cmtdate DESC')
    {
      $cmtdate = 'MAX(co.cmtdate)';
      $sorting = 'cmtdate DESC';
    }

    $query  =  'SELECT co.cmttext,'.$cmtdate.' as cmtdate,'
               .'co.cmtname,co.userid as cmtuserid,co.cmtid as commentid,'
               .'p.id as picid,p.catid,p.imgthumbname,p.imgfilename,'
               .'p.imgdate,p.imgtitle,p.imgauthor,p.owner,p.imgtext,p.hits,p.imgvotes,'
               .'(p.imgvotesum/p.imgvotes) AS vote,c.name AS cattitle,'
               .'c.catpath as catpath,'
               .'co.cmtpic AS id,count(co.cmtid) AS cmtcount'
             .' FROM #__joomgallery_comments as co'
             .' JOIN #__joomgallery as p ON co.cmtpic=p.id'
             .' JOIN #__joomgallery_catg as c ON c.cid=p.catid'
             .' WHERE c.published=1 AND c.access<='.$user->get('aid')
             .' AND p.published=1 AND p.approved=1';

    // Check the actual category shown
    if($this->getConfig('dynamiccats')
       && $this->checkifincat())
    {
      $query .= ' AND p.catid = '.$this->getactcat();
    }

    // Timespan filter
    if($this->getConfig('resultbytime') != 0)
    {
      $query .= $this->getSQLTimestring($this->getConfig('resultbytime'));
    }

    // Specific cat(s) to ex-/include
    if($this->getConfig('cats') != '')
    {
      $query .= ' AND p.catid';
      $query .= ($this->getConfig('showorhidecats')==1) ? ' IN' : ' NOT IN';

      if ($this->getConfig('includesubcats'))
      {
        // Include subcategories
        $catsincsubcats = $this->getSubcategories($this->getConfig('cats'));
        $query .= ' ('.$catsincsubcats.')';
      }
      else
      {
        $query .= ' ('.$this->getConfig('cats').')';
      }
    }

    $query .= ' AND co.published=1 AND co.approved=1'
            . ' GROUP BY co.cmtpic'
            . ' ORDER BY '.$sorting;

    $limit = $this->getConfig('limit');

    // Total number of images or pagination set
    if($limit != 0)
    {
      $database->setQuery($query, 0, $limit);
    }
    else
    {
      $database->setQuery($query);
    }

    $objects = $database->loadObjectList('picid');

    // Get the date and/or text from last comment if one of the options activated
    // and pictures existent
    if ($this->getConfig('showcmtdate') || $this->getConfig('showcmttext'))
    {
      $this->getLastComments($objects);
    }

    // Deactivate pagination if there are not enough images
    if ($this->getConfig('pagination')
        && count($objects) <= $this->getConfig('paginationct'))
    {
      $this->addConfig('pagination', 0);
    }
    return $objects;
  }

  /**
   * Get the id's of subcategories
   *
   */
  function getSubcategories()
  {
    $cats = array();

    $cats = explode(',', $this->getConfig('cats'));
    if (count($cats) == 0)
    {
      return '';
    }

    // Delete double values
    $cats = array_unique($cats);

    $subcats = array();
    // Iterate through array and call getAllSubCategories
    // in helper class of JoomGallery
    foreach ($cats as $cat)
    {
      if (!in_array($cat, $subcats))
      {
        $subcats = array_merge($subcats, JoomHelper::getAllSubCategories($cat));
      }
    }
    $cats = array_merge($cats, $subcats);
    // Delete double values
    $cats = array_unique($cats);

    $catsstring = implode(',', $cats);
    return $catsstring;
  }

 /**
 * create the where clause for timespan dependent query
 *
 * @param integer $option $this->getConfig('resultbytime')
 * @return string where clause
 */
  function getSQLTimestring ($option)
  {
    switch ($option)
    {
      // Current day
      case 1:
        $timequery = ' AND p.imgdate >= CURRENT_DATE()';
        break;
      // Current week
      case 2:
        $startWeek = mktime(0, 0, 0, date('n'), date('j'), date('Y')) - ((date('N')-1)*3600*24);
        $timequery = ' AND p.imgdate >= FROM_UNIXTIME('.$startWeek.')';
        break;
      // Current month
      case 3:
        $startMonth = mktime(0, 0, 0, date('m'), 1, date('Y'));
        $timequery = ' AND p.imgdate >= FROM_UNIXTIME('.$startMonth.')';
        break;
      // Current year
      case 4:
        $startYear = mktime(0, 0, 0, 1, 1, date('Y'));
        $timequery = ' AND p.imgdate >= FROM_UNIXTIME('.$startYear.')';
        break;
      // Last 24 hours
      case 5:
        $timequery = ' AND p.imgdate >= (NOW() - INTERVAL 1 DAY)';
        break;
      // Last 7 days
      case 6:
        $timequery = ' AND p.imgdate >= (NOW() - INTERVAL 7 DAY)';
        break;
      // Last 30 days
      case 7:
        $timequery = ' AND p.imgdate >= (NOW() - INTERVAL 30 DAY)';
        break;
      // Last 12 months
      case 8:
        $timequery = ' AND p.imgdate >= (NOW() - INTERVAL 12 MONTH)';
        break;
      default:
        $timequery= '';
        break;
    }
    return $timequery;
  }

  /**
   * Assembles the html code for text fields of pictures
   *
   * @param object $obj - picture object
   * @return string - html code
   */
  function showText($obj)
  {
    $database = & JFactory::getDBO();
    $user = & JFactory::getUser();
    $csstag=$this->getConfig('csstag');
    if($this->getConfig('showtext')==1)
    {
      $output = "";
      // Link to category view
      if($this->getConfig('catlink')==1)
      {
        $link = $this->displayDesc($obj);
      }
      else
      {
        // Link to detail view
        $link = $this->displayDesc($obj);
      }
      $output .= $link;
      // Output of text not provided by interface
      if($this->getConfig('showcmtdate') == 1 && $obj->cmtdate != NULL)
      {
        $output .= '<span class="'.$csstag.'cmtdate">'
                  .sprintf(JText::_('JICOMMLASTDATE'), $obj->cmtdate)
                  .'</span><br />';
      }

      if($this->getConfig('showcmttext') == 1 && $obj->cmtdate != NULL)
      {
        if ($obj->cmtuserid != 0)
        {
          $cmtname = JHTML::_('joomgallery.displayname', $obj->cmtuserid);
        }
        else
        {
          $cmtname=$obj->cmtname;
        }

        // Comment text
        $cmttext = $this->decodetext($obj->cmttext,
                                     $this->getConfig('strcmtcount'),
                                     $this->getConfig('strcmtwrap'),
                                     $this->getConfig('showcmtmore'));
        $output .= '&quot;'.$cmttext;

        // Read more link, only if comments shorted
        // and no opening directly from category view in e.g. slimbox
        // and view to detail page active
       if ($this->getConfig('showcmtmore') == 1
           && $this->getConfig('strcmtcount') > 0
           && $this->getJConfig('jg_detailpic_open') == 0
           && (($this->getJConfig('jg_showdetailpage') == 0 && $user->get('aid') != 0)
                || $this->getJConfig('jg_showdetailpage') == 1)
           )
        {
          $output .= '&nbsp;&#0133;<a href="'
                    .$this->route('index.php?view=detail&id='.$obj->id)
                    .'#joomcomments'.'">'
                    .JText::_('READMORE').'</a>';
        }
        $output .= '&quot;</span>';
      }
    }
    else
    {
      $output = '';
    }
    return $output;
  }

  /**
   * read the last comment of a picture
   *
   * @param array $objects
   */
  function getLastComments($objects)
  {
    $database = & JFactory::getDBO();
    if (count($objects))
    {
      $picids='(';
      $sep='';
      foreach ($objects as $obj)
      {
        $picids .= $sep.$obj->id;
        $sep=',';
      }
      $picids.=')';

      $query = 'SELECT co.cmtid,co.cmtpic,co.cmttext,co.cmtdate,co.userid,co.cmtname'
               .' FROM #__joomgallery_comments AS co'
               .' LEFT JOIN #__joomgallery_comments AS co2'
               .' ON co.cmtpic = co2.cmtpic'
               .' AND co.cmtdate < co2.cmtdate'
               .' WHERE co2.cmtpic IS NULL'
               .' AND co.cmtpic IN '.$picids;
      $database->setQuery($query);
      $commobjects = $database->loadObjectList();

      //and fill object with last comment
      foreach ($commobjects as $commobj)
      {
        $objects[$commobj->cmtpic]->cmttext=$commobj->cmttext;
        $objects[$commobj->cmtpic]->cmtdate=$commobj->cmtdate;
        $objects[$commobj->cmtpic]->cmtname=$commobj->cmtname;
        $objects[$commobj->cmtpic]->cmtuserid=$commobj->userid;
        $objects[$commobj->cmtpic]->commentid=$commobj->cmtid;
      }
    }
  }



  /**
   * Assembles text and html for image elements of default view
   * @param $objects array aof images
   */
  function modContent(&$objects)
  {
    $csstag=$this->getConfig("csstag");
    $imgcount = 0;
    foreach ($objects as $key => $obj)
    {
      $imgcount++;
      // Wordwrap for imgtitle
      if($this->getConfig('strtitlewrap') > 0) {
        $objects[$key]->imgtitle = wordwrap($obj->imgtitle,$this->getConfig('strtitlewrap'),'<br />', true);
      }

      // Shorten the image description
      if($this->getConfig('strdescount') > 0
        && isset($obj->imgtext) && strlen($obj->imgtext)>0)
      {
        if (strlen($obj->imgtext) > $this->getConfig('strdescount'))
        {
          $objects[$key]->imgtext = substr(strip_tags($objects[$key]->imgtext), 0, $this->getConfig('strdescount')).'&hellip;';
        }
      }

     // Wordwrap for image description
      if($this->getConfig('strdeswrap') > 0
        && isset($obj->imgtext) && strlen($obj->imgtext) > 0)
      {
        $objects[$key]->imgtext = wordwrap(strip_tags($obj->imgtext), $this->getConfig('strdeswrap'), '<br />', true);
      }

      // Check for link to category
      if($this->getConfig('catlink') == 1){
        $objects[$key]->link = $this->route('index.php?view=category&catid='.$obj->catid);
      }
      else
      {
        // Otherwise link to detail view
        $objects[$key]->link = $this->getImageLink($obj);
      }
      $objects[$key]->css_styledimension = '';
      // Make css settings and call functions of interface
      // to retrieve images and texts
      // If auto_resize activated, check the dimensions of the thumb and generate
      // the inline styles of height/width, not with activated cropping
      if ($this->getConfig('auto_resize') && !$this->getConfig('crop_img'))
      {
        $thmpath   = JPATH_SITE.DS.$this->getJConfig('jg_paththumbs');
        $thmsize   = getimagesize($thmpath.$obj->catpath.'/'.$obj->imgthumbname);
        $thmWidth  = $thmsize[0];
        $thmHeight = $thmsize[1];

        //get the max dimension
        $maxdim=(int) $this->getConfig('auto_resize_max');

        if ($thmWidth > $thmHeight)
        {
          //width is the max. dimension
          $ratio=$thmWidth/$maxdim;
          $destWidth  = $maxdim;
          $destHeight = (int)($thmHeight / $ratio);
        }
        else
        {
          //height is the max. dimension
          $ratio=$thmHeight/$maxdim;
          $destHeight  = $maxdim;
          $destWidth = (int)($thmWidth / $ratio);
        }
        $objects[$key]->css_styledimension = ' style="height:'
                            .$destHeight
                            .'px;width:'
                            .$destWidth
                            .'px;" ';
      }
      if ($this->getConfig('image_position') != 0)
      {
        if($this->getConfig('crop_img'))
        {
          $objects[$key]->imagesource=$this->_ambit->getImg($this->getConfig('type').'_path', $obj,null,0,false);
        }
        else
        {
          $objects[$key]->imagesource=$this->route($this->_ambit->getImg($this->getConfig('type').'_url', $obj,null,0,false));
        }
      }
      switch ($this->getConfig('image_position'))
      {
        case 0:
          // No image
          $objecttxt=$this->showText($obj);
          if (!empty($objecttxt))
          {
            $objects[$key]->imgelem = '<div class="'.$csstag.'txt">'."\n"
                                     .$objecttxt."\n"
                                     .'</div>'."\n";
          }
          else
          {
            $objects[$key]->imgelem = '';
          }
          break;
        case 1:
        case 2:
        case 3:
          // Image above (1) or left (2) or right(3) to text
          $objects[$key]->imgelem = '<div class="'.$csstag.'img">'."\n";
          if ($this->getConfig('setjilink'))
          {
            $objects[$key]->imgelem .= '  <a href="'.$obj->link.'" >';
          }
          if ($this->getConfig('crop_img'))
          {
            //crop the pictures
            $cropsizewidth=$this->getConfig('crop_sizewidth');
            $cropsizeheight=$this->getConfig('crop_sizeheight');

            $objects[$key]->imgelem .= '    <img src="modules/mod_joomimg/helper/resize.php?'
                     .'width='.$cropsizewidth
                     .'&amp;height='.$cropsizeheight
                     .'&amp;file='
                     .$obj->imagesource.'"'
                     .' alt="'
                     .$obj->imgtitle.'"'
                     .' title="'
                     .$obj->imgtitle.'" />';
          }
          else
          {
            $objects[$key]->imgelem .= '    <img src="'
                     .$obj->imagesource.'"'
                     .$obj->css_styledimension
                     .' alt="'
                     .$obj->imgtitle.'"'
                     .' title="'
                     .$obj->imgtitle.'" />';
          }
          if ($this->getConfig('setjilink'))
          {
            $objects[$key]->imgelem .= '  </a>';
          }
          $objects[$key]->imgelem .= '</div>'."\n";

          $objecttxt=$this->showText($obj);
          if (!empty($objecttxt))
          {
            $objects[$key]->imgelem .= '<div class="'.$csstag.'txt">'."\n"
                                     .$objecttxt."\n"
                                     .'</div>'."\n";
          }
          break;
        case 4:
          //image below text
          //delete the  / from catpath
          $catpath = trim($obj->catpath, '/');
          $objecttxt=$this->showText($obj);
          if (!empty($objecttxt))
          {
            $objects[$key]->imgelem .= '<div class="'.$csstag.'txt">'."\n"
                                     .$objecttxt."\n"
                                     .'</div>'."\n";
          }
          if ($this->getConfig('setjilink'))
          {
            $objects[$key]->imgelem .= '  <a href="'.$link.'" >';
          }
          //crop the pictures
          if ($this->getConfig('crop_img')){
            $cropsizewidth=$this->getConfig('crop_sizewidth');
            $cropsizeheight=$this->getConfig('crop_sizeheight');

            //crop
            $objects[$key]->imgelem .= '    <img src=\"modules/mod_joomimg/helper/resize.php?'
               .'width='.$cropsizewidth
               .'&height='.$cropsizeheight
               .'&file='
               .$obj->imagesource.'"'
               .' alt="'
               .$obj->imgtitle.'"'
               .' title="'
               .$obj->imgtitle.'" />';
          }
          else
          {
            $objects[$key]->imgelem .= '    <img src="'
                     .$obj->imagesource.'"'
                     .$obj->css_styledimension
                     .' alt="'
                     .$obj->imgtitle.'"'
                     .' title="'
                     .$obj->imgtitle.'" />';
          }
          if ($this->getConfig('setjilink'))
          {
            $objects[$key]->imgelem .= '  </a>';
          }
          break;
      }
    }
  }

  /**
   * check the backend for activated settings according comments to choose
   * the right DB function or to add the query in getDBImages()
   *
   * @param int $only_comments 1=check for comment sorts in DB
   * @return bool
   */
  function cmttest($mode)
  {
    if ($mode=="sort")
    {
      if($this->getConfig('sorting')=='cmtcount ASC'
         || $this->getConfig('sorting')=='cmtcount DESC'
         || $this->getConfig('sorting')=='co.cmtdate ASC'
         || $this->getConfig('sorting')=='co.cmtdate DESC'
         || $this->getConfig('sorting')=='commentrand') {
         return true;
      }
      else
      {
        return false;
      }
    }
    else
    {
      if ($this->getConfig('showcmtdate')
          || $this->getConfig('showcmttext')
          || $this->getConfig('shownumcomments')){
          return true;
      }
      else
      {
        return false;
      }
    }
  }


  /**
   * check if in joomgallery category or detail view
   *
   * @return bool
   */
  function checkifincat()
  {
    // Get some request variables
    $option    = JRequest::getVar('option', '');
    $view      = JRequest::getVar('view', '');
    $catid     = JRequest::getInt('catid', 0);
    $id        = JRequest::getInt('id', 0);

    if($option == 'com_joomgallery')
    {
      // Category view
      if ($view == 'category' && $catid !=0)
      {
        return true;
      }
      // Detail view
      if ($view == 'detail' && $id != 0)
      {
        return true;
      }
    }
    return false;
  }


  /**
   * return the actual category
   *
   * @param int $cid - category id
   * @return bool - category id
   */
  function getactcat()
  {
    $database = & JFactory::getDBO();
    $user = & JFactory::getUser();
    //get some request variables
    $view      = $database->getEscaped(trim(JRequest::getVar('view', '')));
    $catid     = JRequest::getInt('catid', 0);
    $id        = JRequest::getInt('id', 0);

    if ($view == 'category' && $catid !=0)
    {
      return $catid;
    }

    if($view == 'detail' && $id!=0 )
    {
      $query  = 'SELECT p.catid FROM #__joomgallery as p'
               .' LEFT JOIN #__joomgallery_catg as c ON c.cid=p.catid'
               .' WHERE c.published=1 AND c.access<='.$user->get('aid')
               .' AND p.published=1 AND p.approved=1 AND p.id='.$id
               .' LIMIT 1';
      $database->setQuery($query);
      return $database->loadResult();
    }
    else
    {
      return 0;
    }
  }

  /**
   *
   *
   */
  function renderCSS()
  {
    $containerwidth=floor(100/$this->getConfig('img_per_row'));
    $csstag=$this->getConfig("csstag");

    $dirhoriz='text-align:'.$this->getConfig('dir_hor').'!important;'."\n";
    $dirvert='vertical-align:'.$this->getConfig('dir_vert').'!important;'."\n";
    $csscont='float:left;'."\n";

    switch ($this->getConfig('image_position'))
    {
      case 0:
        // No image
        $cssimg ='';
        $csstxt = $dirhoriz.$dirvert;
        break;
      case 1:
        // Image above text
        $cssimg = 'display:block;'."\n";
        $cssimg .= $dirhoriz.$dirvert;
        $csstxt = 'clear:both;'.$dirhoriz.$dirvert;
        break;
      case 2:
        // Image left from text
        $cssimg = 'float:left;'."\n";
        $csstxt = 'float:left;'."\n";
        $cssimg .= $dirhoriz.$dirvert;
        $csstxt .= $dirhoriz.$dirvert;
        break;
      case 3:
        // Image right from text
        $cssimg = 'float:right;'."\n";
        $csstxt = 'float:right;'."\n".'padding-right:0.5em;'."\n";
        $cssimg .= $dirhoriz.$dirvert;
        $csstxt .= $dirhoriz.$dirvert;
        break;
      default:
        // Image below text
        $cssimg = $dirhoriz.$dirvert;
        $csstxt = $dirhoriz.$dirvert;
        break;
    }

    // CSS for border if image displayed and 'border' = yes
    if ($this->getConfig('image_position') != 0 && $this->getConfig('border') ==1 )
    {
      $cssborder='border:'
        .$this->getConfig('borderwidth')
        .' '
        .$this->getConfig('borderstyle')
        .' '
        .$this->getConfig('bordercolor')
        .";\n".'padding:'.$this->getConfig('borderpadding')
        .';';
    }
    else
    {
      $cssborder='';
    }


    $css="";
    // Container
    $css .= '.'.$csstag.'imgct {'."\n"
          . 'width:'.$containerwidth.'% !important;'."\n"
          . $csscont
          .'}'."\n";

    // Image
    if (!empty($cssimg))
    {
      $css .= '.'.$csstag.'img {'."\n"
        . $cssimg
        .'}'."\n";

      // Border for image
      if (!empty($cssborder))
      {
        $css .= '.'.$csstag.'img img{'."\n"
          . $cssborder
          .'}'."\n";
      }
    }

    // Text
    if (!empty($csstxt))
    {
      $css .= '.'.$csstag.'txt {'."\n"
           . $csstxt
           .'}'."\n";
    }

    // Define height/width of images if setted
    // not when auto_resize activated
    if (!$this->getConfig('auto_resize')
        && !$this->getConfig('crop_img'))
    {
      if ($this->getConfig('imgwidth') != 0
          || $this->getConfig('imgheight')!= 0)
      {
        $imgcss='';
        if ($this->getConfig('imgwidth') != 0)
        {
          $imgcss .="\n".'width:'.$this->getConfig('imgwidth').'px;';
        }
        if ($this->getConfig('imgheight') != 0)
        {
          $imgcss .="\n".'height:'.$this->getConfig('imgheight').'px;';
        }

        $css .= '.'.$csstag.'img img {'."\n"
             . $imgcss
             .'}'."\n";
      }
    }

    // Pagination if activated
    if ($this->getConfig('pagination'))
    {
      $css .= '.'.$csstag.'pagnavi{'."\n"
        . '  text-align:center;'."\n"
        .'}'."\n";

      // current site
      $css .= '.'.$csstag.'paglinkactive{'."\n"
        . '  border:solid 1px #000;'."\n"
        . '  margin-bottom:4px;'."\n"
        . '  padding:2px;'."\n"
        . '  background-color:#ddd;'."\n"
        .'}'."\n";

      // other site
      $css .= '.'.$csstag.'paglink{'."\n"
        . '  border:solid 1px #000;'."\n"
        . '  margin-bottom:4px;'."\n"
        . '  padding:2px;'."\n"
        .'}'."\n";


    }
    $document = &JFactory::getDocument();
    $document->addStyleDeclaration($css);
  }

  /**
   *
   * @param $text
   * @param $newlength
   * @param $wrap
   * @param $more
   */
  function decodetext($text,$newlength=0,$wrap=0,$more=0)
  {
    // Remove whitespace at start and end of the text
    $text = trim($text);
    $newlength = ($newlength!=0) ? $newlength-1 : 0;
    $smileys = JoomHelper::getSmileys();

    // Define replace tags
    $replace1  = array('[url]','[/url]','[email]','[/email]');
    $replace21 = array('[b]','[i]','[u]');
    $replace22 = array('[/b]','[/i]','[/u]');
    $replace2  = array_merge($replace21, $replace22);
    $replace3  = array('<b>','<i>','<u>','</b>','</i>','</u>');

    // Replace url and emailtags because we do not show them in our modules
    foreach($replace1 as $replace)
    {
      $text = str_replace($replace, '', $text);
    }
    $textlength = strlen($text);
    // If text has to be in a range we abridge him
    if($newlength > 0 && $newlength < $textlength)
    {
      $add = '';

      // Replace simple html-tags with bb_code
      for($i=0;$i<count($replace3);$i++)
      {
        $text = str_replace($replace3[$i], $replace2[$i], $text);
      }

      // Replace smilies with shorttags or remove them
      if($this->getJConfig('jg_smiliesupport'))
      {
        $count=0;
        $smileshort = array();
        foreach ($smileys as $i=>$sm)
        {
          $text = str_replace($i, '{'.$count.'}', $text);
          $smileshort[$count]['short'] = $i;
          $smileshort[$count]['long']  = $sm;
          $count++;
        }
      }
      else
      {
        foreach ($smiley as $i=>$sm)
        {
          $text = str_replace($i, "", $text);
        }
      }
      $textlength = strlen($text);
    }
    // Remove any html because it is too complicated to handle them
    // @TODO: more intelligent way of wordwrap to consider BBCode and smilie tags
    if ( $wrap > 0 )
    {
      $text = strip_tags($text);
      $textlength = strlen($text);
      if ($wrap > 0 && $textlength > $wrap)
      {
        $text = wordwrap($text,$wrap,'<br />',true);
      }
    }

    // If wrap is activated count the containing <br />
    // and add their length to $newlength
    if ($wrap > 0)
    {
      $countbrstr=substr($text, 0, $newlength);
      //count the <br />
      $countbr=substr_count($countbrstr, '<br />');
      if ($countbr > 0)
      {
        $newlength = $newlength + ($countbr*6);
      }
    }
    $textlength = strlen($text);

    // slice if needful
    if ($newlength != 0 && $textlength > ($newlength+1))
    {
      //Check a sliced <br />
      if (($textlength-6) > 0 && ($newlength-6) > 0)
      {
        $strposfound=strpos($text, '<br />', $newlength-6);
      }
      else
      {
        $strposfound = 0;
      }
      if ($strposfound > 0 && $strposfound < $newlength)
      {
        //slice before the begin of the <br />
        $newlength=$strposfound;
      }
      else
      {
        //check a sliced bbcode tag and shorten newlength
        foreach($replace2 as $replace)
        {
          $replacelength=strlen($replace);
          if ($textlength > ($newlength-$replacelength) && ($newlength-$replacelength) > 0)
          {
            $strposfound=strpos($text, $replace, $newlength-$replacelength);
          }
          else
          {
            $strposfound = 0;
          }
          if($strposfound > 0 && $strposfound < $newlength)
          {
            $newlength=$strposfound;
            break;
          }
        }
        //check a sliced smilie tag and shorten newlength
        if (isset($smileshort))
        {
          for($i=0;$i<count($smileshort);$i++)
          {
            $replacelength=strlen($i)+2;
            if ($textlength > ($newlength-$replacelength) && ($newlength-$replacelength) > 0)
            {
              $strposfound=strpos($text, "{".$i."}", $newlength-$replacelength);
            }
            else
            {
              $strposfound = 0;
            }
            if($strposfound > 0 && $strposfound < $newlength)
            {
              $newlength=$strposfound;
              break;
            }
          }
        }
      }
      // Slice the text
      $text=substr($text, 0, $newlength);
    }

    // Adding mising tags at the end of the text
    if ( $this->getJConfig('jg_bbcodesupport'))
    {
      $prioarr=array();
      //builds an array for the priority in replacing
      $countreplace=count($replace21);
      for($i=0;$i < $countreplace;$i++)
      {
        // Check if there is an unbalance
        // of opening and closing tags
        $countopen=substr_count($text, $replace21[$i]);
        $countclose=substr_count($text, $replace22[$i]);
        $diff = $countopen-$countclose;
        $found = -1;
        while ($diff > 0)
        {
          $found=strpos($text, $replace21[$i], $found+1);
          // Add the closing tag
          $prioarr[$found]=$replace22[$i];
          $diff--;
        }
      }
      if (count($prioarr))
      {
        //reverse the array to begin with the last element
        arsort($prioarr);
        foreach($prioarr as $key => $value)
        {
          $add .= $value;
        }
      }
    }
    //abridge text and add missing tags
    if (!empty($add))
    {
      $text = $text.$add;
    }
    //If text was sliced add the ellipsis
    if( $newlength > 0 && $textlength > $newlength && $more == 0)
    {
      $text .= "...";
    }

    //decoding bb_code or remove tags
    if ( $this->getJConfig('jg_bbcodesupport'))
    {
      $text = JoomHelper::BBDecode($text);
    }
    else
    {
      foreach($replace2 as $replace)
      {
        $text = str_replace($replace, "", $text);
      }
    }

    //decoding smilies or remove them
    if ( $this->getJConfig('jg_smiliesupport'))
    {
      foreach ( $smileys as $i=>$sm )
      {
        $text = str_replace($i, '<img src="'.$sm.'"'.' alt="'.$i.'" />', $text);
      }
      if (isset($smileshort))
      {
        for($i=0;$i<count($smileshort);$i++)
        {
          $text = str_replace('{'.$i.'}', '<img src="'.$smileshort[$i]['long'].'" border="0" alt="'.$smileshort[$i]['short'].'" title="'.$smileshort[$i]['short'].'" />',$text);
        }
      }
    }
    else
    {
      foreach ( $smileys as $i=>$sm )
      {
        $text = str_replace($i, "", $text);
      }
      if (isset($smileshort))
      {
        for($i=0;$i<count($smileshort);$i++)
        {
          $text = str_replace('{'.$i.'}', '', $text);
        }
      }
    }
    return $text;
  }
}