/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.policies;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.dnd.DropTargetDropEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.IllegalFormatException;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;
import wjhk.jupload2.context.JUploadContext;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadExceptionStopAddingFiles;
import wjhk.jupload2.exception.JUploadExceptionUploadFailed;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadFileChooser;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;
import wjhk.jupload2.upload.helper.ByteArrayEncoderHTTP;
import wjhk.jupload2.upload.helper.HTTPConnectionHelper;
import wjhk.jupload2.upload.helper.HttpProtocolFinderThread;

public class DefaultUploadPolicy
implements UploadPolicy {
    public static final int DIALOG_MESSAGE_MAX_LINE_LENGTH = 80;
    JUploadContext juploadContext = null;
    private String afterUploadURL = UploadPolicy.DEFAULT_AFTER_UPLOAD_URL;
    private boolean allowHttpPersistent = false;
    private String allowedFileExtensions = UploadPolicy.DEFAULT_ALLOWED_FILE_EXTENSIONS;
    private String showLogWindow = "true";
    private boolean showStatusbar = true;
    private String specificHeaders = null;
    private File currentBrowsingDirectory = null;
    private boolean debugGenerateFile = true;
    private int debugLevel = 0;
    private int fileChooserIconFromFileContent = 0;
    private int fileChooserIconSize = 20;
    private String filenameEncoding = UploadPolicy.DEFAULT_FILENAME_ENCODING;
    private boolean ftpCreateDirectoryStructure = false;
    private boolean ftpTransfertBinary = true;
    private boolean ftpTransfertPassive = true;
    protected String httpUploadParameterName = "File";
    protected String httpUploadParameterType = "iteration";
    private String lang = UploadPolicy.DEFAULT_LANG;
    private JUploadException lastException = null;
    private String lookAndFeel = "";
    private int nbFilesPerRequest = 1;
    private long maxChunkSize = Long.MAX_VALUE;
    private long maxFileSize = Long.MAX_VALUE;
    private String postURL = UploadPolicy.DEFAULT_POST_URL;
    private boolean readCookieFromNavigator = true;
    private boolean readUserAgentFromNavigator = true;
    private int retryMaxNumberOf = 1;
    private int retryNbSecondsBetween = 30;
    private String serverProtocol = "HTTP/1.1";
    private String stringUploadError = "^ERROR: (.*)$";
    private String stringUploadSuccess = "^SUCCESS$";
    private String stringUploadWarning = "^WARNING: (.*)$";
    private String urlToSendErrorTo = UploadPolicy.DEFAULT_URL_TO_SEND_ERROR_TO;
    private String formData = UploadPolicy.DEFAULT_FORMDATA;
    private String afterUploadTarget = UploadPolicy.DEFAULT_AFTER_UPLOAD_TARGET;
    private String lastResponseBody = null;
    private String lastResponseMessage = null;
    private int sslVerifyCert = 0;
    private final String CRLF = System.getProperty("line.separator");
    private Vector<String> headers = new Vector();
    private ResourceBundle resourceBundle = null;
    protected PrintStream debugOut = null;
    protected File debugFile = null;
    protected boolean debugOk = true;
    protected Pattern patternError = Pattern.compile("^ERROR: (.*)$");
    protected Pattern patternSuccess = Pattern.compile("^SUCCESS$");
    protected Pattern patternWarning = Pattern.compile("^WARNING: (.*)$");

    public DefaultUploadPolicy(JUploadContext juploadContext) throws JUploadException {
        this.juploadContext = juploadContext;
        this.displayInfo("JUpload juploadContext started, with " + this.getClass().getName() + " upload policy");
        this.setDebugLevel(juploadContext.getParameter("debugLevel", 0), false);
        this.setLang(juploadContext.getParameter("lang", DEFAULT_LANG));
        this.setLookAndFeel(juploadContext.getParameter("lookAndFeel", ""));
        this.setSslVerifyCert(juploadContext.getParameter("sslVerifyCert", "none"));
        this.setAfterUploadURL(juploadContext.getParameter("afterUploadURL", DEFAULT_AFTER_UPLOAD_URL));
        this.setFtpCreateDirectoryStructure(juploadContext.getParameter("ftpCreateDirectoryStructure", false));
        this.setFtpTransfertBinary(juploadContext.getParameter("ftpTransfertBinary", true));
        this.setFtpTransfertPassive(juploadContext.getParameter("ftpTransfertPassive", true));
        this.setAllowedFileExtensions(juploadContext.getParameter("allowedFileExtensions", DEFAULT_ALLOWED_FILE_EXTENSIONS));
        this.setAllowHttpPersistent(juploadContext.getParameter("allowHttpPersistent", false));
        this.setShowStatusbar(juploadContext.getParameter("showStatusbar", true));
        this.setShowLogWindow(juploadContext.getParameter("showLogWindow", "true"));
        this.setFileChooserIconFromFileContent(juploadContext.getParameter("fileChooserIconFromFileContent", 0));
        this.setFileChooserIconSize(juploadContext.getParameter("fileChooserIconSize", 20));
        this.setCurrentBrowsingDirectory(juploadContext.getParameter("browsingDirectory", DEFAULT_BROWSING_DIRECTORY));
        this.setFilenameEncoding(juploadContext.getParameter("filenameEncoding", DEFAULT_FILENAME_ENCODING));
        this.setNbFilesPerRequest(juploadContext.getParameter("nbFilesPerRequest", 1));
        this.setHttpUploadParameterName(juploadContext.getParameter("httpUploadParameterName", "File"));
        this.setHttpUploadParameterType(juploadContext.getParameter("httpUploadParameterType", "iteration"));
        this.setMaxChunkSize(juploadContext.getParameter("maxChunkSize", Long.MAX_VALUE));
        this.setMaxFileSize(juploadContext.getParameter("maxFileSize", Long.MAX_VALUE));
        this.setRetryMaxNumberOf(juploadContext.getParameter("retryMaxNumberOf", 1));
        this.setRetryNbSecondsBetween(juploadContext.getParameter("retryNbSecondsBetween", 30));
        this.setPostURL(juploadContext.getParameter("postURL", DEFAULT_POST_URL));
        this.setReadCookieFromNavigator(juploadContext.getParameter("readCookieFromNavigator", true));
        this.setReadUserAgentFromNavigator(juploadContext.getParameter("readUserAgentFromNavigator", true));
        this.setSpecificHeaders(juploadContext.getParameter("specificHeaders", DEFAULT_SPECIFIC_HEADERS));
        this.setStringUploadError(juploadContext.getParameter("stringUploadError", "^ERROR: (.*)$"));
        this.setStringUploadSuccess(juploadContext.getParameter("stringUploadSuccess", "^SUCCESS$"));
        this.setStringUploadWarning(juploadContext.getParameter("stringUploadWarning", "^WARNING: (.*)$"));
        this.setUrlToSendErrorTo(juploadContext.getParameter("urlToSendErrorTo", DEFAULT_URL_TO_SEND_ERROR_TO));
        this.formData = juploadContext.getParameter("formdata", DEFAULT_FORMDATA);
        this.afterUploadTarget = juploadContext.getParameter("afterUploadTarget", DEFAULT_AFTER_UPLOAD_TARGET);
        if (this.getReadCookieFromNavigator()) {
            this.juploadContext.readCookieFromNavigator(this.headers);
        }
        if (this.getReadUserAgentFromNavigator()) {
            this.juploadContext.readUserAgentFromNavigator(this.headers);
        }
        HttpProtocolFinderThread.computeServerProtocol(this, juploadContext.getParameter("serverProtocol", null));
        this.displayDebug("[DefaultUploadPolicy] end of constructor (serverProtocol has been set)", 30);
    }

    public void addHeader(String header) {
        this.headers.add(header);
    }

    public boolean checkUploadSuccess(int status, String msg, String body) throws JUploadException {
        boolean bReturn = false;
        if (this.getDebugLevel() > 100) {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.lastResponseBody = body;
        this.lastResponseMessage = msg;
        this.displayDebug("HTTP status: " + msg, 30);
        if (status != 200 && status != 100) {
            throw new JUploadExceptionUploadFailed("Received HTTP status " + msg);
        }
        Pattern p = Pattern.compile("[\\r\\n]", 8);
        String[] lines = p.split(body);
        StringBuffer sbBodyWithUniformCRLF = new StringBuffer(body.length());
        for (int i = 0; i < lines.length; ++i) {
            Matcher matcherWarning;
            Matcher matcherError;
            String line = lines[i];
            sbBodyWithUniformCRLF.append(line).append("\r\n");
            if (line == null || line.equals("")) continue;
            if (this.getStringUploadSuccess() != null && !this.getStringUploadSuccess().equals("") && this.patternSuccess.matcher(line).matches()) {
                bReturn = true;
            }
            if (this.getStringUploadError() != null && !this.getStringUploadError().equals("") && (matcherError = this.patternError.matcher(line)).matches()) {
                String errmsg = "An error occurs during upload (but the applet couldn't find the error message)";
                if (matcherError.groupCount() > 0 && !matcherError.group(1).equals("")) {
                    errmsg = this.formatMessage(matcherError.group(1));
                }
                this.lastResponseMessage = errmsg;
                throw new JUploadExceptionUploadFailed(errmsg);
            }
            if (this.getStringUploadWarning() == null || this.getStringUploadWarning().equals("") || !(matcherWarning = this.patternWarning.matcher(line)).matches()) continue;
            String warnmsg = "A warning occurs during upload (but the applet couldn't find the warning message)";
            if (matcherWarning.groupCount() > 0 && !matcherWarning.group(1).equals("")) {
                warnmsg = this.formatMessage(matcherWarning.group(1));
            }
            this.lastResponseMessage = warnmsg;
            this.displayWarn(warnmsg);
            this.alertStr(warnmsg);
        }
        if (bReturn) {
            return true;
        }
        if (this.getStringUploadSuccess() == null || this.getStringUploadSuccess().equals("")) {
            return true;
        }
        throw new JUploadExceptionUploadFailed(this.getClass().getName() + ".checkUploadSuccess(): The string \"" + this.getStringUploadSuccess() + "\" was not found in the response body");
    }

    private String formatMessage(String errmsg) {
        int maxLineLength = 80;
        StringBuffer sbErrMsg = new StringBuffer();
        int j = 0;
        int remaining = errmsg.length();
        while (remaining > 0) {
            if (remaining <= maxLineLength) {
                sbErrMsg.append(errmsg.substring(j * maxLineLength));
            } else {
                sbErrMsg.append(errmsg.substring(j * maxLineLength, (j + 1) * maxLineLength));
                sbErrMsg.append("\n");
            }
            remaining -= maxLineLength;
            ++j;
        }
        errmsg = sbErrMsg.toString();
        return errmsg;
    }

    public void afterUpload(Exception e, String serverOutput) throws JUploadException {
        String url = this.getAfterUploadURL();
        if (url != null) {
            this.juploadContext.displayURL(url, e == null);
        }
    }

    public void alertStr(String str) {
        String str2 = str.replaceAll("\\\\n", "\n");
        JOptionPane.showMessageDialog(null, str2, "Alert", 2);
    }

    public int confirmDialogStr(String str, int optionTypes) {
        String str2 = str.replaceAll("\\\\n", "\n");
        return JOptionPane.showConfirmDialog(this.getContext().getUploadPanel().getJComponent().getParent(), str2, "Alert", optionTypes);
    }

    public void alert(String key) {
        this.alertStr(this.getLocalizedString(key, new Object[0]));
    }

    public FileData createFileData(File file, File root) throws JUploadExceptionStopAddingFiles {
        if (!this.fileFilterAccept(file)) {
            String msg = file.getName() + " : " + this.getLocalizedString("errForbiddenExtension", new Object[0]);
            this.displayWarn(msg);
            if (this.confirmDialogStr(msg, 2) == 2) {
                throw new JUploadExceptionStopAddingFiles("Stopped by the user");
            }
            return null;
        }
        if (!file.canRead()) {
            this.displayInfo("Can't read file " + file.getName() + ". No DefaultFileData creation.");
            return null;
        }
        return new DefaultFileData(file, root, this);
    }

    public JPanel createTopPanel(JButton browse, JButton remove, JButton removeAll, JUploadPanel jUploadPanel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3, 10, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel.add(browse);
        jPanel.add(removeAll);
        jPanel.add(remove);
        jUploadPanel.getJComponent().setBorder(BorderFactory.createLineBorder(SystemColor.controlDkShadow));
        return jPanel;
    }

    public JPanel createProgressPanel(JProgressBar preparationProgressBar, JProgressBar uploadProgressBar, JButton uploadButton, JButton stopButton, JUploadPanel mainPanel) {
        JPanel jProgressBarPanel = new JPanel();
        jProgressBarPanel.setLayout(new BorderLayout(10, 1));
        jProgressBarPanel.add((Component)preparationProgressBar, "North");
        jProgressBarPanel.add((Component)uploadProgressBar, "South");
        JPanel jProgressPanel = new JPanel();
        jProgressPanel.setLayout(new BorderLayout(10, 0));
        jProgressPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jProgressPanel.add((Component)uploadButton, "Before");
        jProgressPanel.add((Component)jProgressBarPanel, "Center");
        jProgressPanel.add((Component)stopButton, "After");
        return jProgressPanel;
    }

    public JPanel createStatusBar(JLabel content, JUploadPanel mainPanel) {
        if (this.showStatusbar) {
            JPanel pstatus = new JPanel();
            pstatus.setLayout(new BorderLayout());
            pstatus.add((Component)content, "Center");
            pstatus.setBorder(new BevelBorder(1));
            return pstatus;
        }
        return null;
    }

    public void addComponentsToJUploadPanel(JUploadPanel jUploadPanel) {
        jUploadPanel.getJComponent().setLayout(new BoxLayout(jUploadPanel.getJComponent(), 1));
        JPanel topPanel = this.createTopPanel(jUploadPanel.getBrowseButton(), jUploadPanel.getRemoveButton(), jUploadPanel.getRemoveAllButton(), jUploadPanel);
        if (topPanel != null) {
            jUploadPanel.getJComponent().add(topPanel);
            topPanel.addMouseListener(jUploadPanel.getMouseListener());
        }
        jUploadPanel.getJComponent().add(jUploadPanel.getFilePanel().getDropComponent());
        JPanel progressPanel = this.createProgressPanel(jUploadPanel.getPreparationProgressBar(), jUploadPanel.getUploadProgressBar(), jUploadPanel.getUploadButton(), jUploadPanel.getStopButton(), jUploadPanel);
        jUploadPanel.getJComponent().add(progressPanel);
        jUploadPanel.getJComponent().addMouseListener(jUploadPanel.getMouseListener());
        jUploadPanel.showOrHideLogWindow();
        jUploadPanel.getJComponent().add(jUploadPanel.getJLogWindowPane());
        JPanel p = this.createStatusBar(jUploadPanel.getStatusLabel(), jUploadPanel);
        if (null != p) {
            jUploadPanel.getJComponent().add(p);
            p.addMouseListener(jUploadPanel.getMouseListener());
        }
    }

    public void displayErr(Exception e) {
        this.displayErr(e.getMessage(), e);
    }

    public void displayErr(String err) {
        this.displayErr(err, null);
    }

    private void displayStackTrace(Throwable throwable) {
        if (throwable != null) {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bs);
            throwable.printStackTrace(ps);
            ps.close();
            this.displayMsg("", bs.toString());
            if (throwable.getCause() != null) {
                this.displayMsg("", "Caused by:");
                this.displayStackTrace(throwable.getCause());
            }
        }
    }

    private void logErr(String errorText, Exception exception) {
        if (exception == null) {
            this.setLastException(new JUploadException("errorText"));
        } else if (exception instanceof JUploadException) {
            this.setLastException((JUploadException)exception);
        } else {
            this.setLastException(new JUploadException(exception));
        }
        if (this.getDebugLevel() == 0) {
            this.setDebugLevel(1);
        }
        String exceptionMsg = null;
        String exceptionClassName = null;
        String logMsg = errorText;
        exceptionClassName = exception == null ? "" : (exception instanceof JUploadException ? "[" + ((JUploadException)exception).getClassNameAndClause() + "] " : "[" + exception.getClass().getName() + "] ");
        if (exception != null) {
            exceptionMsg = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
            logMsg = exceptionMsg + " (" + errorText + ")";
        }
        this.displayMsg("[ERROR]", exceptionClassName + logMsg);
        this.displayStackTrace(exception);
        if (this.juploadContext.getUploadPanel() != null && this.getDebugLevel() >= 99) {
            this.juploadContext.getUploadPanel().copyLogWindow();
            this.alert("messageLogWindowCopiedToClipboard");
        }
    }

    public int displayErr(String errorText, Exception exception, int optionTypes) {
        String alertMsg = errorText;
        if (exception != null && (errorText == null || errorText.equals(""))) {
            alertMsg = exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage();
        }
        if (this.getDebugLevel() >= 30 && exception != null) {
            alertMsg = exception.getClass().getName() + ": " + alertMsg;
        }
        int buttonClicked = 0;
        switch (optionTypes) {
            case -1: {
                this.alertStr(alertMsg);
                buttonClicked = 0;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                buttonClicked = this.confirmDialogStr(alertMsg, optionTypes);
                break;
            }
            default: {
                this.alertStr(alertMsg);
                buttonClicked = 0;
                String msg = "Unknown optionType in displayErr(String, Exception, int)";
                this.alertStr(msg);
                this.logErr(msg, null);
            }
        }
        this.logErr(errorText, exception);
        return buttonClicked;
    }

    public void displayErr(String errorText, Exception exception) {
        this.displayErr(errorText, exception, -1);
    }

    public void displayInfo(String info) {
        this.displayMsg("[INFO]", info);
    }

    public void displayWarn(String warn) {
        this.displayMsg("[WARN]", warn);
    }

    public void displayDebug(String debug, int minDebugLevel) {
        String tag = "[DEBUG]";
        if (this.debugLevel >= minDebugLevel) {
            this.displayMsg("[DEBUG]", debug);
        } else if (this.debugGenerateFile) {
            this.addMsgToDebugLog("[DEBUG]" + debug);
        }
    }

    public String getLocalizedString(String key, Object ... args) {
        String ret = this.resourceBundle.getString(key);
        try {
            switch (args.length) {
                case 0: {
                    return String.format(ret, new Object[0]);
                }
                case 1: {
                    return String.format(ret, args[0]);
                }
                case 2: {
                    return String.format(ret, args[0], args[1]);
                }
                case 3: {
                    return String.format(ret, args[0], args[1], args[2]);
                }
                case 4: {
                    return String.format(ret, args[0], args[1], args[2], args[3]);
                }
                case 5: {
                    return String.format(ret, args[0], args[1], args[2], args[3], args[4]);
                }
                case 6: {
                    return String.format(ret, args[0], args[1], args[2], args[3], args[4], args[5]);
                }
                case 7: {
                    return String.format(ret, args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
                }
            }
            throw new IllegalArgumentException("DefaultUploadPolicy.getLocalizedString accepts up to 7 variable parameters (" + args.length + " values were given for the 'args' argument");
        }
        catch (IllegalFormatException ife) {
            this.displayErr(ife.getClass().getName() + " (" + ife.getMessage() + ")when managing this string: " + ret);
            throw ife;
        }
    }

    public String getUploadFilename(FileData fileData, int index) throws JUploadException {
        return this.getEncodedFilename(fileData.getFileName());
    }

    protected final String getEncodedFilename(String filename) throws JUploadException {
        if (this.filenameEncoding == null || this.filenameEncoding.equals("")) {
            return filename;
        }
        try {
            return URLEncoder.encode(filename, this.filenameEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new JUploadException(e);
        }
    }

    public String getUploadName(FileData fileData, int index) throws JUploadException {
        if (this.httpUploadParameterType.equals("array")) {
            return this.httpUploadParameterName + "[]";
        }
        if (this.httpUploadParameterType.equals("iteration")) {
            return this.httpUploadParameterName + index;
        }
        if (this.httpUploadParameterType.equals("oneFile")) {
            if (this.getNbFilesPerRequest() == 1) {
                return this.httpUploadParameterName;
            }
            throw new JUploadException("httpUploadParameterType value '" + this.httpUploadParameterType + "' is only valid when '" + "nbFilesPerRequest" + " is 1.");
        }
        throw new JUploadException("httpUploadParameterType '" + this.httpUploadParameterType + "' is not implemented.");
    }

    public String getHttpUploadParameterName() {
        return this.httpUploadParameterName;
    }

    protected void setHttpUploadParameterName(String httpUploadParameterName) throws JUploadException {
        if (httpUploadParameterName == null || httpUploadParameterName.equals("")) {
            throw new JUploadException("httpUploadParameterName may not be null");
        }
        if (!httpUploadParameterName.matches("^[a-zA-Z0-9][a-zA-Z0-9_]*$")) {
            throw new JUploadException("httpUploadParameterName may only contain letters (lowercase or uppercase) and numbers.");
        }
        this.httpUploadParameterName = httpUploadParameterName;
    }

    public String getHttpUploadParameterType() {
        return this.httpUploadParameterType;
    }

    protected void setHttpUploadParameterType(String httpUploadParameterType) throws JUploadException {
        if (httpUploadParameterType == null) {
            throw new JUploadException("httpUploadParameterType may not be null");
        }
        if (!(httpUploadParameterType.equals("array") || httpUploadParameterType.equals("iteration") || httpUploadParameterType.equals("oneFile"))) {
            throw new JUploadException("'" + httpUploadParameterType + "' is not an allowed value for httpUploadParameterType.");
        }
        if (httpUploadParameterType.equals("oneFile") && this.getNbFilesPerRequest() != 1) {
            throw new JUploadException("'" + httpUploadParameterType + "' is only valid when nbFilesPerRequest is 1.");
        }
        this.httpUploadParameterType = httpUploadParameterType;
    }

    public boolean beforeUpload() {
        return true;
    }

    public ByteArrayEncoder onAppendHeader(ByteArrayEncoder bae) throws JUploadIOException {
        Iterator<String> it = this.headers.iterator();
        this.displayDebug("[onAppendHeader] Start", 80);
        while (it.hasNext()) {
            String header = it.next();
            if (header == null || header.equals("")) {
                this.displayWarn("[onAppendHeader] Found one empty header. Ignoring it.");
                continue;
            }
            bae.append(header).append("\r\n");
            this.displayDebug("[onAppendHeader] Header appended; " + header, 80);
        }
        this.displayDebug("[onAppendHeader] End", 80);
        return bae;
    }

    public void onFileSelected(FileData fileData) {
    }

    public void onFileDoubleClicked(FileData fileData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDebugInformation(String description, Exception exception) {
        block20: {
            try {
                if (null == this.getUrlToSendErrorTo()) {
                    this.displayInfo("getUrlToSendErrorTo is null. No debug information is sent.");
                    if (exception == null) {
                        this.displayInfo("  No exception was stored!");
                    } else {
                        this.displayInfo("  The exception was: " + exception.getClass().getName() + exception.getMessage());
                    }
                    break block20;
                }
                this.displayInfo("Sending debug information to " + this.getUrlToSendErrorTo());
                if (JOptionPane.showConfirmDialog(null, this.getLocalizedString("questionSendMailOnError", new Object[0]), this.getLocalizedString("Confirm", new Object[0]), 0, 3) != 0) break block20;
                this.displayDebug("[sendDebugInformation] Within response == true", 30);
                String action = null;
                HTTPConnectionHelper connectionHelper = null;
                boolean localDebugOk = this.debugOk;
                try {
                    try {
                        URL url = new URL(this.urlToSendErrorTo);
                        connectionHelper = new HTTPConnectionHelper(this);
                        connectionHelper.initRequest(url, "POST", false, true);
                        ByteArrayEncoderHTTP baeContent = new ByteArrayEncoderHTTP(this, connectionHelper.getByteArrayEncoder().getBoundary(), connectionHelper.getByteArrayEncoder().getEncoding());
                        baeContent.appendTextProperty("description", "An error occured during upload, in JUpload.", -1);
                        String exceptionClass = null;
                        String exceptionCause = null;
                        String exceptionStackTrace = null;
                        if (exception != null) {
                            exceptionClass = exception.getClass().getName();
                            if (exception.getCause() != null) {
                                exceptionCause = exception.getCause().getClass().getName();
                            }
                            StackTraceElement[] elements = exception.getStackTrace();
                            ByteArrayEncoderHTTP baeStackTrace = new ByteArrayEncoderHTTP(this, connectionHelper.getByteArrayEncoder().getBoundary(), connectionHelper.getByteArrayEncoder().getEncoding());
                            for (int i = 0; i < elements.length; ++i) {
                                baeStackTrace.append(" at ");
                                baeStackTrace.append(elements[i].getClassName());
                                baeStackTrace.append(".");
                                baeStackTrace.append(elements[i].getMethodName());
                                baeStackTrace.append("() [line ");
                                baeStackTrace.append(Integer.toString(elements[i].getLineNumber()));
                                baeStackTrace.append("]\r\n");
                            }
                            baeStackTrace.close();
                            exceptionStackTrace = baeStackTrace.getString();
                        }
                        baeContent.appendTextProperty("exceptionClass", exceptionClass, -1);
                        baeContent.appendTextProperty("exceptionCause", exceptionCause, -1);
                        baeContent.appendTextProperty("exceptionStackTrace", exceptionStackTrace, -1);
                        String baeBound = connectionHelper.getByteArrayEncoder().getBoundary();
                        String baeEncoding = connectionHelper.getByteArrayEncoder().getEncoding();
                        ByteArrayEncoderHTTP baeDebug = new ByteArrayEncoderHTTP(this, baeBound, baeEncoding);
                        if (this.debugGenerateFile) {
                            action = "flush (debugGenerateFile=true)";
                            DefaultUploadPolicy defaultUploadPolicy = this;
                            synchronized (defaultUploadPolicy) {
                                String line;
                                this.debugOut.flush();
                                this.debugOk = false;
                                action = "read debug file (debugGenerateFile=true)";
                                BufferedReader debugIn = new BufferedReader(new FileReader(this.debugFile));
                                while ((line = debugIn.readLine()) != null) {
                                    baeDebug.append(line).append("\r\n");
                                }
                                debugIn.close();
                                this.debugOk = localDebugOk;
                            }
                        } else {
                            action = "read debug file (debugGenerateFile=false)";
                            baeDebug.append(this.juploadContext.getLogWindow().getText());
                        }
                        action = "baeDebug.close()";
                        baeDebug.close();
                        baeContent.appendTextProperty("debugOutput", baeDebug.getString(), -1);
                        baeContent.appendEndPropertyList();
                        baeContent.close();
                        action = "send request";
                        connectionHelper.append("Content-Type: multipart/form-data; boundary=").append(connectionHelper.getBoundary().substring(2)).append("\r\n");
                        connectionHelper.append("Content-length: ").append(String.valueOf(baeContent.getEncodedLength())).append("\r\n");
                        connectionHelper.sendRequest();
                        connectionHelper.append("\r\n");
                        connectionHelper.append(baeContent);
                        action = "connectionHelper.readHttpResponse()";
                        int status = connectionHelper.readHttpResponse();
                        this.displayDebug("========================================================================================", 90);
                        this.displayDebug("==================      sendDebugInformation [start]   =================================", 90);
                        this.displayDebug("========================================================================================", 90);
                        this.displayDebug("[sendDebugInformation] Sent to server: \r\n" + connectionHelper.getByteArrayEncoder().getString(), 90);
                        this.displayDebug("========================================================================================", 90);
                        this.displayDebug("[sendDebugInformation] Body received: \r\n" + connectionHelper.getResponseBody(), 90);
                        this.displayDebug("========================================================================================", 90);
                        this.displayDebug("==================      sendDebugInformation [end]     =================================", 90);
                        this.displayDebug("========================================================================================", 90);
                        if (!this.checkUploadSuccess(status, connectionHelper.getResponseMsg(), connectionHelper.getResponseBody())) {
                            throw new JUploadExceptionUploadFailed(this.getLocalizedString("errHttpResponse", new Object[0]));
                        }
                        this.displayInfo("debug information sent correctly");
                    }
                    catch (MalformedURLException e) {
                        throw new JUploadIOException("Malformed URL Exception for " + this.urlToSendErrorTo, e);
                    }
                    catch (Exception e) {
                        this.debugOk = localDebugOk;
                        this.displayErr(this.getLocalizedString("errDuringLogManagement", new Object[0]) + " (" + action + ")", e);
                        Object var19_24 = null;
                        this.debugOk = localDebugOk;
                        break block20;
                    }
                    Object var19_23 = null;
                    this.debugOk = localDebugOk;
                }
                catch (Throwable throwable) {
                    Object var19_25 = null;
                    this.debugOk = localDebugOk;
                    throw throwable;
                }
            }
            catch (JUploadIOException e) {
                this.displayErr("Could not send debug information", e);
            }
        }
    }

    public void setProperty(String prop, String value) throws JUploadException {
        this.displayDebug("[DefaultUploadPolicy] Call of setProperty: " + prop + " => " + value, 30);
        if (prop.equals("afterUploadURL")) {
            this.setAfterUploadURL(value);
        } else if (prop.equals("allowHttpPersistent")) {
            this.setAllowHttpPersistent(Boolean.parseBoolean(value));
        } else if (prop.equals("allowedFileExtensions")) {
            this.setAllowedFileExtensions(value);
        } else if (prop.equals("debugLevel")) {
            this.setDebugLevel(this.juploadContext.parseInt(value, this.debugLevel));
        } else if (prop.equals("fileChooserIconFromFileContent")) {
            this.setFileChooserIconFromFileContent(this.juploadContext.parseInt(value, this.getFileChooserIconFromFileContent()));
        } else if (prop.equals("fileChooserIconSize")) {
            this.setFileChooserIconSize(this.juploadContext.parseInt(value, this.getFileChooserIconSize()));
        } else if (prop.equals("lang")) {
            this.setLang(value);
        } else if (prop.equals("filenameEncoding")) {
            this.setFilenameEncoding(value);
        } else if (prop.equals("lookAndFeel")) {
            this.setLookAndFeel(value);
        } else if (prop.equals("maxChunkSize")) {
            this.setMaxChunkSize(this.juploadContext.parseLong(value, this.maxChunkSize));
        } else if (prop.equals("maxFileSize")) {
            this.setMaxFileSize(this.juploadContext.parseLong(value, this.maxFileSize));
        } else if (prop.equals("nbFilesPerRequest")) {
            this.setNbFilesPerRequest(this.juploadContext.parseInt(value, this.nbFilesPerRequest));
        } else if (prop.equals("postURL")) {
            this.setPostURL(value);
        } else if (prop.equals("serverProtocol")) {
            HttpProtocolFinderThread.computeServerProtocol(this, value);
        } else if (prop.equals("stringUploadSuccess")) {
            this.setStringUploadSuccess(value);
        } else if (prop.equals("sslVerifyCert")) {
            this.setSslVerifyCert(value);
        } else if (prop.equals("urlToSendErrorTo")) {
            this.setUrlToSendErrorTo(value);
        } else {
            this.displayWarn("Unknown applet parameter: " + prop + " (in DefaultUploadPolicy.setProperty)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayParameterStatus() {
        this.displayDebug("=======================================================================", 30);
        this.displayDebug("======= Parameters managed by DefaultUploadPolicy", 30);
        this.displayInfo("JUpload applet, version " + this.juploadContext.getVersion() + " (compiled: " + this.juploadContext.getBuildDate() + "), available at http://jupload.sourceforge.net/");
        this.displayDebug("Java version: " + System.getProperty("java.version"), 30);
        this.displayDebug("List of all applet parameters:", 30);
        this.displayDebug("  language: " + this.resourceBundle.getLocale().getLanguage(), 30);
        this.displayDebug("  country: " + this.resourceBundle.getLocale().getCountry(), 30);
        this.displayDebug("afterUploadURL: " + this.getAfterUploadURL(), 30);
        this.displayDebug("allowHttpPersistent: " + this.getAllowHttpPersistent(), 30);
        this.displayDebug("allowedFileExtensions: " + this.getAllowedFileExtensions(), 30);
        this.displayDebug("browsingDirectory (current value): " + this.getCurrentBrowsingDirectory(), 30);
        this.displayDebug("debugLevel: " + this.debugLevel, 1);
        DefaultUploadPolicy defaultUploadPolicy = this;
        synchronized (defaultUploadPolicy) {
            if (this.debugGenerateFile) {
                this.displayDebug("  (debugfile: " + this.debugFile.getAbsolutePath() + ")", 1);
            }
        }
        this.displayDebug("fileChooserIconFromFileContent: " + this.getFileChooserIconFromFileContent(), 30);
        this.displayDebug("fileChooserIconSize: " + this.getFileChooserIconSize(), 30);
        this.displayDebug("filenameEncoding: " + this.getFilenameEncoding(), 30);
        this.displayDebug("formdata: " + this.getFormdata(), 30);
        this.displayDebug("ftpCreateDirectoryStructure: " + this.getFtpCreateDirectoryStructure(), 30);
        this.displayDebug("ftpTransfertBinary: " + this.getFtpTransfertBinary(), 30);
        this.displayDebug("ftpTransfertPassive: " + this.getFtpTransfertPassive(), 30);
        this.displayDebug("httpUploadParameterName: " + this.getHttpUploadParameterName(), 30);
        this.displayDebug("httpUploadParameterType: " + this.getHttpUploadParameterType(), 30);
        this.displayDebug("lang: " + this.lang, 30);
        this.displayDebug("maxChunkSize: " + this.getMaxChunkSize(), 30);
        if (this.maxFileSize == Long.MAX_VALUE) {
            this.displayDebug("maxFileSize: " + this.getMaxFileSize(), 30);
        } else {
            this.displayInfo("maxFileSize: " + this.getMaxFileSize());
        }
        this.displayDebug("nbFilesPerRequest: " + this.getNbFilesPerRequest(), 30);
        this.displayDebug("postURL: " + this.postURL, 30);
        this.displayDebug("readCookieFromNavigator: " + this.readCookieFromNavigator, 30);
        this.displayDebug("readUserAgentFromNavigator: " + this.readUserAgentFromNavigator, 30);
        this.displayDebug("retryMaxNumberOf: " + this.retryMaxNumberOf, 30);
        this.displayDebug("retryNbSecondsBetween: " + this.retryNbSecondsBetween, 30);
        this.displayDebug("serverProtocol: " + this.getServerProtocol(), 30);
        this.displayDebug("showLogWindow: " + this.getShowLogWindow(), 30);
        this.displayDebug("showStatusbar: " + this.showStatusbar, 30);
        this.displayDebug("specificHeaders: " + this.getSpecificHeaders(), 30);
        this.displayDebug("Headers that will be added to the POST request: ", 30);
        Iterator<String> it = this.headers.iterator();
        while (it.hasNext()) {
            this.displayDebug(it.next() + "\n", 30);
        }
        this.displayDebug("stringUploadError: " + this.getStringUploadError(), 30);
        this.displayDebug("stringUploadSuccess: " + this.getStringUploadSuccess(), 30);
        this.displayDebug("stringUploadWarning: " + this.getStringUploadWarning(), 30);
        this.displayDebug("urlToSendErrorTo: " + this.getUrlToSendErrorTo(), 30);
        this.displayDebug("", 30);
    }

    public String getAfterUploadURL() {
        return this.afterUploadURL;
    }

    protected void setAfterUploadURL(String afterUploadURL) throws JUploadException {
        if (null == afterUploadURL) {
            return;
        }
        this.afterUploadURL = afterUploadURL.toLowerCase().startsWith("javascript:") ? afterUploadURL : this.juploadContext.normalizeURL(afterUploadURL);
    }

    public boolean getAllowHttpPersistent() {
        return this.allowHttpPersistent;
    }

    public String getAllowedFileExtensions() {
        return this.allowedFileExtensions;
    }

    protected void setAllowedFileExtensions(String allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions == null || allowedFileExtensions.equals("") ? null : (allowedFileExtensions.startsWith("/") ? "" : "/") + allowedFileExtensions.toLowerCase() + (allowedFileExtensions.endsWith("/") ? "" : "/");
    }

    protected void setAllowHttpPersistent(boolean value) {
        this.allowHttpPersistent = value;
    }

    public JUploadContext getContext() {
        return this.juploadContext;
    }

    public void setCurrentBrowsingDirectory(File currentBrowsingDirectoryParam) {
        try {
            if (currentBrowsingDirectoryParam.isDirectory()) {
                this.currentBrowsingDirectory = currentBrowsingDirectoryParam;
            } else {
                this.displayWarn("DefaultUploadPolicy.setCurrentBrowsingDirectory(): " + currentBrowsingDirectoryParam + " doesn't exist.");
            }
        }
        catch (SecurityException se) {
            this.displayWarn(se.getClass().getName() + " in DefaultUploadPolicy.setCurrentBrowsingDirectory(): " + currentBrowsingDirectoryParam + " is ignored.");
        }
    }

    public void setCurrentBrowsingDirectory(String currentBrowsingDirectoryParam) {
        try {
            if (currentBrowsingDirectoryParam == null) {
                this.currentBrowsingDirectory = null;
            } else {
                if (currentBrowsingDirectoryParam.startsWith("~")) {
                    currentBrowsingDirectoryParam = System.getProperty("user.home") + currentBrowsingDirectoryParam.substring(1);
                }
                this.currentBrowsingDirectory = new File(currentBrowsingDirectoryParam);
                if (this.currentBrowsingDirectory != null && !this.currentBrowsingDirectory.isDirectory()) {
                    this.displayWarn("DefaultUploadPolicy.setCurrentBrowsingDirectory(): <" + currentBrowsingDirectoryParam + "> doesn't exist or is not a directory.");
                    this.currentBrowsingDirectory = null;
                }
            }
        }
        catch (SecurityException se) {
            this.displayWarn(se.getClass().getName() + " in DefaultUploadPolicy.setCurrentBrowsingDirectory(): " + currentBrowsingDirectoryParam + " is ignored.");
        }
    }

    public File getCurrentBrowsingDirectory() {
        return this.currentBrowsingDirectory;
    }

    public String getDateFormat() {
        return "dd/MM/yyyy HH:mm:ss";
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        this.setDebugLevel(debugLevel, true);
    }

    public synchronized void setDebugLevel(int debugLevel, boolean displayAppletParameterList) {
        if (this.debugLevel >= 0) {
            this.displayInfo("Debug level set to " + debugLevel);
            if (this.debugGenerateFile) {
                this.displayInfo("Current debug output file: " + this.debugFile.getAbsolutePath());
            }
        }
        this.debugLevel = debugLevel;
        if (displayAppletParameterList) {
            this.displayParameterStatus();
        }
    }

    public int getFileChooserIconFromFileContent() {
        return this.fileChooserIconFromFileContent;
    }

    public void setFileChooserIconFromFileContent(int fileChooserIconFromFileContent) {
        if (fileChooserIconFromFileContent != -1 && fileChooserIconFromFileContent != 0 && fileChooserIconFromFileContent != 1) {
            throw new IllegalArgumentException("fileChooserIconFromFileContent must be one of -1, 0, 1");
        }
        this.fileChooserIconFromFileContent = fileChooserIconFromFileContent;
    }

    public int getFileChooserIconSize() {
        return this.fileChooserIconSize;
    }

    public void setFileChooserIconSize(int fileChooserIconSize) {
        if (fileChooserIconSize <= 0) {
            throw new IllegalArgumentException("fileChooserIconSize must be more than 0");
        }
        this.fileChooserIconSize = fileChooserIconSize;
    }

    public void setLang(String lang) {
        Locale locale;
        this.lang = lang;
        if (lang == null) {
            this.displayInfo("lang = null, taking default language");
            locale = Locale.getDefault();
        } else if (lang.length() == 5 && (lang.substring(2, 3).equals("_") || lang.substring(2, 3).equals("-"))) {
            String language = lang.substring(0, 2);
            String country = lang.substring(3, 5);
            this.displayDebug("setLang - language read: " + language, 50);
            this.displayDebug("setLang - country read: " + country, 50);
            locale = new Locale(language, country.toUpperCase());
        } else {
            locale = new Locale(lang);
            this.displayDebug("setLang - language read (no country): " + lang, 50);
        }
        this.resourceBundle = ResourceBundle.getBundle("wjhk.jupload2.lang.lang", locale, new ClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                throw new ClassNotFoundException();
            }

            @Override
            public InputStream getResourceAsStream(String name) {
                return this.getClass().getClassLoader().getResourceAsStream(name);
            }
        });
    }

    protected String getLookAndFeel() {
        return this.lookAndFeel;
    }

    protected void setLookAndFeel(String lookAndFeel) {
        try {
            this.lookAndFeel = lookAndFeel;
            if (lookAndFeel != null && !lookAndFeel.equals("") && !lookAndFeel.equals("java")) {
                if (!lookAndFeel.equals("system")) {
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            } else {
                this.lookAndFeel = "java";
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
        }
        catch (Exception e) {
            this.displayErr(e);
            try {
                this.lookAndFeel = "java";
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            }
            catch (UnsupportedLookAndFeelException e1) {
                this.displayErr(e1);
                this.lookAndFeel = null;
            }
        }
    }

    public long getMaxChunkSize() {
        return this.maxChunkSize;
    }

    protected void setMaxChunkSize(long maxChunkSize) {
        if (maxChunkSize <= 0L) {
            this.displayDebug("maxChunkSize<=0 which is invalid. Switched to the default value (Long.MAX_VALUE)", 1);
            maxChunkSize = Long.MAX_VALUE;
        }
        this.maxChunkSize = maxChunkSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    protected void setMaxFileSize(long maxFileSize) {
        if (maxFileSize <= 0L) {
            this.displayDebug("maxFileSize<=0 which is invalid. Switched to the default value (Long.MAX_VALUE)", 1);
            maxFileSize = Long.MAX_VALUE;
        }
        this.maxFileSize = maxFileSize;
    }

    public int getNbFilesPerRequest() {
        return this.nbFilesPerRequest;
    }

    protected void setNbFilesPerRequest(int nbFilesPerRequest) throws JUploadException {
        if (this.getHttpUploadParameterType().equals("oneFile") && nbFilesPerRequest != 1) {
            throw new JUploadException("nbFilesPerRequest must be 1, when httpUploadParameterType is oneFile");
        }
        if (nbFilesPerRequest <= 0) {
            this.displayDebug("nbFilesPerRequest<=0 which is invalid. Switched to the default value (Integer.MAX_VALUE)", 1);
            this.nbFilesPerRequest = Integer.MAX_VALUE;
        } else {
            this.nbFilesPerRequest = nbFilesPerRequest;
        }
    }

    public String getFilenameEncoding() {
        return this.filenameEncoding;
    }

    protected void setFilenameEncoding(String filenameEncoding) {
        if (filenameEncoding != null && filenameEncoding.equals("")) {
            filenameEncoding = null;
        }
        if (filenameEncoding != null && !Charset.isSupported(filenameEncoding)) {
            throw new UnsupportedCharsetException("non supported charset (" + filenameEncoding + ")");
        }
        this.filenameEncoding = filenameEncoding;
    }

    public boolean getFtpCreateDirectoryStructure() {
        return this.ftpCreateDirectoryStructure;
    }

    protected void setFtpCreateDirectoryStructure(boolean ftpCreateDirectoryStructure) {
        this.ftpCreateDirectoryStructure = ftpCreateDirectoryStructure;
    }

    public boolean getFtpTransfertBinary() {
        return this.ftpTransfertBinary;
    }

    protected void setFtpTransfertBinary(boolean ftpTransfertBinary) {
        this.ftpTransfertBinary = ftpTransfertBinary;
    }

    public boolean getFtpTransfertPassive() {
        return this.ftpTransfertPassive;
    }

    protected void setFtpTransfertPassive(boolean ftpTransfertPassive) {
        this.ftpTransfertPassive = ftpTransfertPassive;
    }

    public String getPostURL() {
        return this.postURL;
    }

    public void setPostURL(String postURL) throws JUploadException {
        this.postURL = this.juploadContext.normalizeURL(postURL);
    }

    public boolean getReadCookieFromNavigator() {
        return this.readCookieFromNavigator;
    }

    protected void setReadCookieFromNavigator(boolean readCookieFromNavigator) {
        this.readCookieFromNavigator = readCookieFromNavigator;
    }

    public boolean getReadUserAgentFromNavigator() {
        return this.readUserAgentFromNavigator;
    }

    protected void setReadUserAgentFromNavigator(boolean readUserAgentFromNavigator) {
        this.readUserAgentFromNavigator = readUserAgentFromNavigator;
    }

    public int getRetryMaxNumberOf() {
        return this.retryMaxNumberOf;
    }

    public void setRetryMaxNumberOf(int retryMaxNumberOf) {
        if (retryMaxNumberOf < 0) {
            throw new IllegalArgumentException("retryMaxNumberOf must be 0 or more");
        }
        this.retryMaxNumberOf = retryMaxNumberOf;
    }

    public int getRetryNbSecondsBetween() {
        return this.retryNbSecondsBetween;
    }

    public void setRetryNbSecondsBetween(int retryNbSecondsBetween) {
        if (retryNbSecondsBetween < 0) {
            throw new IllegalArgumentException("retryNbSecondsBetween must be 0 or more");
        }
        this.retryNbSecondsBetween = retryNbSecondsBetween;
    }

    public String getServerProtocol() {
        if (this.serverProtocol == null) {
            return "HTTP/1.1";
        }
        return this.serverProtocol;
    }

    public void setServerProtocol(String serverProtocol) {
        this.serverProtocol = serverProtocol;
    }

    public String getShowLogWindow() {
        return this.showLogWindow;
    }

    public void setShowLogWindow(String showLogWindow) {
        if (showLogWindow.equals("true") || showLogWindow.equals("false") || showLogWindow.equals("onError")) {
            this.showLogWindow = showLogWindow;
            if (this.juploadContext.getUploadPanel() != null) {
                this.juploadContext.getUploadPanel().showOrHideLogWindow();
            }
        } else {
            this.displayWarn("[setShowLogWindow] Unallowed value: " + showLogWindow + " (showLogWindow is left unchanged)");
        }
    }

    public String getSpecificHeaders() {
        return this.specificHeaders;
    }

    protected void setSpecificHeaders(String specificHeaders) {
        this.specificHeaders = specificHeaders;
        if (specificHeaders != null) {
            String[] headerArray = specificHeaders.split("\\\\n");
            for (int x = 0; x < headerArray.length; ++x) {
                this.addHeader(headerArray[x]);
            }
        }
    }

    public int getSslVerifyCert() {
        return this.sslVerifyCert;
    }

    protected void setSslVerifyCert(String mode) throws JUploadException {
        int val = -1;
        if (mode.toLowerCase().equals("none")) {
            val = 0;
        }
        if (mode.toLowerCase().equals("server")) {
            val = 1;
        }
        if (mode.toLowerCase().equals("client")) {
            val = 2;
        }
        if (mode.toLowerCase().equals("strict")) {
            val = 3;
        }
        if (val == -1) {
            throw new JUploadException("Invalid parameter sslVerifyCert (" + mode + ")");
        }
        this.sslVerifyCert = val;
    }

    protected void setShowStatusbar(boolean show) {
        this.showStatusbar = show;
    }

    public String getStringUploadError() {
        return this.stringUploadError;
    }

    public String getStringUploadSuccess() {
        return this.stringUploadSuccess;
    }

    public String getStringUploadWarning() {
        return this.stringUploadWarning;
    }

    protected void setStringUploadError(String stringUploadError) throws JUploadException {
        this.stringUploadError = stringUploadError;
        if (stringUploadError != null) {
            try {
                this.patternError = Pattern.compile(stringUploadError);
            }
            catch (PatternSyntaxException e) {
                throw new JUploadException("Invalid regex in parameter stringUploadError");
            }
        }
    }

    protected void setStringUploadSuccess(String stringUploadSuccess) throws JUploadException {
        this.stringUploadSuccess = stringUploadSuccess;
        if (stringUploadSuccess != null) {
            try {
                this.patternSuccess = Pattern.compile(stringUploadSuccess);
            }
            catch (PatternSyntaxException e) {
                throw new JUploadException("Invalid regex in parameter stringUploadSuccess");
            }
        }
    }

    protected void setStringUploadWarning(String stringUploadWarning) throws JUploadException {
        this.stringUploadWarning = stringUploadWarning;
        if (stringUploadWarning != null) {
            try {
                this.patternWarning = Pattern.compile(stringUploadWarning);
            }
            catch (PatternSyntaxException e) {
                throw new JUploadException("Invalid regex in parameter stringUploadWarning");
            }
        }
    }

    public String getUrlToSendErrorTo() {
        return this.urlToSendErrorTo;
    }

    public void setUrlToSendErrorTo(String urlToSendErrorTo) throws JUploadException {
        if (null == urlToSendErrorTo) {
            return;
        }
        String tmp = this.juploadContext.normalizeURL(urlToSendErrorTo);
        if (tmp.startsWith("ftp://")) {
            throw new JUploadException("urlToSendErrorTo: ftp scheme not supported.");
        }
        this.urlToSendErrorTo = tmp;
    }

    public String getFormdata() {
        return this.formData;
    }

    public String getAfterUploadTarget() {
        return this.afterUploadTarget;
    }

    public synchronized void deleteLog() {
        if (this.debugGenerateFile) {
            try {
                if (null != this.debugOut) {
                    this.debugOut.close();
                    this.debugOut = null;
                }
                if (null != this.debugFile) {
                    if (!this.debugFile.delete()) {
                        this.displayWarn(this.debugFile.getName() + " was not correctly removed!");
                    }
                    this.debugFile = null;
                }
            }
            catch (Exception e) {
                this.displayWarn(e.getClass().getName() + " occured in deleteLog(). Exception ignored.");
            }
        }
    }

    protected synchronized void addMsgToDebugLog(String msg) {
        block6: {
            if (this.debugGenerateFile && this.debugOk) {
                try {
                    if (null == this.debugOut) {
                        this.juploadContext.registerUnload(this, "deleteLog");
                        this.debugFile = File.createTempFile("jupload_", "_log.txt");
                        this.debugOut = new PrintStream(new FileOutputStream(this.debugFile));
                    }
                    boolean endsLF = msg.endsWith("\n");
                    msg = msg.replaceAll("\n", this.CRLF);
                    if (endsLF) {
                        this.debugOut.print(msg);
                        break block6;
                    }
                    this.debugOut.println(msg);
                }
                catch (IOException e) {
                    this.debugOk = false;
                    System.err.println("IO error on debuglog " + this.debugFile.getPath() + "\nFallback to standard output.");
                    System.out.println(msg);
                }
            } else {
                System.out.println(msg);
            }
        }
    }

    private void displayMsg(String tag, String msg) {
        String message;
        if (this.juploadContext.getLogWindow() == null) {
            message = tag + " - " + msg;
            System.out.println(message);
        } else {
            message = this.juploadContext.getLogWindow().displayMsg(tag, msg);
        }
        if (this.debugGenerateFile) {
            this.addMsgToDebugLog(message);
        }
    }

    public void afterFileDropped(DropTargetDropEvent dropEvent) {
    }

    public JUploadFileChooser createFileChooser() {
        return new JUploadFileChooser(this);
    }

    public boolean fileFilterAccept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.allowedFileExtensions == null || this.allowedFileExtensions.equals("")) {
            return true;
        }
        String extension = DefaultFileData.getExtension(file).toLowerCase();
        return this.allowedFileExtensions.indexOf("/" + extension + "/") >= 0;
    }

    public String fileFilterGetDescription() {
        if (this.allowedFileExtensions == null || this.allowedFileExtensions.equals("")) {
            return null;
        }
        return "JUpload file filter (" + this.allowedFileExtensions + ")";
    }

    public Icon fileViewGetIcon(File file) {
        return null;
    }

    public JUploadException getLastException() {
        return this.lastException;
    }

    public void setLastException(JUploadException exception) {
        this.lastException = exception;
        if (this.juploadContext.getUploadPanel() != null) {
            this.juploadContext.getUploadPanel().showOrHideLogWindow();
        }
    }

    public String getLastResponseBody() {
        return this.lastResponseBody;
    }

    public String getLastResponseMessage() {
        return null != this.lastResponseMessage ? this.lastResponseMessage : "";
    }

    public Cursor setCursor(Cursor cursor) {
        return this.juploadContext.setCursor(cursor);
    }

    public Cursor setWaitCursor() {
        return this.juploadContext.setWaitCursor();
    }
}

