/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JTextArea;
import wjhk.jupload2.policies.UploadPolicy;

public class JUploadTextArea
extends JTextArea {
    public static final int MAX_LOG_WINDOW_LENGTH = 800000;
    public static final int SIZE_TO_TRUNCATE_TO = 640000;
    UploadPolicy uploadPolicy;
    boolean loggingActive = false;
    private BlockingQueue<String> messages;
    private int messageId = 1;
    LogMessageThread logMessageThread = null;

    public JUploadTextArea(int rows, int columns, UploadPolicy uploadPolicy) {
        super(rows, columns);
        this.uploadPolicy = uploadPolicy;
        this.messages = new LinkedBlockingQueue<String>();
        this.setBackground(new Color(255, 255, 203));
        this.setEditable(false);
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.logMessageThread = new LogMessageThread(this);
        this.logMessageThread.setName(this.logMessageThread.getClass().getName());
    }

    public final synchronized String displayMsg(String tag, String msg) {
        String fullMessage = this.formatMessageOutput(tag, msg);
        try {
            this.messages.put(fullMessage);
        }
        catch (InterruptedException e) {
            System.out.println("WARNING - [" + this.getClass().getName() + "] Message lost due to " + e.getClass().getName() + " (" + fullMessage + ")");
        }
        return fullMessage;
    }

    public void setUploadPolicy(UploadPolicy uploadPolicy) {
        this.uploadPolicy = uploadPolicy;
        this.uploadPolicy.getContext().registerUnload(this, "unload");
        this.loggingActive = true;
        this.logMessageThread.start();
    }

    public synchronized void unload() {
        this.loggingActive = false;
        this.logMessageThread.interrupt();
    }

    String formatMessageOutput(String tag, String msg) {
        String stamp = String.format("%1$05d", this.messageId++) + " \t" + new SimpleDateFormat("HH:mm:ss.SSS ").format(new Date()) + "\t" + Thread.currentThread().getName() + "\t" + tag + " \t";
        while (msg.endsWith("\n")) {
            msg = msg.substring(0, msg.length() - 1);
        }
        return stamp + msg.replaceAll("\n", "\n" + stamp);
    }

    static class LogMessageThread
    extends Thread {
        private JUploadTextArea textArea;
        int textLength = 0;

        LogMessageThread(JUploadTextArea textArea) {
            this.textArea = textArea;
            this.setDaemon(true);
        }

        public void run() {
            String nextMessage = null;
            if (this.textArea.uploadPolicy.getDebugLevel() >= 30) {
                int messageBackup = this.textArea.messageId;
                this.textArea.messageId = 0;
                this.textArea.setText(this.textArea.formatMessageOutput("[DEBUG]", "Logging system is initialized\n"));
                this.textArea.messageId = messageBackup;
            }
            while (this.textArea.loggingActive) {
                try {
                    nextMessage = (String)this.textArea.messages.take() + "\n";
                    if (this.textLength > 800000) {
                        String content = this.textArea.getText() + nextMessage;
                        String newContent = content.substring(content.length() - 640000, content.length());
                        this.textArea.setText(newContent);
                        this.textLength = 640000;
                    } else {
                        this.textArea.append(nextMessage);
                        this.textLength += nextMessage.length();
                    }
                    this.textArea.setCaretPosition(this.textLength - 1);
                }
                catch (InterruptedException e) {
                    if (!this.textArea.loggingActive) continue;
                    e.printStackTrace();
                }
            }
        }
    }
}

