<?php
/*
 * --------------------------------------------------------------------------------
 * K2Store Stock Notification Plugin
 * --------------------------------------------------------------------------------
 * @package		Joomla! 2.5+
 * @subpackage	K2Store
 * @author 		Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * --------------------------------------------------------------------------------
 */

/**
 * ensure this file is being included by a parent file
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

require_once (JPATH_ADMINISTRATOR . '/components/com_k2store/library/plugins/_base.php');
require_once (JPATH_SITE . '/components/com_k2store/helpers/utilities.php');
class plgK2StoreStock_Notification extends K2StorePluginBase {

	var $_element = 'stock_notification';

	// function plgK2StoreStock_Notification(& $subject, $config) {
	// 	parent::__construct ( $subject, $config );
	// 	$this->loadLanguage ( 'com_k2store', JPATH_ADMINISTRATOR );
	// }
	function __construct(&$subject, $config)
{
    parent::__construct($subject, $config);
    $this->loadLanguage('', JPATH_ADMINISTRATOR);
}

	function onK2StoreBeforeInventory($order_id) {

	}

	function onK2StoreAfterInventory($order_id) {
		JTable::addIncludePath ( JPATH_ADMINISTRATOR . '/components/com_k2store/tables' );
		require_once (JPATH_ADMINISTRATOR . '/components/com_k2store/library/inventory.php');

		$params = JComponentHelper::getParams ( 'com_k2store' );

		// notify only if the enable inventory is set to yes.
		if (!$params->get ( 'enable_inventory', 0 )) {
			return true;
		}

		//$order = JTable::getInstance ( 'Orders', 'Table' );
		try {
			//$order->load ( ( int ) $order_id );

			require_once(JPATH_SITE.'/components/com_k2store/models/orders.php');
			$model =  new K2StoreModelOrders();
			//lets set the id first
			$model->setId($order_id);
			$order = $model->getItem();

			// products to be notified
			$products = array ();
			foreach ( $order->orderitems as $item ) {
				// load the stock
				$productqty = JTable::getInstance ( 'ProductQuantities', 'Table' );
				$product = JTable::getInstance ( 'Products', 'Table' );
				if ($productqty->load ( array (
						'product_id' => $item->product_id,
						'product_attributes'=>$item->attributes_csv
					) )) {

					$product->load(array('product_id'=>$item->product_id));
						//check if inventory tracking is enable for this product && if the quantity is less than the notify quantity
					if(isset($productqty->quantity)) {
						if($product->manage_stock == 1 && ($productqty->quantity <= $product->notify_qty || $productqty->quantity < 1)) {
								$products[$item->product_id]['product_id'] = $item->product_id;
								$products[$item->product_id]['product_name'] = $item->orderitem_name;
								$products[$item->product_id]['stock'] = $productqty->quantity;
								$products[$item->product_id]['notify_qty'] = $product->notify_qty;
							}
					}
				}
			}
		} catch ( Exception $e ) {
			// do nothing
		}

		if(count($products)) {
			//send the notification
			$this->_sendNotification($products);

		}

		return;
	}

	private function _sendNotification($products) {

		//get params
		$params = JComponentHelper::getParams('com_k2store');
		$app =JFactory::getApplication();
		$config = JFactory::getConfig();

		$admin_emails = $params->get('admin_email', '');
		$emails = explode(',', $admin_emails);

		//get the emails if set from the plugin params
		$stock_emails = $this->params->get('stock_emails', '');
		if(!empty($stock_emails)) {
			$stock_emails = explode(',', $stock_emails);
			$emails = array_merge($stock_emails, $emails);
		}

		//get the mailer
		$mailer = clone JFactory::getMailer();

		$mailer->IsHTML(true);
		// Required in order not to get broken characters
		$mailer->CharSet = 'UTF-8';

		if(version_compare(JVERSION, '3.0', 'ge')) {
			$mailfrom = $params->get('emails_defaultemail', $config->get('mailfrom'));
			$fromname = $params->get('emails_defaultname', $config->get('fromname'));
			$sitename = $config->get('sitename');
		} else {
			$mailfrom = $params->get('emails_defaultname', $config->getValue('config.mailfrom'));
			$fromname = $params->get('emails_defaultname', $config->getValue('config.fromname'));
			$sitename = $config->getValue('config.sitename');
		}

		//set subject
		$subject = JText::sprintf('K2STORE_STOCK_NOTIFICATION_EMAIL_SUBJECT', $sitename);
		$mailer->setSubject($subject);

		//get the body html
		$html = $this->_getLayout('email', $products);
		$mailer->setBody($html);

		$mailer->addRecipient($emails);
		$mailer->setSender(array( $mailfrom, $fromname ));
		$mailer->send();
		return true;
	}
}