<?php
/*------------------------------------------------------------------------
# com_k2store - K2Store
# ------------------------------------------------------------------------
# author    Ramesh Elamathi - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2014 - 19 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://k2store.org
# Technical Support:  Forum - http://k2store.org/forum/index.html
-------------------------------------------------------------------------*/
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.model');

JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_k2store/tables');

class K2StoreModelMyprofile extends K2StoreModel {

	 public function getAddress()
		{

			// Lets load the content if it doesn't already exist
			if (empty($this->_data))
			{
				$query = $this->_buildQuery();
				$this->_data = $this->_getList($query);
			}
			return $this->_data;
		}


		/**
		 *  Method for building Query object
		 *  @retun Query object joomla's default query Object
		 */
		function _buildQuery()
		{
		/** Get a DB Object */
		$db = JFactory::getDbo();

		/** get the current query Object **/
		$query = $db->getQuery(true);
		/** Add a single column, or array of columns to the SELECT clause of the query */
		$query->select('a.*')->from('#__k2store_address AS a');

		/**  Add a LEFT JOIN clause to the query */
		$query->leftJoin('#__k2store_countries AS c ON c.country_id = a.country_id');

		$query->select('c.country_name');
		$query->leftJoin('#__k2store_zones AS z ON z.zone_id=a.zone_id');
		$query->select('z.zone_name');
		$this->_buildWhere($query);
		return $query;
		}


		/**
		 * Method for Where query object
		 * @param query Object joomla's default query object
		 * @return query object returns query after setting where condition
		 *
		 */
		 function _buildWhere(&$query)
		{
			$user = JFactory::getUser();
			$query->where('a.email='.$this->_db->quote($user->email))
			->where('a.user_id='.$this->_db->quote($user->id));
		}


		function saveAddress($data){

		$row = JTable::getInstance('address', 'Table');
		$user = JFactory::getUser();

		if(!$row->bind($data)){
			return false;
		}
		$row->user_id = $user->id;
		$row->email = $user->email;

		if(!$row->check($data)){
			return false;
		}

		if(!$row->store($data)){
			return false;
		}

		return $data ;
		}



}
