<?php
/*------------------------------------------------------------------------
 # com_k2store - K2 Store
 # ------------------------------------------------------------------------
 # author    Ramesh Elamathi - Weblogicx India http://www.weblogicxindia.com
 # copyright Copyright (C) 2012 Weblogicxindia.com. All Rights Reserved.
 # @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 # Websites: http://k2store.org
 # Technical Support:  Forum - http://k2store.org/forum/index.html
 -------------------------------------------------------------------------*/


// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');

class K2StoreControllerProduct extends K2StoreController {

	/**
	 * Will execute a task within a shipping plugin
	 *
	 * (non-PHPdoc)
	 * @see application/component/JController::execute()
	 */
	function execute( $task )
	{

		$app = JFactory::getApplication();
		$productTask = $app->input->getCmd('productTask', '');
		$values = $app->input->getArray($_POST);
		//print_r($values);

		// Check if we are in a product view. If it is so,
		// Try lo load the product plugin controller (if any)
		if ( $task  == "view" && $productTask != '')
		{

			$model = $this->getModel('Shipping', 'K2StoreModel');

			$id = $app->input->getInt('id', '0');

			if(!$id)
				parent::execute($task);

			$model->setId($id);

			// get the data
			// not using getItem here to enable ->checkout (which requires JTable object)
			$row = $model->getTable();
			$row->load( (int) $model->getId() );
			$element = $row->element;

			// The name of the Product Controller should be the same of the $_element name,
			// without the shipping_ prefix and with the first letter Uppercase, and should
			// be placed into a controller.php file inside the root of the plugin
			$controllerName = str_ireplace('product_', '', $element);
			$controllerName = ucfirst($controllerName);

			$path = JPATH_SITE.'/plugins/k2store/';

			$controllerPath = $path.$element.'/'.$element.'/controller.php';

			if (file_exists($controllerPath)) {
				require_once $controllerPath;
			} else {
				$controllerName = '';
			}

			$className    = 'K2StoreControllerProduct'.$controllerName;

			if ($controllerName != '' && class_exists($className)){

				// Create the controller
				$controller   = new $className( );

				// Add the view Path
				$controller->addViewPath($path);

				// Perform the requested task
				$controller->execute( $productTask );

				// Redirect if set by the controller
				$controller->redirect();

			} else{
				parent::execute($task);
			}
		} else{
			parent::execute($task);
		}
	}
}