<?php
/**
 * @version		2.6.x
 * @package		K2
 * @author		JoomlaWorks http://www.joomlaworks.net
 * @copyright	Copyright (c) 2006 - 2014 JoomlaWorks Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die;

// show number of populer items
$populerItemsQuantity= Helix::Param('k2POPULERITEMS_QUANTITY');

$user 	= JFactory::getUser();
$db 	= JFactory::getDbo();

$query = "SELECT a.id FROM #__k2_categories as a";
$query .= " WHERE a.published = 1 AND a.access IN(".implode(',', $user->getAuthorisedViewLevels()).") AND a.trash = 0";
$query .= " AND a.parent=" . $this->category->id;
$db->setQuery( $query );

$cats = $db->loadColumn();
array_unshift($cats, $this->category->id);
$catIds = implode(',', $cats);


//Popular Items
$query = "SELECT a.*, b.name AS categoryname, b.id AS categoryid, b.alias AS categoryalias";
$query .= " FROM #__k2_items as a";
$query .= " LEFT JOIN #__k2_categories b ON b.id = a.catid ";
$query .= " WHERE a.published = 1 AND a.access IN(".implode(',', $user->getAuthorisedViewLevels()).") AND a.trash = 0 AND a.catid IN ($catIds)";
$query .= " ORDER By a.hits";
$db->setQuery( $query, 0, $populerItemsQuantity );

$popular_items = $db->loadObjectList();

?>

<!-- Start K2 Category Layout -->
<div id="k2Container" class="itemListView<?php if($this->params->get('pageclass_sfx')) echo ' '.$this->params->get('pageclass_sfx'); ?>">
	
	<?php if (Helix::Param('SHOW_K2_POPULERITEMS') == 1) { ?>
	<!-- K2 Populer Items -->
	<div class="populerItemsListWrapper">
		<div class="populerItemsheader">		
			<h3 class="header">			
				<span><?php echo Helix::Param('k2POPULERITEMS_TITLE'); ?></span>
			</h3>
			<div id="k2ModuleBox150" class="k2ItemsBlock  sp-popular-packages">
				<p class="modulePretext"> <?php echo Helix::Param('k2POPULERITEMS_DESCRIPTION'); ?> </p>
			</div>
		</div>

		<?php $totalPopulerItems = count($popular_items); ?>

		<div class="row-fluid populerPackageItemslisting sp-popular-packages">

		  <ul class="k2ContentItemsList">
			<?php foreach ($popular_items as $key => $value) { ?>
		  	   <!-- Start: K2 Populer Items -->
		  	   <?php
					$link = urldecode(JRoute::_(K2HelperRoute::getItemRoute($value->id.':'.urlencode($value->alias), $value->catid.':'.urlencode($value->categoryalias))));
				?>
				<?php 
					$populerExtraField= json_decode($value->extra_fields); 
					$populerStoreItemInfo = json_decode($value->plugins); 

				?>

				<li class="even firstItem">
					<div class="k2ContentItemWrapper">
				      
			            <div class="moduleItemImage">
					      	<a href="<?php echo $link; ?>" title="<?php echo $value->title;?>" class="populer-travel-package-link">
				  	  			<img src="media/k2/items/cache/<?php echo md5("Image" . $value->id); ?>_S.jpg" style="width:<?php echo $this->item->imageWidth; ?>px; height:auto;">
				  	  		</a>
				  	    </div>
				            
					    <div class="catItemHeader">
					      	<div class="innerIteminfoWrapper">
						      	<div class="moduleItemExtraFields">
							      	<!-- Item Header -->
						  	  		<div class="catItemsDurationPrice">

						  	  			<?php if (isset($populerExtraField[0]->value)): ?>
							      			<span class="itemPackageDuration">
							      				<?php echo $populerExtraField[0]->value; ?>
							      			</span>
							      		<?php endif ?>
								      	<?php if (isset($populerExtraField[1]->value)): ?>
								      		<span class="itemBeforePrice">
								      			<?php echo $populerExtraField[1]->value; ?>
								      		</span>
								      	<?php endif ?>


								      	<?php if ($populerStoreItemInfo->k2storeitem_price): ?>			      	
								      		<span class="moduleItemPrice">
								      			<?php if($populerStoreItemInfo->k2storespecial_price > 0.000) echo '<strike>'; ?>
								      			<?php echo K2StoreHelperCart::dispayPriceWithTax($populerStoreItemInfo->k2storeitem_price, $populerStoreItemInfo->k2storeitem_tax); ?>
								      			<?php if($populerStoreItemInfo->k2storespecial_price > 0.000) echo '</strike>'; ?>
								      		</span>
								      	<?php endif ?>

								      	<?php if ($populerStoreItemInfo->k2storespecial_price > 0.000): ?>
								      		<span class="moduleItemSpecialPrice">
								      			<?php echo K2StoreHelperCart::dispayPriceWithTax($populerStoreItemInfo->k2storespecial_price, $populerStoreItemInfo->k2storeitem_tax); ?>
								      		</span>
								      	<?php endif ?>
						  	  		</div>
							    </div>
						  	   	<div class="clr"></div>

						  	   	<h3 class="catItemTitle">
			  						<a class="moduleItemTitle" href="<?php echo $link; ?>"> <?php echo $value->title;?> </a>
			  				 	</h3>

						        <div class="clr"></div>
							    <a class="btn btn-primary moduleItemReadMore" href="<?php echo $link; ?>">
									<?php echo JText::_('K2_GET_IT_NOW'); ?>		
								</a>
							</div> <!-- /.innerIteminfoWrapper -->
						</div> 
				      
				      <div class="clr"></div>
				    </div>
			    </li>

		  	  <!-- END:: K2 Populer Items -->
		  	  <?php }?>
	  	  </ul>
	  	</div> <!-- ./row-fluid -->

	</div> <!-- ./populerItemsListWrapper -->

	<!-- END:: K2 Populer Items -->
	<?php }; ?>


	<?php if($this->params->get('show_page_title')): ?>
	<!-- Page title -->
	<div class="componentheading<?php echo $this->params->get('pageclass_sfx')?>">
		<h3 class="<?php echo $this->params->get('pageclass_sfx')?>"><span> <?php echo $this->escape($this->params->get('page_title')); ?></span></h3>
	</div>
	<?php endif; ?>

	<?php if($this->params->get('catFeedIcon')): ?>
	<!-- RSS feed icon -->
	<div class="k2FeedIcon">
		<a href="<?php echo $this->feed; ?>" title="<?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?>">
			<span><?php echo JText::_('K2_SUBSCRIBE_TO_THIS_RSS_FEED'); ?></span>
		</a>
		<div class="clr"></div>
	</div>
	<?php endif; ?>

	<?php if(isset($this->category) || ( $this->params->get('subCategories') && isset($this->subCategories) && count($this->subCategories) )): ?>
	<!-- Blocks for current category and subcategories -->
	<div class="itemListCategoriesBlock">

		<?php if(isset($this->category) && ( $this->params->get('catImage') || $this->params->get('catTitle') || $this->params->get('catDescription') || $this->category->event->K2CategoryDisplay )): ?>
		<!-- Category block -->
		<div class="itemListCategory">

			<?php if(isset($this->addLink)): ?>
			<!-- Item add link -->
			<span class="catItemAddLink">
				<a class="modal" rel="{handler:'iframe',size:{x:990,y:650}}" href="<?php echo $this->addLink; ?>">
					<?php echo JText::_('K2_ADD_A_NEW_ITEM_IN_THIS_CATEGORY'); ?>
				</a>
			</span>
			<?php endif; ?>

			<?php if($this->params->get('catImage') && $this->category->image): ?>
			<!-- Category image -->
			<img alt="<?php echo K2HelperUtilities::cleanHtml($this->category->name); ?>" src="<?php echo $this->category->image; ?>" style="width:<?php echo $this->params->get('catImageWidth'); ?>px; height:auto;" />
			<?php endif; ?>

			<?php if($this->params->get('catTitle')): ?>
			<!-- Category title -->
			<h2><?php echo $this->category->name; ?><?php if($this->params->get('catTitleItemCounter')) echo ' ('.$this->pagination->total.')'; ?></h2>
			<?php endif; ?>

			<?php if($this->params->get('catDescription')): ?>
			<!-- Category description -->
			<p><?php echo $this->category->description; ?></p>
			<?php endif; ?>

			<!-- K2 Plugins: K2CategoryDisplay -->
			<?php echo $this->category->event->K2CategoryDisplay; ?>

			<div class="clr"></div>
		</div>
		<?php endif; ?>

		<?php if($this->params->get('subCategories') && isset($this->subCategories) && count($this->subCategories)): ?>
		<!-- Subcategories -->
		<div class="itemListSubCategories">
			<h3><?php echo JText::_('K2_CHILDREN_CATEGORIES'); ?></h3>

			<?php foreach($this->subCategories as $key=>$subCategory): ?>

			<?php
			// Define a CSS class for the last container on each row
			if( (($key+1)%($this->params->get('subCatColumns'))==0))
				$lastContainer= ' subCategoryContainerLast';
			else
				$lastContainer='';
			?>

			<div class="subCategoryContainer<?php echo $lastContainer; ?>"<?php echo (count($this->subCategories)==1) ? '' : ' style="width:'.number_format(100/$this->params->get('subCatColumns'), 1).'%;"'; ?>>
				<div class="subCategory">
					<?php if($this->params->get('subCatImage') && $subCategory->image): ?>
					<!-- Subcategory image -->
					<a class="subCategoryImage" href="<?php echo $subCategory->link; ?>">
						<img alt="<?php echo K2HelperUtilities::cleanHtml($subCategory->name); ?>" src="<?php echo $subCategory->image; ?>" />
					</a>
					<?php endif; ?>

					<?php if($this->params->get('subCatTitle')): ?>
					<!-- Subcategory title -->
					<h2>
						<a href="<?php echo $subCategory->link; ?>">
							<?php echo $subCategory->name; ?><?php if($this->params->get('subCatTitleItemCounter')) echo ' ('.$subCategory->numOfItems.')'; ?>
						</a>
					</h2>
					<?php endif; ?>

					<?php if($this->params->get('subCatDescription')): ?>
					<!-- Subcategory description -->
					<p><?php echo $subCategory->description; ?></p>
					<?php endif; ?>

					<!-- Subcategory more... -->
					<a class="subCategoryMore" href="<?php echo $subCategory->link; ?>">
						<?php echo JText::_('K2_VIEW_ITEMS'); ?>
					</a>

					<div class="clr"></div>
				</div>
			</div>
			<?php if(($key+1)%($this->params->get('subCatColumns'))==0): ?>
			<div class="clr"></div>
			<?php endif; ?>
			<?php endforeach; ?>

			<div class="clr"></div>
		</div>
		<?php endif; ?>

	</div>
	<?php endif; ?>



	<?php if((isset($this->leading) || isset($this->primary) || isset($this->secondary) || isset($this->links)) && (count($this->leading) || count($this->primary) || count($this->secondary) || count($this->links))): ?>
	<!-- Item list -->
	<div class="itemList k2ItemList">

		<?php if(isset($this->leading) && count($this->leading)): ?>
		<!-- Leading items -->
		<div id="itemListLeading">
			<?php foreach($this->leading as $key=>$item): ?>

			<?php
			// Define a CSS class for the last container on each row
			if( (($key+1)%($this->params->get('num_leading_columns'))==0) || count($this->leading)<$this->params->get('num_leading_columns') )
				$lastContainer= ' itemContainerLast';
			else
				$lastContainer='';
			?>
			
			<div class="itemContainer<?php echo $lastContainer; ?>"<?php echo (count($this->leading)==1) ? '' : ' style="width:'.number_format(100/$this->params->get('num_leading_columns'), 1).'%;"'; ?>>
				<?php
					// Load category_item.php by default
					$this->item=$item;
					echo $this->loadTemplate('item');
				?>
			</div>
			<?php if(($key+1)%($this->params->get('num_leading_columns'))==0): ?>
			
			<?php endif; ?>
			<?php endforeach; ?>
			<div class="clr"></div>
		</div>
		<?php endif; ?>

		<?php if(isset($this->primary) && count($this->primary)): ?>
		<!-- Primary items -->
		<div id="itemListPrimary">
			<?php foreach($this->primary as $key=>$item): ?>
			
			<?php
			// Define a CSS class for the last container on each row
			if( (($key+1)%($this->params->get('num_primary_columns'))==0) || count($this->primary)<$this->params->get('num_primary_columns') )
				$lastContainer= ' itemContainerLast';
			else
				$lastContainer='';
			?>
			
			<div class="itemContainer<?php echo $lastContainer; ?>"<?php echo (count($this->primary)==1) ? '' : ' style="width:'.number_format(100/$this->params->get('num_primary_columns'), 1).'%;"'; ?>>
				<?php
					// Load category_item.php by default
					$this->item=$item;
					echo $this->loadTemplate('item');
				?>
			</div>
			<?php if(($key+1)%($this->params->get('num_primary_columns'))==0): ?>
			<div class="clr"></div>
			<?php endif; ?>
			<?php endforeach; ?>
			<div class="clr"></div>
		</div>
		<?php endif; ?>

		<?php if(isset($this->secondary) && count($this->secondary)): ?>
		<!-- Secondary items -->
		<div id="itemListSecondary">
			<?php foreach($this->secondary as $key=>$item): ?>
			
			<?php
			// Define a CSS class for the last container on each row
			if( (($key+1)%($this->params->get('num_secondary_columns'))==0) || count($this->secondary)<$this->params->get('num_secondary_columns') )
				$lastContainer= ' itemContainerLast';
			else
				$lastContainer='';
			?>
			
			<div class="itemContainer<?php echo $lastContainer; ?>"<?php echo (count($this->secondary)==1) ? '' : ' style="width:'.number_format(100/$this->params->get('num_secondary_columns'), 1).'%;"'; ?>>
				<?php
					// Load category_item.php by default
					$this->item=$item;
					echo $this->loadTemplate('item');
				?>
			</div>
			<?php if(($key+1)%($this->params->get('num_secondary_columns'))==0): ?>
			<div class="clr"></div>
			<?php endif; ?>
			<?php endforeach; ?>
			<div class="clr"></div>
		</div>
		<?php endif; ?>

		<?php if(isset($this->links) && count($this->links)): ?>
		<!-- Link items -->
		<div id="itemListLinks">
			<h4><?php echo JText::_('K2_MORE'); ?></h4>
			<?php foreach($this->links as $key=>$item): ?>

			<?php
			// Define a CSS class for the last container on each row
			if( (($key+1)%($this->params->get('num_links_columns'))==0) || count($this->links)<$this->params->get('num_links_columns') )
				$lastContainer= ' itemContainerLast';
			else
				$lastContainer='';
			?>

			<div class="itemContainer<?php echo $lastContainer; ?>"<?php echo (count($this->links)==1) ? '' : ' style="width:'.number_format(100/$this->params->get('num_links_columns'), 1).'%;"'; ?>>
				<?php
					// Load category_item_links.php by default
					$this->item=$item;
					echo $this->loadTemplate('item_links');
				?>
			</div>
			<?php if(($key+1)%($this->params->get('num_links_columns'))==0): ?>
			<div class="clr"></div>
			<?php endif; ?>
			<?php endforeach; ?>
			<div class="clr"></div>
		</div>
		<?php endif; ?>

	</div>

	<!-- Pagination -->
	<?php if($this->pagination->getPagesLinks()): ?>
	<div class="pagination">
		<?php if($this->params->get('catPagination')) echo $this->pagination->getPagesLinks(); ?>
	</div>
	<?php endif; ?>


	<?php endif; ?>
</div>
<!-- End K2 Category Layout -->
