<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2017 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

JHtml::stylesheet('com_solidres/assets/main.min.css', false, true);

//require_once __DIR__.'/helper.php';
$lang = JFactory::getLanguage();
$app = JFactory::getApplication();
$context = 'com_solidres.reservation.process';
$checkin = $app->getUserState($context.'.checkin');
$checkout = $app->getUserState($context.'.checkout');
$roomsOccupancyOptions = $app->getUserState($context.'.room_opt', array());
JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/tables', 'SolidresTable');
$tableAsset = JTable::getInstance('ReservationAsset', 'SolidresTable');
$tableAsset->load(array('default' => 1, 'state' => 1));
if (empty($tableAsset->id) || $tableAsset->id <= 0)
{
	echo '<div class="alert alert-error">' . JText::_('SR_MOD_CHECKAVAILABILITY_NO_DEFAULT_ASSET_FOUND') . '</div>';
	return;
}

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
$enableRoomTypeDropdown = $params->get('enable_roomtype_dropdown', 0);

if ($enableRoomTypeDropdown)
{
	JModelLegacy::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/models', 'SolidresModel');
	$roomTypesModel = JModelLegacy::getInstance('RoomTypes', 'SolidresModel', array('ignore_request' => true));
	$roomTypesModel->setState('filter.reservation_asset_id', $tableAsset->id);
	$roomTypesModel->setState('list.select', 'r.id, r.name');
	$roomTypesModel->setState('filter.state', '1');
	$roomTypes = $roomTypesModel->getItems();
}

require JModuleHelper::getLayoutPath('mod_sr_checkavailability', $params->get('layout', 'default'));
