<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2017 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

use Joomla\Registry\Registry;

JLoader::import('solidres.plugin.plugin');

class SRPluginLegacy extends SRPlugin
{
	protected function getData($scopeId)
	{
		$name   = strtolower($this->_name);
		$config = new SRConfig(array('scope_id' => $scopeId, 'data_namespace' => 'plugins/' . $name));
		$data   = array();

		foreach ($config->getData() as $array)
		{
			list($key, $value) = $array;

			if(strpos($key, 'plugins/' . $name . '/') === 0)
			{
				$data[str_replace('plugins/' . $name . '/', '', $key)] = $value;
			}
		}

		return $data;
	}

	public function onReservationAssetPrepareForm(JForm $form, $data)
	{
		$name     = strtolower($this->_name);
		$load     = $form->loadFile(parent::getPluginPath($name) . '/' . $name . '.xml', true, '/extension/fields[@name="plugins"]');
		$registry = new Registry($data);

		if ($load && $registry->get('id'))
		{
			$form->bind(array('plugins' => $this->getData($registry->get('id'))));
		}

	}

	public function onReservationAssetAfterSave($data, JTable $table, $result, $isNew)
	{
		if (!$result || empty($data['plugins']))
		{
			return;
		}

		$name     = strtolower($this->_name);
		$saveData = array();

		foreach ($data['plugins'] as $k => $v)
		{
			if (is_array($v) || is_object($v))
			{
				$registry = new Registry($v);
				$v        = (string) $registry->toString();
			}

			if (strpos($k, $name) === 0)
			{
				$saveData[$k] = $v;
			}
		}

		if (is_callable(array($this, 'prepareSaveData')))
		{
			call_user_func_array(array($this, 'prepareSaveData'), array($table, &$saveData));
		}

		if (count($saveData))
		{
			$config = new SRConfig(array('scope_id' => $table->id, 'data_namespace' => 'plugins/' . $name));

			$config->set($saveData);
		}
	}
}