<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2017 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

JLoader::register('SRPayment', SRPATH_LIBRARY . '/payment/payment.php');
use Omnipay\Omnipay;

abstract class SRPaymentOmnipayAbstract extends SRPayment
{
	protected $autoloadLanguage = true;

	/** @var $db JDatabaseDriver */
	protected $db;

	/** @var $app JApplicationCms */
	protected $app;

	/** @var $dataConfig Array */
	protected $dataConfig;

	abstract protected function getForm();

	abstract protected function getGateWay();

	abstract protected function appendPaymentNew($gateway, $amount, $currencyCode, $reservationData);

	abstract protected function appendPaymentCallBack($paymentMethodId, $callbackData);

	public function __construct($subject, $config = array())
	{
		parent::__construct($subject, $config);

		$name              = str_ireplace('PlgSolidresPayment', '', get_class($this));
		$this->identifier  = is_callable(array($this, 'getIdentifier')) ? $this->getIdentifier() : strtolower($name);
		$this->title       = JText::_('PLG_SOLIDRESPAYMENT_' . strtoupper($name));
		$this->description = JText::_('PLG_SOLIDRESPAYMENT_' . strtoupper($name) . '_XML_DESCRIPTION');
	}

	public function onSolidresPaymentNew($reservationData)
	{
		if ($reservationData->payment_method_id != $this->identifier)
		{
			return false;
		}

		static $log;

		if ($log == null)
		{
			$options['format']    = '{DATE}\t{TIME}\t{LEVEL}\t{CODE}\t{MESSAGE}';
			$options['text_file'] = 'solidres_' . $this->identifier . '_request.php';
			$log                  = JLog::addLogger($options);
		}

		JLog::add('Start payment processing', JLog::DEBUG);

		JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_solidres/tables');
		$tableCountry = JTable::getInstance('Country', 'SolidresTable');
		$tableCountry->load($reservationData->customer_country_id);

		$this->dataConfig = $this->loadFormData((int) $reservationData->reservation_asset_id);

		$amountToBePaid = $this->getPayAmount($reservationData);

		JLoader::import($this->_name . '.vendor.autoload', JPATH_PLUGINS . '/' . $this->_type);
		$gateway         = Omnipay::create($this->getGateWay());
		$this->returnUrl = $this->getReturnUrl($reservationData->id);

		return $this->appendPaymentNew($gateway, $amountToBePaid, $reservationData->currency_code, $reservationData);
	}

	public function OnSolidresPaymentCallback($paymentMethodId, $callbackData)
	{
		if ($paymentMethodId != $this->identifier || empty($callbackData))
		{
			return false;
		}

		static $log;

		if ($log == null)
		{
			$options['format']    = '{DATE}\t{TIME}\t{LEVEL}\t{CODE}\t{MESSAGE}';
			$options['text_file'] = 'solidres_' . $this->identifier . '_response.php';
			$log                  = JLog::addLogger($options);
		}

		return $this->appendPaymentCallBack($paymentMethodId, $callbackData);
	}

	public function onSolidresPaymentRefundDisplay(JForm $reservation)
	{
		return;
	}

	public function onSolidresPaymentRefundCallback()
	{
		return;
	}
}
