<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2014 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

require_once SRPATH_HELPERS . '/helper.php';

/**
 * Form Field class for the Joomla Framework.
 *
 * @package		Joomla.Framework
 * @subpackage	Form
 * @since		1.6
 */
class JFormFieldCheckboxTheme extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	public $type = 'CheckboxTheme';

	/**
	 * Method to get the field input markup.
	 *
	 * @return	string	The field input markup.
	 * @since	1.6
	 */
	protected function getInput()
	{
		$listSelectedThemes = $this->form->getValue('theme_id');
		$html = '';

		$model = JModelLegacy::getInstance('Themes', 'SolidresModel', array('ignore_request' => true));
		$model->setState('filter.state', 1);
		$list = $model->getItems();

		if (!empty($list))
		{
			foreach ($list as $obj)
			{
				$html .= '
				<p class="themes-wrapper-line"><label class="checkbox">
					<input type="checkbox"
						  value="'.$obj->id.'"
						  id="checkbox_theme_id_'.$obj->id.'"
						  class="checkbox_theme_class"
						  name="jform[theme_id][]" '.(in_array($obj->id, (array) $listSelectedThemes) ? 'checked="checked"' : '').'/>
					'.$obj->title.'
				</label></p>
			';
			}
		}
		else
		{
			$html = JText::_('SR_THEME_NOT_AVAILABLE');
		}

		return $html;
	}
}


