<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2015 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

/**
 * Reservation controller class.
 *
 * @package     Solidres
 * @subpackage	Reservation
 * @since		0.4.0
 */
class SolidresControllerReservation extends JControllerForm
{
	/**
	 * Method override to check if you can add a new record.
	 *
	 * @param	array $data An array of input data.
	 * @return	boolean
	 * @since	1.6
	 */
	protected function allowAdd($data = array())
	{
		$allow	= null;

		if ($allow === null)
		{
			// In the absense of better information, revert to the component permissions.
			return parent::allowAdd($data);
		} else {
			return $allow;
		}
	}

	/**
	 * Method to check if you can add a new record.
	 *
	 * @param	array $data An array of input data.
	 * @param	string $key The name of the key for the primary key.
	 * @return	boolean
	 * @since	1.6
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		return parent::allowEdit($data, $key);
	}

	/**
	 * General save method for inline editing feature
	 *
	 * @param null $key
	 * @param null $urlVar
	 *
	 * @return bool|void
	 */
	public function save($key = NULL, $urlVar = NULL)
	{
		$app = JFactory::getApplication();
		$input = $app->input;
		$filterMask = 'int';
		$pk = $input->get('pk', 0);
		$name = $input->get('name', 0, 'string');
		$canContinue = true;
		if (in_array($name, array('total_paid')))
		{
			$filterMask = 'double';
		}
		$value = $input->get('value', 0, $filterMask);

		JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_solidres/tables');
		$table = JTable::getInstance('Reservation', 'SolidresTable');
		$currencyFields = array(
			'total_price', 'total_price_tax_incl', 'total_price_tax_excl', 'total_extra_price', 'total_extra_price_tax_incl',
			'total_extra_price_tax_excl', 'total_discount', 'total_paid', 'deposit_amount'
		);

		$table->load($pk);

		// Hook in reservation status changing event
		if ($name == 'payment_status')
		{
			JPluginHelper::importPlugin('solidrespayment');

			$responses = $app->triggerEvent('OnReservationPaymentStatusBeforeChange', array( $table, $value ));

			if (in_array(false, $responses, true))
			{
				$canContinue = false;
			}
		}

		if ($canContinue)
		{
			$table->$name = $value;

			// When payment status is chagned to cancelled, update the reservation status to cancelled as well
			if ($name == 'payment_status' && $value == 2)
			{
				$table->state = 4;
			}

			$result = $table->store();
			$newValue = $table->$name;
		}

		if (in_array($name, $currencyFields))
		{
			JLoader::register('SRCurrency', SRPATH_LIBRARY . '/currency/currency.php');
			$baseCurrency = new SRCurrency($value, $table->currency_id);
			$newValue = $baseCurrency->format();
		}

		// Generate invoice when reservation status is changed to confirmed
		if($name == 'state' && $value == 1)
		{
			$dispatcher = JDispatcher::getInstance();
			JPluginHelper::importPlugin('solidres');
			$invoice = $dispatcher->trigger('onSolidresGenerateInvoice', array($pk));
		}

		echo json_encode(array('success' => $result, 'newValue' => $newValue));
	}

	public function loadAvailableRooms()
	{
		$checkIn = $this->input->get('checkin');
		$checkOut = $this->input->get('checkout');
		$roomTypeId = $this->input->get('room_type_id');

		$solidresRoomType = SRFactory::get('solidres.roomtype.roomtype');

		$results = array();

		$availableRooms = $solidresRoomType->getListAvailableRoom($roomTypeId, $checkIn, $checkOut);

		foreach ($availableRooms as $k => $room)
		{
			$results[$k]['value'] = $room->id;
			$results[$k]['text'] = $room->label;
		}

		echo json_encode($results);
	}

	public function updateRoom()
	{
		$app = JFactory::getApplication();
		$input = $app->input;
		$pk = $input->get('pk', 0);
		$name = $input->get('name', 0, 'string');

		$value = $input->get('value', 0, 'int');

		$dbo = JFactory::getDbo();
		$query = $dbo->getQuery(true);
		JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_solidres/tables');
		$tableRoom = JTable::getInstance('Room', 'SolidresTable');
		$tableRoom->load($value);

		$query->update($dbo->quoteName('#__sr_reservation_room_xref'))
			->set('room_id = ' . $value)
			->set('room_label = ' . $dbo->quote($tableRoom->label))
			->where('id = ' . $pk);

		$result = $dbo->setQuery($query)->execute();

		echo json_encode(array('success' => $result, 'newValue' => $value, 'newText' => $tableRoom->label));
	}
}
