<?php

/*------------------------------------------------------------------------
 # com_k2store - K2Store
# ------------------------------------------------------------------------
# author    priyabose - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2012 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://k2store.org
# Technical Support:  Forum - http://k2store.org/forum/index.html
-------------------------------------------------------------------------*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class K2StoreViewCustomer extends K2StoreView
{
	protected $item;

	// Overwriting JView display method
	function display($tpl = null)
	{
		//initialize  for getting Customer Model
		$customer_model =$this->getModel('customer');
		$this->params = JComponentHelper::getParams('com_k2store');

		// object for Customer getData Method
		$this->data=$customer_model->getData();

		$this->orders= array();

		// Object for Customer getOrder Method
		if(count($this->data)) {
			$this->orders=$customer_model->getOrders($this->data[0]->email, $this->data[0]->user_id);
		}

		$this->addToolBar();
		$toolbar = new K2StoreToolBar();
		$toolbar->renderLinkbar();
		parent::display($tpl);

	}

	function addToolBar()
	{
		JToolBarHelper::title(JText::_('K2STORE_CUSTOMERS'),'k2store-logo');
		JToolBarHelper::back();
	}

}