<?php
/*------------------------------------------------------------------------
 # com_k2store - K2Store
# ------------------------------------------------------------------------
# author    Ramesh Elamathi - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2014 - 19 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://k2store.org
# Technical Support:  Forum - http://k2store.org/forum/index.html
-------------------------------------------------------------------------*/

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

require_once(JPATH_SITE.'/components/com_k2store/models/_base.php');
class K2StoreModelProductQuantities extends K2StoreModelBase
{
    public $cache_enabled = false;

    protected function _buildQueryWhere($query)
    {
        $filter_id	= $this->getState('filter_id');
       	$filter_product	    = $this->getState('filter_productid');
        $filter_attributes  = $this->getState('filter_attributes');
        $filter_quantity_from   = $this->getState('filter_quantity_from');
        $filter_quantity_to = $this->getState('filter_quantity_to');

		if (strlen($filter_id))
        {
            $query->where('tbl.productquantity_id = '.(int) $filter_id);
       	}
    	if (strlen($filter_product))
        {
            $query->where('tbl.product_id = '.(int) $filter_product);
       	}

        if (strlen($filter_quantity_from))
        {
            $query->where('tbl.quantity >= '.(int) $filter_quantity_from);
        }
        if (strlen($filter_quantity_to))
        {
            $query->where('tbl.quantity <= '.(int) $filter_quantity_to);
        }
        if (strlen($filter_attributes))
        {
        	$query->where(" tbl.product_attributes = '$filter_attributes' ");
       	}
    }

	public function getList($emptyState = true)
	{
		JTable::addIncludePath( JPATH_ADMINISTRATOR.'/components/com_k2store/tables');

		$list = parent::getList($emptyState);

		// If no item in the list, return an array()
        if( empty( $list ) ){
        	return array();
        }

		foreach($list as $item)
		{
		    if ($product_attributes = explode( ',', $item->product_attributes ))
	        {
	        	$product_attribute_names = array();
	            foreach ($product_attributes as $pao_id)
	            {
	            	$pao = JTable::getInstance( 'ProductOptionValues', 'Table' );
	            	$pao->load( $pao_id );
	            	$ov = JTable::getInstance( 'OptionValues', 'Table' );
	            	$ov->load( $pao->optionvalue_id);
	            	$product_attribute_names[] = JText::_( $ov->optionvalue_name);
	            }
	            $item->product_attribute_names = implode(', ', $product_attribute_names);
	        }

		}
		return $list;
	}

	function getQuantityTotal() {

		$filter_product = $this->getState('filter_product');
		$filter_product_attribute = $this->getState('filter_product_attribute');

		$db = JFactory::getDbo();
		$query = $db->getQuery(true)->select('SUM(quantity) AS product_quantity_total')->from('#__k2store_productquantities');

		if($filter_product) {
			$query->where('product_id='.$db->q($filter_product));
		}

		if($filter_product_attribute) {
			$query->where('product_attribute='.$db->q($filter_product_attribute));
		}

		return $db->setQuery($query)->loadResult();

	}
}
