<?php
/*------------------------------------------------------------------------
 # com_k2store - K2Store
# ------------------------------------------------------------------------
# author    Priya bose - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2012 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://k2store.org
# Technical Support:  Forum - http://k2store.org/forum/index.html
-------------------------------------------------------------------------*/

/** Check to ensure this file is included in Joomla! */
defined('_JEXEC') or die( 'Restricted access' );

jimport('joomla.application.component.model');

/**
 *
 * @package		Joomla
 * @subpackage	K2Store
 * @since 2.5
*/
class K2StoreModelCustomer extends K2StoreModel
{
	/**
	  * @var array
	 */

	var $_data = null;

	/**
	 *
	 * @var email
	 */
	var $_email = null;
	var $_user_id = null;

	/**
	 * Constructor
	 *
	 * @since 2.5
	 */
	function __construct()
		{
			parent::__construct();
			$app=JFactory::getApplication();

			// assining the email get from the User Request
			$this->_email=$app->input->getString('email','');
			$this->_user_id=$app->input->getInt('user_id','');

			$option = 'com_k2store';
			//$ns = $option.'.addresses';
			$ns = $option.'.customer';
		}

		/**
		 * Method to get a table object, load it if necessary.
		 * @params tablename
		 * @params classprefix
		 * @array  config
		 * @return tableObject
		 */
		public function getTable($type = 'address', $prefix = 'Table', $config = array())
			{
			return JTable::getInstance($type, $prefix, $config);
			}

		/**
		 * Method  for Getting Data
		 * @access public
		 * @return array after executing the queries
		 */
		function getData()
		{
			// Lets load the content if it doesn't already exist
			if (empty($this->_data))
			{
				$query = $this->_buildQuery();
				$this->_data = $this->_getList($query);
			}

			return $this->_data;
		}


		/**
		 *  Method for building Query object
		 *  @retun Query object joomla's default query Object
		 */
		function _buildQuery()
		{
		/** Get a DB Object */
		$db = JFactory::getDbo();

		/** get the current query Object **/
		$query = $db->getQuery(true);

		/** Add a single column, or array of columns to the SELECT clause of the query */
		$query->select('a.*')->from('#__k2store_address AS a');

		/**  Add a LEFT JOIN clause to the query */
		$query->leftJoin('#__k2store_countries AS c ON c.country_id = a.country_id');

		$query->select('c.country_name');
		$query->leftJoin('#__k2store_zones AS z ON z.zone_id=a.zone_id');
		$query->select('z.zone_name');
		$query = $this->_buildWhere($query);
		return $query;
		}


		/**
		 * Method for Where query object
		 * @param query Object joomla's default query object
		 * @return query object returns query after setting where condition
		 *
		 */
		 function _buildWhere($query)
		{

			if(isset($this->_user_id)) {
				$query->where('a.user_id='.$this->_db->quote($this->_user_id));
			} else {
				$query->where('a.user_id=0');
			}
			$query->where('a.email='.$this->_db->quote($this->_db->escape($this->_email)));

			return $query;
		}

		/**
		 * Method to get Order details
		 * @param email string user email
		 * @return rows object list of order records
		 */

		function getOrders($email, $user_id=0)
		{

			if(empty($email) && ($user_id < 1 || $user_id = '') ) {
				return array();
			}

			$db=JFactory::getDbo();
			$query=$db->getQuery(true);
			$query->select('o.*')->from('#__k2store_orders as o');

			if(isset($email) && JString::strlen($email) > 0) {
				$query->where('o.user_email='.$db->quote($db->escape($email)));
			}

			if(isset($user_id) && $user_id > 0) {
				$query->where('o.user_id='.$this->_db->quote($user_id));
			} else {
				$query->where('o.user_id=0');
			}
			$db->setQuery($query);
			$rows=$db->loadObjectList();
			return $rows;
		}



}