<?php
/*
 * --------------------------------------------------------------------------------
 * Group pricing for K2Store
 * --------------------------------------------------------------------------------
 * @package		Joomla! 2.5+
 * @subpackage	K2Store
 * @author 		Weblogicx India http://www.weblogicxindia.com
 * @copyright	Copyright (c) 2010 - 2015 Weblogicx India Ltd. All rights reserved.
 * @license		GNU/GPL license: http://www.gnu.org/copyleft/gpl.html
 * --------------------------------------------------------------------------------
 */

/**
 * ensure this file is being included by a parent file
 */
defined ( '_JEXEC' ) or die ( 'Restricted access' );

require_once (JPATH_ADMINISTRATOR . '/components/com_k2store/library/plugins/_base.php');
require_once (JPATH_ADMINISTRATOR . '/components/com_k2store/library/prices.php');
JLoader::register('K2Parameter', JPATH_ADMINISTRATOR.'/components/com_k2/lib/k2parameter.php');
if(version_compare(JVERSION, '3.0', 'lt')) {
	require_once(JPATH_LIBRARIES.'/joomla/html/html/user.php');
}
class plgK2StoreProduct_Grouppricing extends K2StorePluginBase {

	var $_element = 'product_grouppricing';

	function __construct(& $subject, $config) {
		parent::__construct ( $subject, $config );
		$this->loadLanguage ( 'com_k2store', JPATH_ADMINISTRATOR );
	}

	/**
	 * Event returns an input field for the product form
	 * @param int $product_id
	 * @object Formfield Class $form
	 */

	function onK2StoreProductFormLabel($product_id, $form) {
		// Add the opening label tag and main attributes attributes.
		return '<label id="grouppricing" class="grouppricing">'.JText::_('K2STORE_GROUPPRICE_LABEL'). '</label>';
	}

	/**
	 * Event returns an input field for the product form
	 * @param int $product_id
	 * @object Formfield Class $form
	 */

	function onK2StoreProductFormInput($product_id, $form) {
		$app = JFactory::getApplication();
		$html ="";
		if($product_id > 0) {

			$vars = new JObject();

			$vars->product_id = $product_id;
			$vars->plugin_id = $this->getPluginId();

			$doc = JFactory::getDocument();

			$form_prefix = "plugins[k2storeitem_gp][group_price]";

			$vars->userGroup = JHtmlUser::groups();
			$vars->userOption = $this->getUserOptions();
			$vars->group_prices = $this->getGroupPrices($product_id);

			return $this->_getLayout('default', $vars);
		}
	}

	/*
	 * Method to save K2Store product form plugins
	 */

	public function onK2StoreProductFormAfterSave($row) {

		//only save if the K2 Item has an id

		if($row->id > 0) {
			$plugins = new K2Parameter($row->plugins, '', 'k2store');
			$group_prices = $plugins->get('group_price');
			JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_k2store/tables');
			//get the table
			$table = JTable::getInstance('Groupprice', 'Table');
			foreach($group_prices as $gp){
				$gp->product_id = $row->id;
				try{
					$table->save($gp);
				}catch(Exception $e){
					return;
				}
			}
		}
		return true;

	}

	/**
	 * Method to override the price object
	 * @param object $product product object
	 * @param int $quantity cart or product quantity
	 * @param object $item price object referenced.
	 */

	public function onK2StoreAfterPrice($product, $quantity, &$item) {

		$group_price=$this->getGroupPrice($product->product_id);
		if(isset($group_price) && ($group_price)){
			$item->product_customer_groupprice = $group_price;
			//we have a group price for this product. So set the special price to null.
			$item->product_specialprice = null;
			// this will be the product price as well as the base price
			$item->product_baseprice = $item->product_price =(float) $group_price;
		}

		//if there are price ranges then we have to override the product price
		$price_range = K2StorePrices::getPriceRange($product->product_id,$quantity);
		if( $price_range > 0.000){
			$item->product_price = $price_range;
		}

	}

	public function getUserOptions(){
		$userGroup = JHtmlUser::groups();
		$html = array();
		foreach($userGroup as $cgroup){
			$html[] = "<option value='{$cgroup->value}'>{$cgroup->text}</option>";
		}
		return json_encode($html);
	}

	public function getGroupPrices($product_id){
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select("gp.*")->from("#__k2store_groupprices as gp");
		$query->where("gp.product_id=".$product_id);
		$db->setQuery($query);
		return $db->loadObjectList();
	}

	private function getPluginId() {
		$db = JFactory::getDbo();
		$query = $db->getQuery(true)->select('extension_id')->from('#__extensions')->where('element='.$db->q($this->_element));
		return $db->setQuery($query)->loadResult();
	}

	public static function getGroupPrice($product_id){
		$db = JFactory::getDbo();
		$user = JFactory::getUser();
		$groups = implode(',',$user->getAuthorisedGroups());
		$query = $db->getQuery(true)->select("gp.customer_group_price")->from("#__k2store_groupprices as gp")
		->where("gp.product_id=".$product_id)
		->where("gp.customer_group_id IN ({$groups})");
		//echo $query;
		$db->setQuery($query);
		$result = $db->loadResult();
		return $result;
	}


}