<?php
/*------------------------------------------------------------------------
  Solidres - Hotel booking extension for Joomla
  ------------------------------------------------------------------------
  @Author    Solidres Team
  @Website   http://www.solidres.com
  @Copyright Copyright (C) 2013 - 2014 Solidres. All Rights Reserved.
  @License   GNU General Public License version 3, or later
------------------------------------------------------------------------*/

defined('_JEXEC') or die;

/**
 * View to edit a tariff.
 *
 * @package     Solidres
 * @subpackage	Tariff
 * @since		0.5.0
 */
class SolidresViewTariff extends JViewLegacy
{
	public function display($tpl = null)
	{
		if (count($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->roomTypeId = JFactory::getApplication()->input->get('id', 0, 'int');
		$this->currencyId = JFactory::getApplication()->input->get('currency_id', 0, 'int');
		$this->childMaxAgeLimit = JComponentHelper::getParams('com_solidres')->get('child_max_age_limit', 17);

		JHtml::stylesheet('com_solidres/assets/main.min.css', false, true);
		JHtml::stylesheet('com_solidres/assets/main.min.css', false, true);
		JFactory::getDocument()->addScriptDeclaration('
			Solidres.document_base_url = "'.JUri::root().'";
		');

		if (SR_PLUGIN_COMPLEXTARIFF_ENABLED)
		{
			SRHtml::_('js.complextariff');
		}

		parent::display($tpl);
	}
}
