<?php
/*------------------------------------------------------------------------
# com_k2store - K2Store
# ------------------------------------------------------------------------
# author    Ramesh Elamathi - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2014 - 19 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://k2store.org
# Technical Support:  Forum - http://k2store.org/forum/index.html
-------------------------------------------------------------------------*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

?>

<form	action="<?php echo JRoute::_('index.php?option=com_k2store&view=myprofile')?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
<div class="k2store_account">

	<div class="row-fluid">
		<div class="span6">
			<h3 class="badge badge-success">
				<?php echo JText::_('K2STORE_BILLING_ADDRESS'); ?>
			</h3>
		<!--  For Each Loop first part Starts for customer -->
		<?php foreach($this->customers as $customer):?>
			<?php
			$addressTable = JTable::getInstance('Address', 'Table');
			$addressTable->load($customer->id);
			$fields =  $this->fieldClass->getFields($addressTable->type,$addressTable,'address');

			/**  if Condition to check the Type of Cutomer */
			if($customer->type=='billing'): ?>
			<div class="well">
			<address>
			<!-- Customer's  Billing Address Details  -->
			<?php foreach ($fields as $fieldName => $oneExtraField):?>
			<?php if(property_exists($addressTable, $fieldName)):?>
					<strong><?php echo $oneExtraField->field_name; ?></strong> :
					<?php if($fieldName == 'country_id'): ?>
						<?php echo $customer->country_name; ?> <br />
					<?php elseif($fieldName == 'zone_id'): ?>
						<?php echo $customer->zone_name; ?> <br />
					<?php else: ?>
						<?php echo $addressTable->$fieldName;?> <br />
					<?php endif;?>
				<?php endif;?>
				<?php endforeach;?>
				</address>
						<input type="submit" address_type="<?php echo $customer->type;?>" class="btn btn-inverse btn-small" id="<?php echo $customer->id;?>" onclick="K2StoreSubmitMyProfile('billing',<?php echo $customer->id ;?>,'edit')" value="<?php echo JText::_('K2STORE_EDIT');?>"/>
						<input type="submit" address_type="<?php echo $customer->type;?>"  class="btn btn-danger btn-small" id="<?php echo $customer->id;?>" onclick="K2StoreSubmitMyProfile('billing',<?php echo $customer->id ;?>,'delete')" value="<?php echo JText::_('K2STORE_DELETE');?>"/>
					</div>

		<!-- If Condition Ends Here  -->
		<?php endif; ?>

		<!-- first part of  Foreach Loop Ends here   -->
		<?php endforeach; ?>

		</div>
		<div class="span6">
			<h3 class="badge badge-info"><?php echo JText::_('K2STORE_SHIPPING_ADDRESS');?></h3>
			<!--  For Each Loop Strats for Second part Customer details -->
			<?php  foreach($this->customers as $customer):?>

				<?php
			$addressTable = JTable::getInstance('Address', 'Table');
			$addressTable->load($customer->id);
			$fields =  $this->fieldClass->getFields($addressTable->type,$addressTable,'address');

			/**  if Condition to check the Type of Cutomer */
			if($customer->type=='shipping'): ?>
			<div class="well">
			<address>
			<!-- Customer's  Billing Address Details  -->
			<?php foreach ($fields as $fieldName => $oneExtraField):?>
			<?php if(property_exists($addressTable, $fieldName)):?>
					<strong><?php echo $oneExtraField->field_name; ?></strong> :
					<?php if($fieldName == 'country_id'): ?>
						<?php echo $customer->country_name; ?> <br />
					<?php elseif($fieldName == 'zone_id'): ?>
						<?php echo $customer->zone_name; ?> <br />
					<?php else: ?>
						<?php echo $addressTable->$fieldName;?> <br />
					<?php endif;?>
				<?php endif;?>
				<?php endforeach;?>
				</address>
						<!--  Delete Options  for Shipping Address -->
						<input type="submit" address_type="<?php echo $customer->type;?>" class="btn btn-inverse btn-small" id="<?php echo $customer->id?>" onclick="K2StoreSubmitMyProfile('shipping',<?php echo $customer->id ;?>,'edit')" value="<?php echo JText::_('K2STORE_EDIT');?>"/>
						<input type="submit" address_type="<?php echo $customer->type;?>" class="btn btn-danger btn-small" id="<?php echo $customer->id?>" onclick="K2StoreSubmitMyProfile('shipping',<?php echo $customer->id ;?>,'delete')" value="<?php echo JText::_('K2STORE_DELETE');?>"/>
				</div>
				<!--  End of if False  Statement -->
				<?php endif; ?>

			<!--  Second Part of Foreach Loop Ends here -->
			<?php endforeach; ?>

		</div><!--  Div Span Ends here -->

	</div> <!-- div row fluid ends here -->



	<div class="k2store_myprofile_orders">
	<h3>
			<?php echo JText::_('K2STORE_ORDER_HISTORY'); ?>
		</h3>
		<table class="adminlist table table-striped table-bordered table-hover">
			<thead>
				<tr>

					<th><?php echo JText::_('K2STORE_ORDER_DATE');?></th>
					<th><?php echo JText::_('K2STORE_ORDER_INVOICE_ID');?></th>
					<th><?php echo JText::_('K2STORE_ORDER_AMOUNT');?></th>
					<th><?php echo JText::_('K2STORE_ORDER_ORDER_STATUS');?></th>
				</tr>
			</thead>
				<tfoot>
					<tr>
						<td colspan="5" class="jorder_row">
							<div class="pagination pagination-toolbar">
							<?php echo @$this->pagination->getPagesLinks(); ?>
								<div class="pull-right">
								<?php echo @$this->pagination->getResultsCounter(); ?>
								</div>
							</div>
						</td>
					</tr>
				</tfoot>
			<tbody>
				<?php $i=0; ?>
				<?php foreach ($this->orders as  $item): ?>
				<?php $i++;?>
				<tr>
					<td><?php echo JHTML::_('date', $item->created_date, $this->params->get('date_format', JText::_('DATE_FORMAT_LC1'))); ?></td>
					<td>
					<!-- Link for Referering the Order Details and Items -->
					<a href="<?php echo JRoute::_('index.php?option=com_k2store&view=orders&task=view&id='.$item->invoice);?>"><?php echo $item->invoice;?></a>
				</td>
				<td>
					<?php echo K2StorePrices::number($item->orderpayment_amount, $item->currency_code, $item->currency_value);?></td>
				<td>
					<label class="label <?php echo $item->orderstatus_cssclass; ?>">
						<?php echo JText::_($item->orderstatus_name);?>
						</label>
				</tr>
				<?php endforeach;?>
			</tbody>
		</table>
	</div>
	<input type="hidden" name="id" value="<?php echo JFactory::getUser()->id; ?>" />
	<input type="hidden" name="task" id="task" value=""/>
	<input type="hidden" name="address_type" id="address_type" />
	<input type="hidden" name="address_id" id="address_id" />
</form>
</div>

<script type="text/javascript">
	function K2StoreSubmitMyProfile(type,id,task)
	{
		jQuery("#address_type").val(type);
		jQuery("#address_id").val(id);
		jQuery("#task").val(task);
		//submitbutton(task);
	}
</script>
