<?php
/*------------------------------------------------------------------------
 # com_k2store - K2Store
# ------------------------------------------------------------------------
# author    Ramesh Elamathi - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2014 - 19 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://k2store.org
# Technical Support:  Forum - http://k2store.org/forum/index.html
-------------------------------------------------------------------------*/
// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controller');
JLoader::register( 'K2StoreHelperCart', JPATH_SITE.'/components/com_k2store/helpers/cart.php');
JTable::addIncludePath( JPATH_ADMINISTRATOR.'/components/com_k2store/tables' );
require_once (JPATH_ADMINISTRATOR.'/components/com_k2store/library/base.php');
require_once (JPATH_ADMINISTRATOR.'/components/com_k2store/library/tax.php');
require_once (JPATH_ADMINISTRATOR.'/components/com_k2store/library/inventory.php');
class K2StoreControllerMyprofile extends K2StoreController
{

	function display($cachable = false, $urlparams = array()) {

		$app = JFactory::getApplication();
		$values =  $app->input->getArray($_POST);
		$view = $this->getView( 'myprofile', 'html' );
		$params = JComponentHelper::getParams('com_k2store');
		$user 		=	JFactory::getUser();
		if($user->id < 1) {
			$url = JRoute::_('index.php?option=com_users&view=login');
			$app->redirect($url);
		}
		$task = $app->input->getCmd('task');
		$model		= $this->getModel('myprofile');
		// object for Customer getData Method
		$customers = $model->getAddress();
		$selectableBase = K2StoreFactory::getSelectableBase();
		$view->assign('fieldClass', $selectableBase);

		$ordersModel = $this->getModel('orders');
		$ns = 'com_k2store.orders.myprofile';

		$state = $this->_setModelState();
		$limit		= $app->getUserStateFromRequest( 'global.list.limit', 'limit', $app->getCfg('list_limit'), 'int' );
		$limitstart	= $app->getUserStateFromRequest( $ns.'.limitstart', 'limitstart', 0, 'int' );
		//$limitstart	= (empty($_GET['limitstart'])) ? 0 : $app->getUserStateFromRequest($ns.'.limitstart', 'limitstart', 0, 'int');

		// In case limit has been changed, adjust limitstart accordingly
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$state['limit']  	= $limit;
		$state['limitstart'] = $limitstart;
		$state['order']     = $app->getUserStateFromRequest($ns.'.filter_order', 'filter_order', 'tbl.'.$ordersModel->getTable()->getKeyName(), 'cmd');
		$state['direction'] = $app->getUserStateFromRequest($ns.'.filter_direction', 'filter_direction', 'ASC', 'word');

		foreach (@$state as $key=>$value)
		{
			$ordersModel ->setState( $key, $value );
		}

		if(JFactory::getApplication()->isSite() && $params->get('show_incomplete_orders', 0) == 0) {
			$ordersModel ->setState('restrict_filter_orderstate', 5);
		}

		$ordersModel ->setState('filter_userid', $user->id);
		$orders = $ordersModel ->getList();
		$pagination = $ordersModel ->getPagination();
		$total = $ordersModel ->getTotal();

		$view->assign('params', $params);
		$view->assign('orders',$orders);
		$view->assign('pagination',$pagination);
		$view->assign('total',$total);
		$view->assign('customers',$customers);
		$view->setLayout('default');
		$view->display();

		return;
	}

	function delete()
	{
		// Initialise the App variables
		$app=JFactory::getApplication();

		// Assign the get Id to the Variable

		$id=$app->input->getInt('address_id');

		$type = $app->input->getString('address_type');

		// Set the Path for Tables
		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.'/tables');

		if($id)
		{	// store the table in the variable
			$address = JTable::getInstance('address', 'Table');
			$address->load($id);
			$email = $address->email;
			$user_id = $address->user_id;
			try {
				$address->delete();
				$msg = JText::_('K2STORE_'.strtoupper($type).'_ADDRESS_DELETED_SUCCESSFULLY');
			} catch (Exception $error) {
				$msg = $error->getMessage();
			}
		}
		$link = JRoute::_('index.php?option=com_k2store&view=myprofile');
		$app->redirect($link, $msg,'success');
	}

	function edit(){

		$app = JFactory::getApplication();
		$customer_id = $app->input->get('id');

		$address_type = $app->input->get('address_type');

		$address_id = $app->input->get('address_id');

		JTable::addIncludePath(JPATH_COMPONENT_ADMINISTRATOR.'/tables');
		$view = $this->getView( 'myprofile', 'html' );
		$model = $this->getModel('myprofile');

		if($address_id){

			$address_table = JTable::getInstance('address', 'Table');

			$address_table->load($address_id);

			$view->assign('address', $address_table);

			$view->assign('address_id',$address_id);

			$view->assign('address_type',$address_type);


			$address = JTable::getInstance('address', 'Table');

			$selectableBase = K2StoreFactory::getSelectableBase();

			$fields = $selectableBase->getFields($address_type,$address,'address');

			$address->load($address_id);

			$addresses =$address->bind($fields);

			$view->assign('fieldsClass', $selectableBase);


			$view->assign('addresses', $addresses);

			$view->assign('fields', $fields);

			$view->assign('storeProfile', K2StoreHelperCart::getStoreAddress());

			$view->setLayout('edit_'.$address_type);

			$view->display();
		}

	}

	function save(){


		$app = JFactory::getApplication();

		$user = JFactory::getUser();

		$values = $app->input->getArray($_POST);

		$values['id'] = $values['address_id'];
		$model = $this->getModel('myprofile');
		$data = $model->saveAddress($values);
		$url = JRoute::_('index.php?option=com_k2store&view=myprofile&layout=default');
		if($data){
			$msg = JText::_('K2STORE_'.strtoupper($data['type']).'_ADDRESS_SAVED_SUCCESSFULLY');
			$app->redirect($url,$msg);
		}else{
			$app->redirect($url);
		}
 	}

 	function cancel(){
 		$app = JFactory::getApplication();
		$address_type = strtoupper($app->input->get('type'));
 		$url = JRoute::_('index.php?option=com_k2store&view=myprofile&layout=default');
 		$app->redirect($url);

 	}

 	function _setModelState()
 	{
 		$app = JFactory::getApplication();
 		$params = JComponentHelper::getParams('com_k2store');
 		$model = $this->getModel('orders');
 		$ns = 'com_k2store.orders.myprofile';

 		$state = array();
 		$state['limit']  	= $app->getUserStateFromRequest('global.list.limit', 'limit', $app->getCfg('list_limit'), 'int');
 		$state['limitstart'] = (empty($_GET['limitstart'])) ? 0 : $app->getUserStateFromRequest($ns.'.limitstart', 'limitstart', 0, 'int');
 		$state['order']     = $app->getUserStateFromRequest($ns.'.filter_order', 'filter_order', 'tbl.'.$model->getTable()->getKeyName(), 'cmd');
 		$state['direction'] = $app->getUserStateFromRequest($ns.'.filter_direction', 'filter_direction', 'ASC', 'word');
 		$state['filter']    = $app->getUserStateFromRequest($ns.'.filter', 'filter', '', 'string');
 		$state['filter_enabled'] 	= $app->getUserStateFromRequest($ns.'enabled', 'filter_enabled', '', '');
 		$state['id']        = JRequest::getVar('id', JRequest::getVar('id', '', 'get', 'int'), 'post', 'int');


 		// adjust offset for when filter has changed
 		if (
 		$app->getUserState( $ns.'orderstate' ) != $app->getUserStateFromRequest($ns.'orderstate', 'filter_orderstate', '', '')
 		)
 		{
 			$state['limitstart'] = '0';
 		}

 		$state['order']     = $app->getUserStateFromRequest($ns.'.filter_order', 'filter_order', 'tbl.created_date', 'cmd');
 		$state['direction'] = $app->getUserStateFromRequest($ns.'.filter_direction', 'filter_direction', 'DESC', 'word');

 		$state['filter_orderstate'] = $app->getUserStateFromRequest($ns.'orderstate', 'filter_orderstate', '', 'string');

 		$state['filter_userid']     = JFactory::getUser()->id;
 		$filter_userid = $app->getUserStateFromRequest($ns.'userid', 'filter_userid', JFactory::getUser()->id, 'int');

 		$state['filter_total']      = $app->getUserStateFromRequest($ns.'total', 'filter_total', '', 'float');

 		foreach (@$state as $key=>$value)
 		{
 			$model->setState( $key, $value );
 		}
 		return $state;
 	}


}
