<?php
	/*------------------------------------------------------------------------
	 # com_k2store - K2Store
	# ------------------------------------------------------------------------
	# author    priya Bose - Weblogicx India http://www.weblogicxindia.com
	# copyright Copyright (C) 2012 Weblogicxindia.com. All Rights Reserved.
	# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
	# Websites: http://k2store.org
	# Technical Support:  Forum - http://k2store.org/forum/index.html
	-------------------------------------------------------------------------*/

	/**  Check to ensure this file is included in Joomla! */
	defined('_JEXEC') or die( 'Restricted access' );
	require_once(JPATH_COMPONENT_ADMINISTRATOR.'/library/prices.php');

?>
<div class="k2store">

	<div class="row-fluid">
		<div class="span6">
			<h3 class="badge badge-success">
				<?php echo JText::_('K2STORE_BILLING_ADDRESS'); ?>
			</h3>
		<!--  For Each Loop first part Starts for customer -->
		<?php foreach($this->data as $customer):?>
			<?php
			/**  if Condition to check the Type of Cutomer */
			if($customer->type=='billing'): ?>


				<div class="well">

					<!-- Customer's  Billing Address Details  -->
					<address class="pull-left">
						<strong>
							<?php echo $customer->first_name.' '.$customer->last_name;?>
						</strong><br />
						<?php echo $customer->address_1;?>
						<?php echo $customer->city.' '.$customer->zip;?>
						<?php echo $customer->zone_name;?>
						<?php echo $customer->country_name;?>
						<?php echo $customer->phone_1;?>
					</address>

					<!--  Delete Options  for Billing Address -->
					<span class="pull-right">
						<a class="btn btn-danger" href="<?php echo JRoute::_('index.php?option=com_k2store&view=customer&task=delete&id='.$customer->id);?>">
							<?php echo JText::_('K2STORE_DELETE');?>
						</a>
					</span>
			</div>

		<!-- If Condition Ends Here  -->
		<?php endif; ?>

		<!-- first part of  Foreach Loop Ends here   -->
		<?php endforeach; ?>

		</div>
		<div class="span6">
			<h3 class="badge badge-info"><?php echo JText::_('K2STORE_SHIPPING_ADDRESS');?></h3>
			<!--  For Each Loop Strats for Second part Customer details -->
			<?php  foreach($this->data as $customer):?>

				<!--  End Of if True statement &  start of if False statement -->
				<?php  if($customer->type=='shipping'): ?>
				<div class="well">
					<!-- Customer's Shipping Address Starts here  -->
					<address class="pull-left">
						<strong>
							<?php echo $customer->first_name.'  '.$customer->last_name;?>
						</strong><br/>
						<?php echo $customer->address_1;?>
						<?php echo $customer->city;?>
						<?php echo $customer->zone_name;?>
						<?php echo $customer->country_name;?>
						<?php echo $customer->phone_1;?>
					</address>
					<!--  Delete Options  for Shipping Address -->
					<span class="pull-right">
						<a  class="btn btn-danger" href="<?php echo JRoute::_('index.php?option=com_k2store&view=customer&task=delete&id='.$customer->id);?>">
							<?php echo JText::_('K2STORE_DELETE');?>
						</a>
					</span>
				</div>
				<!--  End of if False  Statement -->
				<?php endif; ?>

			<!--  Second Part of Foreach Loop Ends here -->
			<?php endforeach; ?>

		</div><!--  Div Span Ends here -->

	</div> <!-- div row fluid ends here -->


	<!--  Table for Order Details Displaying -->
	<h3 class="text-center"><?php echo JText::_('K2STORE_ORDER_HISTORY');?></h3>
	<table class="adminlist table table-striped table-bordered table-hover">
		<thead>
			<tr>
				<th>
					<?php echo JText::_('K2STORE_NO');?>
				</th>
				<th>
					<?php echo JText::_('K2STORE_ORDER_DATE');?>
				</th>
				<th>
					<?php echo JText::_('K2STORE_ORDER_ORDER_ID');?>
				</th>
				<th>
					<?php echo JText::_('K2STORE_ORDER_AMOUNT');?>
				</th>
				<th>
					<?php echo JText::_('K2STORE_ORDER_ORDER_STATUS');?>
				</th>
			</tr>
		</thead>


		<tbody>
			<?php
				$i=0; // Initializing for the Serial Number
				foreach ($this->orders as $order): // Loop for Displaying the list of items

				/** Assing the link in the variable	 */
				$link=JRoute::_('index.php?option=com_k2store&view=orders&task=view&id='.$order->id);
				$i++; // Increment for the Serial Number
			?>
			<tr>
				<td><?php echo $i; ?></td>
				<td><?php echo JHTML::_('date', $order->created_date, $this->params->get('date_format', JText::_('DATE_FORMAT_LC1'))); ?></td>

				<td>
				<a href="<?php echo $link;?>">
				<?php echo $order->id;?>
				</a>
				</td>
				<td><?php echo K2StorePrices::number($order->orderpayment_amount);?></td>
				<td>
				<?php
					if($order->order_state_id == 1) {
						$label_class='success';
					} elseif($order->order_state_id == 3 || $order->order_state_id == 5 || $order->order_state_id == '') {
						$label_class='important';
					} elseif($order->order_state_id == 4) {
						$label_class='warning';
					 }
					?>
					<span class="label label-<?php echo $label_class;?> order-state-label">
						<?php
						if(JString::strlen($order->order_state) > 0) {
							echo JText::_($order->order_state);
						} else {
							echo JText::_('K2STORE_PAYSTATUS_INCOMPLETE');
						}
				?>
			</span>

				</td>
			</tr>

			<?php endforeach; ?>
		</tbody>
	</table>
</div>

