<?php
/*------------------------------------------------------------------------
 # com_k2store - K2Store
# ------------------------------------------------------------------------
# author    Priya bose - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2012 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://k2store.org
# Technical Support:  Forum - http://k2store.org/forum/index.html
-------------------------------------------------------------------------*/



/** Check to ensure this file is included in Joomla! */
defined('_JEXEC') or die( 'Restricted access' );

jimport('joomla.application.component.model');

/**
 *
 * @package		Joomla
 * @subpackage	K2Store
 * @since 2.5
*/
class K2StoreModelCustomers extends K2StoreModel
{
	/**
	 *
	 * @var array
	 */
	var $_data = null;

	/**
	 *
	 * @var integer
	 */
	var $_total = null;

	/**
	 * Pagination object
	 *
	 * @var object
	 */
	var $_pagination = null;

	/**
	 * Constructor
	 *
	 * @since 2.5
	 */
	function __construct()
	{
		parent::__construct();

		$mainframe = JFactory::getApplication();
		$option = 'com_k2store';
		//$ns = $option.'.addresses';
		$ns = $option.'.customers';
		// Get the pagination request variables
		$limit		= $mainframe->getUserStateFromRequest( 'global.list.limit', 'limit', $mainframe->getCfg('list_limit'), 'int' );
		$limitstart	= $mainframe->getUserStateFromRequest( $ns.'.limitstart', 'limitstart', 0, 'int' );

		// In case limit has been changed, adjust limitstart accordingly
		$limitstart = ($limit != 0 ? (floor($limitstart / $limit) * $limit) : 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
	}

	/**
	 * Method for Getting Data
	 * @access public
	 * @return array
	 */
	function getData()
	{
		// Lets load the content if it doesn't already exist
		if (empty($this->_data))
		{
			$query = $this->_buildQuery();
			$this->_data = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
		}

		return $this->_data;
	}

	/**
	 * Method for getting Total
	 * @access public
	 * @return integer
	 */
	function getTotal()
	{
		// Lets load the content if it doesn't already exist
		if (empty($this->_total))
		{
			$query = $this->_buildQuery();
			$this->_total = $this->_getListCount($query);
		}

		return $this->_total;
	}

	/**
	 * Method to get a pagination object
	 *
	 * @access public
	 * @return integer
	 */
	function getPagination()
	{
		// Lets load the content if it doesn't already exist
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination( $this->getTotal(), $this->getState('limitstart'), $this->getState('limit') );
		}

		return $this->_pagination;
	}

	/**
	 *Method for building query Objects
	 *@return query object joomla's default object
	 */
	function _buildQuery()
	{
		/** get DataBase Object */
		$db = JFactory::getDbo();

		/** Get current query Object */
		$query = $db->getQuery(true);

		$query->select('a.*')->from('#__k2store_address AS a');
		$query->leftJoin('#__k2store_countries AS c ON c.country_id = a.country_id');
		$query->select('c.country_name');
		$query->leftJoin('#__k2store_zones AS z ON z.zone_id=a.zone_id');
		$query->select('z.zone_name');
		$query		= $this->_buildContentWhere($query);

		$query		= $this->_buildContentOrderBy($query);
		$query		= $this->_buildContentGroupBy($query);

		//echo $query;

		return $query;
	}

	/**
	 * Method for Building Order query Object
	 * @param  $query Object Joomla's Default Object
	 * @return query Object after setting the Order
	 */
	function _buildContentOrderBy($query)
	{
		$mainframe = JFactory::getApplication();
		$option = 'com_k2store';
		$ns = $option.'.customers';
		$filter_order		= $mainframe->getUserStateFromRequest( $ns.'filter_order',		'filter_order',		'a.id',	'cmd' );
		$filter_order_Dir	= $mainframe->getUserStateFromRequest( $ns.'filter_order_Dir',	'filter_order_Dir',	'ASC','word' );
		$query->order($filter_order.' '.$filter_order_Dir);
		return $query;
	}

	/**
	 * Method for building Where query Object
	 * @param $query Object Joomla's Default Object
	 * @return $query Object after setting where Condition
	 */

	function _buildContentWhere($query)
		{
		/** initialise the variables */
		$mainframe = JFactory::getApplication();

		$option = 'com_k2store';
		$ns = $option.'.customers';

		/** Get the Database Object */
		$db	= JFactory::getDBO();

		/** load the filter state */
		$search	= $mainframe->getUserStateFromRequest( $ns.'search',			'search',			'',				'string' );

		if (strpos($search, '"') !== false) {
			$search = str_replace(array('=', '<'), '', $search);
			}
		$search = JString::strtolower($search);

		if ($search) {
			$where = 'LOWER(a.first_name) LIKE '.$db->Quote( '%'.$db->escape( $search, true ).'%', false ).
			'OR LOWER(a.last_name) LIKE '.$db->Quote( '%'.$db->escape( $search, true ).'%', false ).
			//'OR LOWER(u.username) LIKE '.$db->Quote( '%'.$db->escape( $search, true ).'%', false ).
			'OR LOWER(a.city) LIKE '.$db->Quote( '%'.$db->escape( $search, true ).'%', false ).
			'OR LOWER(a.zip) LIKE '.$db->Quote( '%'.$db->escape( $search, true ).'%', false ).
			'OR LOWER(z.zone_name) LIKE '.$db->Quote( '%'.$db->escape( $search, true ).'%', false ).
			'OR LOWER(c.country_name) LIKE '.$db->Quote( '%'.$db->escape( $search, true ).'%', false );

			$query->where($where);
		}
		$query->where("a.email !=''");
		return $query;
	}

	/**
	 * Method for building Group query Object
	 * @param query object - joomla's default object
	 * @return query
	 */

	function _buildContentGroupBy($query)
		{
			$query->group('a.email');
			$query->group('a.user_id');
			return $query;
		}

	/**
	 * Method for  Delete query Object
	 * @param array customer_id
	 * @return boolean
	 */
	function delete($cid = array())
	{
		$result = false;

		if (count( $cid ))
		{
			JArrayHelper::toInteger($cid);

			$cids = implode( ',', $cid );

			$query = 'DELETE FROM #__k2store_address'
					. ' WHERE id IN ( '.$cids.' )';

			$this->_db->setQuery( $query );
			if(!$this->_db->query()) {
				$this->setError($this->_db->getErrorMsg());
				return false;
			}
		}
		return true;
	}


}
