<?php
/*------------------------------------------------------------------------
# com_k2store - K2 Store v 1.0
# ------------------------------------------------------------------------
# author    Sasi varna kumar - Weblogicx India http://www.weblogicxindia.com
# copyright Copyright (C) 2012 Weblogicxindia.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://k2store.org
# Technical Support:  Forum - http://k2store.org/forum/index.html
-------------------------------------------------------------------------*/

// No direct access to this file
defined('_JEXEC') or die;
require_once(JPATH_ADMINISTRATOR.'/components/com_k2store/library/popup.php');
/**
 * Product Options Select Form Field class for the K2Store component
 */
class JElementPriceRange extends JElement
{
	/**
	 * The field type.
	 *
	 * @var		string
	 */
	var	$_name = 'PriceRange';
	
	function fetchElement($name, $value, &$node, $control_name){

		$fieldName = $control_name.'['.$name.']';
 		
 		//get libraries
 		$html ='';
 		
 		$html .='<table class="table k2store_itemoptions"><tr><td>';
 		
 		$cid = JRequest::getVar('cid');
 		if($cid) {
 			$link = 'index.php?option=com_k2store&view=products&task=setpricerange&id='.$cid.'&tmpl=component';
 			//let us first get Product Attribute Names
 			$attributes = $this->getProductPriceRange($cid);
 			if(!empty($attributes)) {
 				$html .=$attributes;
 			}
 		
 			$html .= K2StorePopup::popup( $link, JText::_( "K2STORE_PR_ADD_REMOVE_PRICERANGE" ) );
 			$html .= '<small>'.JText::_('K2STORE_PR_NOTE').'</small>';
 		} else {
 			$html .= JText::_('K2STORE_PR_CLICK_SAVE_FILL_RANGE');
 		}
 		$html .= '</td></tr></table>';
 		return $html;
 	
	 }
	 
	 function getProductPriceRange($product_id) {
	 
	 	$db = JFactory::getDBO();
	 	$query = 'SELECT a.* FROM #__k2store_productprices AS a WHERE a.product_id='. (int) $product_id
	 	.' ORDER BY a.ordering ASC'
	 	;
	 	$db->setQuery($query);
	 	$rows = $db->loadObjectList();
	 	$html= '';
	 
	 	if(count($rows)) {
	 		$html .='<table class="adminlist table table-striped k2store"  id="k2store_table">
	 		<thead>
	 		<th>'.JText::_('K2STORE_PR_QUANTITY_START').'</th>
	 		<th>'.JText::_('K2STORE_PR_PRICE').'</th>
	 		</thead>
	 		<tbody>';
	 		foreach($rows as $row) {
	 			//lets get a list of attribute options for each attribute
	 
	 			$html .='<tr>';
	 			$html .='<td>'.$row->quantity_start.'&nbsp;&nbsp;';
	 			$html .=JText::_('K2STORE_PR_COND_'.$row->condition).'</td>';
	 			$html .='<td>'.$row->price.'</td>';
	 			$html .='</tr>';
	 		}
	 			
	 		$html .='</tbody>';
	 		$html .='</table>';
	 	}
	 	return $html;
	 }
	 
 }