<?php
session_start();
//error_reporting(E_ALL);

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');

/**
* Prijungiama ../classes/Customer.class.php Klientų informacijos valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');





$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));

$customer = new Customer();


$smarty->assign('plans',$customer->getPlans());
$smarty->assign('owners',$customer->getOwners());

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	
	$smarty->assign('ipv4',$_POST['ipv4']);
	$smarty->assign('mask',$_POST['mask']);
	$smarty->assign('gateway',$_POST['gateway']);
	
	$smarty->assign('dns1',$_POST['dns1']);
	$smarty->assign('dns2',$_POST['dns2']);
	$smarty->assign('mac',$_POST['mac']);
	$smarty->assign('other',$_POST['other']);
	

	$error = 0;
	if (!$customer->checkIPv4($_POST['ipv4']))  {
		$smarty->assign('ipv4_error',1);
		$error++;
	}
	if (!$customer->checkIPv4($_POST['mask']))  {
		$smarty->assign('mask_error',1);
		$error++;
	}
	if (!$customer->checkIPv4($_POST['gateway']))  {
		$smarty->assign('gateway_error',1);
		$error++;
	}
	if (!$customer->checkIPv4($_POST['dns1']))  {
		$smarty->assign('dns1_error',1);
		$error++;
	}
	if (!$customer->checkIPv4($_POST['dns2']) && strlen($_POST['dns2']) > 0 )  {
		$smarty->assign('dns2_error',1);
		$error++;
	}
	
	if (!$customer->checkMAC($_POST['mac']))  {
		$smarty->assign('mac_error',1);
		$error++;
	}


	if ($error == 0) {

		
		
		$customer->insertAddress($_POST['ipv4'],$_POST['mask'],$_POST['gateway'],$_POST['dns1'],$_POST['dns2'],$_POST['other'],$_GET['id'],$_POST['mac']);
		echo "<script language='javascript'>this.location = 'contract_detail.php?id=".$_GET['id']."&success=1'</script>";
		//return ;
	}
	$smarty->assign('error',$error);
}





$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/insert_ipv4.tpl');
}


?>