<?php
session_start();
//error_reporting(E_ALL);

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');

/**
* Prijungiama ../classes/Customer.class.php Klientų informacijos valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');





$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));

$customer = new Customer();

$smarty->assign('password',$customer->generatePassword());

if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_GET['customer_type'] == 1) {
	
	$smarty->assign('name',$_POST['name']);
	$smarty->assign('surname',$_POST['surname']);
	$smarty->assign('code',$_POST['code']);
	$smarty->assign('address',$_POST['address']);
	$smarty->assign('phone',$_POST['phone']);
	$smarty->assign('username',$_POST['username']);
	$smarty->assign('password',$_POST['password']);
	$error = 0;
	if (!$customer->checkNaturalPersonNameSurname($_POST['name']))  {
		$smarty->assign('name_error',1);
		$error++;
	}
	if (!$customer->checkNaturalPersonNameSurname($_POST['surname']))  {
		$smarty->assign('surname_error',1);
		$error++;
	}
	if (!$customer->checkIdentityCode($_POST['code']))  {
		$smarty->assign('code_error',1);
		$error++;
	}
	if (!$customer->checkAddress($_POST['address']))  {
		$smarty->assign('address_error',1);
		$error++;
	}
	if (!$customer->checkPhone($_POST['phone']) && strlen($_POST['phone']) > 0)  {
		$smarty->assign('phone_error',1);
		$error++;
	}
	if (!$customer->checkUsername($_POST['username']))  {
		$smarty->assign('username_error',1);
		$error++;
	} elseif ($customer->checkUsernameExistence($_POST['username'])) {
		$smarty->assign('username_exist_error',1);
		$error++;
	}
	if (!$customer->checkPassword($_POST['password']))  {
		$smarty->assign('password_error',1);
		$error++;
	}
	if ($error == 0) {
		$customer->insertCustomer(null,$_POST['code'],null,$_POST['name'],$_POST['surname'],$_POST['address'],$_POST['phone'],$_POST['username'],$_POST['password'],false);
		echo "<script language='javascript'>this.location = 'customers.php?success=1'</script>";
	}
	$smarty->assign('error',$error);
}


if ($_SERVER['REQUEST_METHOD'] == 'POST' && $_GET['customer_type'] == 2) {
	
	$smarty->assign('company_name',$_POST['company_name']);
	$smarty->assign('name',$_POST['name']);
	$smarty->assign('surname',$_POST['surname']);
	$smarty->assign('code',$_POST['code']);
	$smarty->assign('vat_code',$_POST['vat_code']);
	$smarty->assign('address',$_POST['address']);
	$smarty->assign('phone',$_POST['phone']);
	$smarty->assign('username',$_POST['username']);
	$smarty->assign('password',$_POST['password']);
	$error = 0;
	if (!$customer->checkCompanyName($_POST['company_name']))  {
		$smarty->assign('company_name_error',1);
		$error++;
	}
	if (!$customer->checkNaturalPersonNameSurname($_POST['name']))  {
		$smarty->assign('name_error',1);
		$error++;
	}
	if (!$customer->checkNaturalPersonNameSurname($_POST['surname']))  {
		$smarty->assign('surname_error',1);
		$error++;
	}
	if (!$customer->checkVATCode($_POST['vat_code']))  {
		$smarty->assign('vat_code_error',1);
		$error++;
	}
	if (!$customer->checkCode($_POST['code']))  {
		$smarty->assign('code_error',1);
		$error++;
	}
	if (!$customer->checkAddress($_POST['address']))  {
		$smarty->assign('address_error',1);
		$error++;
	}
	if (!$customer->checkPhone($_POST['phone']) && strlen($_POST['phone']) > 0)  {
		$smarty->assign('phone_error',1);
		$error++;
	}
	if (!$customer->checkUsername($_POST['username']))  {
		$smarty->assign('username_error',1);
		$error++;
	} elseif ($customer->checkUsernameExistence($_POST['username'])) {
		$smarty->assign('username_exist_error',1);
		$error++;
	}
	if (!$customer->checkPassword($_POST['password']))  {
		$smarty->assign('password_error',1);
		$error++;
	}
	if ($error == 0) {
		$customer->insertCustomer($_POST['company_name'],$_POST['code'],$_POST['vat_code'],$_POST['name'],$_POST['surname'],$_POST['address'],$_POST['phone'],$_POST['username'],$_POST['password'],true);
		echo "<script language='javascript'>this.location = 'customers.php?success=1'</script>";
	}
	$smarty->assign('error',$error);
}


$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/insert_customer.tpl');
}


?>