<?php
session_start();
//error_reporting(E_ALL);

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');

/**
* Prijungiama ../classes/Customer.class.php Klientų informacijos valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');





$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));

$customer = new Customer();


$smarty->assign('customer',$customer->getCustomer($_GET['id']));

$smarty->assign('plans',$customer->getPlans());
$smarty->assign('owners',$customer->getOwners());

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	
	$smarty->assign('plan_id',$_POST['plan_id']);
	$smarty->assign('mountly_fee',$_POST['mountly_fee']);
	$smarty->assign('owner_id',$_POST['owner_id']);
	
	$smarty->assign('valid_from',$_POST['valid_from']);
	$smarty->assign('valid_to',$_POST['valid_to']);
	$smarty->assign('is_active',$_POST['is_active']);
	$smarty->assign('other_info',$_POST['other_info']);

	$error = 0;
	if (strlen($_POST['plan_id']) == 0)  {
		$smarty->assign('plan_id_error',1);
		$error++;
	}
	if (!$customer->checkDigit($_POST['mountly_fee']))  {
		$smarty->assign('mountly_fee_error',1);
		$error++;
	}
	if (strlen($_POST['owner_id']) == 0)  {
		$smarty->assign('owner_id_error',1);
		$error++;
	}
	if (strlen($_POST['valid_from']) == 0)  {
		$smarty->assign('valid_from_error',1);
		$error++;
	}
	if (strlen($_POST['valid_from']) > 0 && strlen($_POST['valid_to']) > 0)  {
		//echo $customer->checkDates($_POST['valid_from'],$_POST['valid_to']);
		if (!$customer->checkDates($_POST['valid_to'],$_POST['valid_from'])) {
			//echo "blogai";
			$smarty->assign('dates_error',1);
			$error++;			
		}
	}
	
	

	if (strlen($_FILES['contract_path']['tmp_name']) > 0 && !is_uploaded_file($_FILES['contract_path']['tmp_name']) ) {
		$error++;
		$smarty->assign('contract_path_error',1);
	}

	if ($error == 0) {
		//echo "gerai";
		//echo time();
		
		$contract_path = "";
		if (is_uploaded_file($_FILES['contract_path']['tmp_name'])) {
			$contract_path = '../contracts/'.time().$_FILES['contract_path']['name'];
			move_uploaded_file($_FILES['contract_path']['tmp_name'], $contract_path);
		}
		
		//$customer_id,$plan_id,$mountly_fee,$owner_id,$valid_from,$valid_to,$contract_path,$suspend_from,$suspend_to,$is_active
		$customer->insertContract($_GET['id'],$_POST['plan_id'],$_POST['mountly_fee'],$_POST['owner_id'],$_POST['valid_from'],$_POST['valid_to'],$contract_path,null,null,$_POST['is_active'],$_POST['other_info']);
		echo "<script language='javascript'>this.location = 'customer_detail.php?id=".$_GET['id']."&type=".$_GET['type']."&success=1'</script>";
		return ;
	}
	$smarty->assign('error',$error);
}





$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/insert_contract.tpl');
}


?>