<?php
session_start();

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');







/**
* Prijungiama ../classes/SiteConfig.class.php Globalių parametrų valdymo klasių biblioteka
*/
require_once('../classes/SiteConfig.class.php');


/**
* Prijungiama Logging.class.php istorijos žurnalų valdymo klasių biblioteka
*/
require_once('../classes/Logging.class.php');

/**
* Prijungiama Customer.class.php klientų valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');


$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));


$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);



$cust = new Customer();

if (@$_GET['delete'] > 0) {
	$makes->removeMake($_GET['delete']);
	//echo "delete";
}







$tabSize = 1000;
$smarty->assign('tab_size',$tabSize);

if (isset($_POST['post_form'])) {
	$smarty->assign('search',trim($_POST['search']));
	$search = trim($_POST['search']);
	
	$smarty->assign('type',trim($_POST['type']));
	$type = trim($_POST['type']);
	
} else {
	$smarty->assign('search',@trim($_GET['search']));
	$search = @trim($_GET['search']);
	
	$smarty->assign('type',@trim($_GET['type']));
	$type = @trim($_GET['type']);
}

if (@$_GET['offset'] + 0 == 0) {
	$offset = 0;
} else {
	$offset = $_GET['offset'];
}

//Sukuriame masyva is tiek elementu kiek grazinama pagal paieskos salyga
$countArray = null;
$customersCount = $cust->getCustomersCount($search,$type);
for ($i = 0; $i < $customersCount; $i++ ) {
	$countArray[] = $i;
}

$smarty->assign('customers',$cust->getCustomers($offset,$tabSize,$search,$type));
$smarty->assign('customers_count',$countArray);
$smarty->assign('count',$customersCount);



if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/customers.tpl');
}

?>