<?php
session_start();

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');







/**
* Prijungiama ../classes/SiteConfig.class.php Globalių parametrų valdymo klasių biblioteka
*/
require_once('../classes/SiteConfig.class.php');


/**
* Prijungiama Logging.class.php istorijos žurnalų valdymo klasių biblioteka
*/
require_once('../classes/Logging.class.php');

/**
* Prijungiama Customer.class.php klientų valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');


$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));


$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);



$cust = new Customer();


$smarty->assign('owners',$cust->getOwners());





$tabSize = 1000;
$smarty->assign('tab_size',$tabSize);

if (isset($_POST['post_form'])) {
	$smarty->assign('owner_id',$_POST['owner_id']);
	$smarty->assign('valid',$_POST['valid']);
	$smarty->assign('not_valid',$_POST['not_valid']);
	$smarty->assign('suspended',$_POST['suspended']);
	$smarty->assign('broken',$_POST['broken']);
	
	$smarty->assign('search',trim($_POST['search']));
	$search = trim($_POST['search']);
	
	
	$owner_id = $_POST['owner_id'];
	$valid = trim($_POST['valid']);
	$not_valid = trim($_POST['not_valid']);
	$suspended = trim($_POST['suspended']);
	$broken = trim($_POST['broken']);
	
	$smarty->assign('type',trim($_POST['type']));
	$type = trim($_POST['type']);
	

	
} else {
	$smarty->assign('search',@trim($_GET['search']));
	$search = @trim($_GET['search']);
	
	$smarty->assign('type',@trim($_GET['type']));
	$type = @trim($_GET['type']);
	

	$smarty->assign('owner_id',@$_GET['owner_id']);
	$smarty->assign('valid',@$_GET['valid']);
	$smarty->assign('not_valid',@$_GET['not_valid']);
	$smarty->assign('suspended',@$_GET['suspended']);
	$smarty->assign('broken',@$_GET['broken']);
	
	$owner_id = @$_GET['owner_id'];
	$valid = @trim($_GET['valid']);
	$not_valid = @trim($_GET['not_valid']);
	$suspended = @trim($_GET['suspended']);
	$broken = @trim($_GET['broken']);
	
	// &amp;owner_id={%$owner_id%}&amp;valid={%$valid%}&amp;not_valid={%$not_valid%}&amp;suspended={%$suspended%}&amp;broken={%$broken%}
}


if (@$_GET['offset'] + 0 == 0) {
	$offset = 0;
} else {
	$offset = $_GET['offset'];
}

//Sukuriame masyva is tiek elementu kiek grazinama pagal paieskos salyga
$countArray = null;
$contractsCount = $cust->getCustomerContractsBySearchCount($search,$type,$owner_id,$valid,$not_valid,$suspended,$broken);
for ($i = 0; $i < $contractsCount; $i++ ) {
	$countArray[] = $i;
}

//$contracts = $customer->getCustomerContracts($_GET['id']);
//getCustomerContractsBySearch($offset,$limit,$search,$type,$owner_id,$valid,$not_valid,$suspended,$broken)
$smarty->assign('contracts',$cust->getCustomerContractsBySearch($offset,$tabSize,$search,$type,$owner_id,$valid,$not_valid,$suspended,$broken));
$smarty->assign('contracts_count',$countArray);
$smarty->assign('count',$contractsCount);

$smarty->assign('money',$cust->getCustomerContractsBySearchMoney($search,$type,$owner_id,$valid,$not_valid,$suspended,$broken));

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/contracts.tpl');
}

?>