<?php
/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');



/**
* Prijungiama ../classes/SiteConfig.class.php Globalių parametrų valdymo klasių biblioteka
*/
require_once('../classes/SiteConfig.class.php');


/**
* Prijungiama Logging.class.php istorijos žurnalų valdymo klasių biblioteka
*/
require_once('../classes/Logging.class.php');

/**
* Prijungiama Customer.class.php klientų valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');

/**
* Prijungiama SMSSender.class.php SMS siuntimo valdymo klasių biblioteka
*/
require_once('../classes/SMSSender.class.php');


$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));


$cust = new Customer();
$sms = new SMSSender();



$initID=0;
if (substr(key($_GET),0,-8)<1) {
	$initID=0;
} else {
	$initID=substr(key($_GET),0,-8);
}

$customer = $cust->checkCustomerByIDPassword($initID,substr(key($_GET),-8,8));
if (count($customer) == 0) {
	echo "<html><head><script src='../js/sweetalert2.all.min.js'></script><script src='../js/promises.js'></script></head><body><script language='javascript'>swal.fire( 'Bloga užklausa!' ,  'Pasitikrinkite ar teisingai įvestas išrašo adresas!' ,  'error' ).then(function(result){window.close();});</script></body></html>";
	return;
}

$contractID = substr(key($_GET),0,-8);


$smsMessageID = $sms->getLastSMSDataByContractID($contractID)[0];
if ($smsMessageID == null) {
	echo "<html><head><script src='../js/sweetalert2.all.min.js'></script></head><body><script language='javascript'>swal.fire( 'Bloga užklausa!' ,  'Nesuformuotas atsiskaitymų išrašas!' ,  'warning' ).then(function(result){window.close();});  </script></body></html>";
	return;
}
$before32Days = (new \DateTime())->modify('-32 day');
$smsDay = new DateTime($sms->getLastSMSDataByContractID($contractID)[5]);
if ($before32Days > $smsDay) {
	echo "<html><head><script src='../js/sweetalert2.all.min.js'></script></head><body><script language='javascript'>swal.fire( 'Negalioja!' ,  'Suformuotas išrašas galioja tik 1 mėnesį!' ,  'warning' ).then(function(result){window.close();});  </script></body></html>";
	return;
}
if (strlen($sms->getLastSMSDataByContractID($contractID)[9]) == 0) {
	//echo 'nulis'.$smsMessageID;
	$sms->updateURLViewTime($smsMessageID);
} else {
	//print_r($sms->getLastSMSDataByContractID($contractID)[9]);
}
//;

$contractsCount = $cust->getCustomerInvoicesCountByContractID($contractID);

$smarty->assign('contracts_grouped',$cust->getCustomerInvoicesGroupedByContractID($contractID));
$invoices = $cust->getCustomerInvoicesByCustomerIDJoin($customer[12]);

$smarty->assign('contracts',$invoices);
$smarty->assign('count',$contractsCount);

$smarty->assign('money',$cust->getCustomerInvoicesMoneyByContractID($contractID));




$smarty->display('admin/print_invoices_public.tpl');




?>