<?php
/**
*Prisijungimo prie DBVS valdymas

*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama DB.php PEAR klasių biblioteka
*/
require_once("MDB2.php");


/** 
* RDBVS iniciacija 
*
* Prisijungimo nustatymo klasė
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class ConnectManagerMSSQL
{
	/**
	*DNS prisijungimas prie DB
	*@var String DNS String eilutė
	*/
	private $dsn = 'mssql://sa:Linuzas123+@127.0.0.1/im00';
	
	/**
	*Prisijungimo ir portatyvimo parametrų masyvas
	*@var Array Prisijungimo parametrai
	*/
	private $options = array(
    						'debug'       => 2,
   							'portability' => MDB2_PORTABILITY_ALL,
							);		


	/**
	*DB prisijungimo objektas
	*@var Object Prisijungimo prie duomenų bazės objektas
	*/
	private $db;
	
	/**
	*Klasės konstruktorius 
	*
	*Inicijuojamas prisijungimas prie duomenų bazės
	*/
	public function __construct()
	{


		$this->db =& MDB2::singleton($this->dsn,$this->options);
		if (PEAR::isError($this->db)) {
		    die('ConnectManager->__construct: '.$this->db->getMessage());
		}

	}
	/**
	*Gražinamas prisijungimo objektas
	*@return Object Prisijungimo objektas
	*/
	public function getConnect()
	{
		return $this->db;
	}
}
?>
