<?php
session_start();

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');







/**
* Prijungiama ../classes/SiteConfig.class.php Globalių parametrų valdymo klasių biblioteka
*/
require_once('../classes/SiteConfig.class.php');


/**
* Prijungiama Logging.class.php istorijos žurnalų valdymo klasių biblioteka
*/
require_once('../classes/Logging.class.php');

/**
* Prijungiama Customer.class.php klientų valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');

require_once("../classes/xajax/xajax_core/xajax.inc.php");

$xajax = new xajax();

$xajax->configure('javascript URI', '../classes/xajax/');

$xajax->registerFunction("getCustomersData");

$xajax->processRequest();
$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));
$smarty->assign('js',$xajax->getJavascript());


function getCustomersData($arg)
{
	$ext++;
	$cust = new Customer();
	$allCustomer = $cust->getCustomersForSMS();
	$howMuchCustomers = count($allCustomer);
	$customer = $cust->getCustomer($arg);
	$objResponse = new xajaxResponse();
	
	$objResponse->script("var elem = document.getElementById('checked');elem.value=parseInt(elem.value)+1");
	//
	$str = '';
	$moneyStatus = $cust->checkImports($arg);
	
	$paymentCompareTable = '<table width="240" cellpadding="1" cellspacing="1">';
	$contractInvoiceStatusArray = $cust->checkContractWithInvoices($arg);
	$foundMonthlyChage = 0;
	if (count($contractInvoiceStatusArray) > 0) {
		if ($contractInvoiceStatusArray[0][5] == 1) {
			$paymentCompareTable .= '<tr><td colspan="2"><font color="red"><b>'.$contractInvoiceStatusArray[0][1].' mėn/€</b></font></td><td><font color="red"><b>'.substr($contractInvoiceStatusArray[0][3], 0, 19).'</b></font></td></tr>';
			$foundMonthlyChage = 1;
		} else {
			$paymentCompareTable .= '<tr><td colspan="2"><b>'.$contractInvoiceStatusArray[0][1].' mėn/€</b></td><td><b>'.substr($contractInvoiceStatusArray[0][3], 0, 19).'</b></td></tr>';
		}
	}
	if ($foundMonthlyChage == 1) {
		$objResponse->script("var elem = document.getElementById('contractchanges');elem.value=parseInt(elem.value)+1");
	}
	
	
	$contractInvoiceStatus = 0;
	$i = 0;
    while ($i < count($contractInvoiceStatusArray )) {
		
		if ($contractInvoiceStatusArray[$i][1] != $contractInvoiceStatusArray[$i][2]) { 
			$contractInvoiceStatus = 1;
			$paymentCompareTable .= '<tr><td><font color="red"><b>'.$contractInvoiceStatusArray[$i][0].'</b></font></td><td><font color="red"><b>'.$contractInvoiceStatusArray[$i][2].'</b></font></td><td><font color="red"><b>'.substr($contractInvoiceStatusArray[$i][4], 0, 19).'</b></font></td></tr>';
		} else {
			$paymentCompareTable .= '<tr><td>'.$contractInvoiceStatusArray[$i][0].'</td><td>'.$contractInvoiceStatusArray[$i][2].'</td><td>'.substr($contractInvoiceStatusArray[$i][4], 0, 19).'</td></tr>';
		}
		$i++;
	}
	$paymentCompareTable .= '</table>';
	
	if ($contractInvoiceStatus == 1) {
		$objResponse->script("var elem = document.getElementById('invoicedifferent');elem.value=parseInt(elem.value)+1");
	}
	
	//$paymentCompareTable = '';
			
	if ($moneyStatus == 0 || $moneyStatus == 2) $str = "<img src=\"pics/money_ok.png\" />";
	if ($moneyStatus == 1 || $moneyStatus == 3) {
		$str = "<img src=\"pics/money_failed.png\" />";
		$objResponse->script("var elem = document.getElementById('badimports');elem.value=parseInt(elem.value)+1");
	}
	
	if ($customer[10] == 'f') {
		$objResponse->script("var table = document.getElementById('customers');var row = table.insertRow(0);var cell1 = row.insertCell(0);var cell2 = row.insertCell(1);var cell3 = row.insertCell(2);var cell4 = row.insertCell(3);cell1.innerHTML = '<a target=\"_blank\" href=\"http://mano.bitnet.lt/admin/invoices.php?search=".$customer[2]."\">".$customer[4]."</a>';cell2.innerHTML = '<a target=\"_blank\" href=\"http://mano.bitnet.lt/admin/invoices.php?search=".$customer[2]."\">".$customer[5]."</a>';cell3.innerHTML = '".$paymentCompareTable."';cell4.innerHTML = '".$str."';cell2.setAttribute('width', '50%');cell1.setAttribute('width', '50%');");
	} else {
		$objResponse->script("var table = document.getElementById('customers');var row = table.insertRow(0);var cell1 = row.insertCell(0);var cell2 = row.insertCell(1);var cell3 = row.insertCell(2);var cell4 = row.insertCell(3);cell1.innerHTML = '<a target=\"_blank\" href=\"http://mano.bitnet.lt/admin/invoices.php?search=".$customer[2]."\">".$customer[1]."</a>';cell2.innerHTML = '<a target=\"_blank\" href=\"http://mano.bitnet.lt/admin/invoices.php?search=".$customer[2]."\">".$customer[4]." ".$customer[5]."</a>';cell3.innerHTML = '".$paymentCompareTable."';cell4.innerHTML = '".$str."';cell2.setAttribute('width', '50%');cell1.setAttribute('width', '50%');");
	}
	//$objResponse->script("document.getElementById(\"".$arg."\").innerHTML = \"<img src=\"pics/money_ok.png\" />\"");
	
	$objResponse->script("var elem = document.getElementById('myBar'); elem.style.width = 100*document.getElementById('customers').rows.length/".$howMuchCustomers." + '%';   elem.innerHTML = Math.round(100*document.getElementById('customers').rows.length/".$howMuchCustomers."*10)/10 + '%';");

	
	
	
	
	 
	//for ($i=0; $i <count($contracts); $i++) {
		 //$newContent .= '<option value=\''.$desgi[$i][0].'\'>'.$desgi[$i][1].'</option>';
		// $objResponse->script("addOption('contract_id','".$contracts[$i][8]." - ".$contracts[$i][9]."/".$contracts[$i][10]." (".($contracts[$i][2]+0)." lt/mėn.)"."','".$contracts[$i][0]."')");
		//echo $desgi[$i][0]."<br />";
	//}

   
    return $objResponse;
}


$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);



$cust = new Customer();


$smarty->assign('customers',$cust->getCustomersForSMS());


//echo 


//echo "<img src='pics/money_ok.png' />";
//echo "<pre>";
//print_r($cust->getCustomersForSMS());
//echo "</pre>";





if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/bulk_sms.tpl');
}

?>