<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die;

class plgQuickiconMjcpanel extends JPlugin
{
    public function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
//        $this->loadLanguage();
    }

    public function onGetIcons($context)
    {
        if ($context !== 'mod_quickicon' || !JFactory::getUser()->authorise('core.manage', 'com_mobilejoomla')) {
            return null;
        }

        return self::getIcons();
    }

    public static function getIcons()
    {
        if (!self::isMJInstalled()) {
            return array();
        }

        JHtml::_('behavior.modal', 'a.modal');

        $document = JFactory::getDocument();
        $document->addStyleSheet('components/com_mobilejoomla/assets/css/mjcpanel.css');
        if (!version_compare(JVERSION, '3.0', '>=')) {
            $document->addScript('components/com_mobilejoomla/assets/js/jquery.min.js');
            $document->addScript('components/com_mobilejoomla/assets/js/jquery-noconflict.js');
        }

        require_once JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/classes/mjhelper.php';
        MjHelper::cssCheckUpdate();
        MjHelper::jsGetNotification();

        if (version_compare(JVERSION, '3.0', '>=')) {
            return array(
                array(
                    'id' => 'mjnoupdate',
                    'link' => 'index.php?option=com_mobilejoomla',
                    'image' => 'mobile',
                    'text' => JText::_('COM_MJ__MOBILEJOOMLA')
                ),
                array(
                    'id' => 'mjupdate',
                    'link' => 'index.php?tmpl=component&option=com_mobilejoomla&controller=update&view=update',
                    'target' => '_self" class="modal" rel="{handler: \'iframe\', size: {x: 480, y: 320}}',
                    'image' => 'download',
                    'text' => JText::_('COM_MJ__MOBILEJOOMLA') . ' ' . JText::_('COM_MJ__UPDATE_AVAILABLE')
                )
            );
        } else {
            $image_path = JUri::base() . 'components/com_mobilejoomla/assets/images/';
            return array(
                array(
                    'id' => 'mjnoupdate',
                    'link' => 'index.php?option=com_mobilejoomla',
                    'image' => $image_path . 'mj-cpanel.png',
                    'text' => JText::_('COM_MJ__MOBILEJOOMLA')
                ),
                array(
                    'id' => 'mjupdate',
                    'link' => 'index.php?tmpl=component&option=com_mobilejoomla&controller=update&view=update',
                    'target' => '_self" class="modal" rel="{handler: \'iframe\', size: {x: 480, y: 320}}',
                    'image' => $image_path . 'mj-update.png',
                    'text' => JText::_('COM_MJ__UPDATE_AVAILABLE')
                )
            );
        }
    }

    private static function isMJInstalled()
    {
        return is_file(JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/mobilejoomla.php');
    }
}
