<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

class plgMobileAlways extends JPlugin
{
    public function __construct(&$subject, $config)
    {
        parent::__construct($subject, $config);
        if (!isset($this->params)) {
            $this->params = new JParameter(null);
        }
    }

    public function onMjGetDeviceList()
    {
        return array(
            'desktop' => 'Desktop',
            'mobile' => 'Mobile'
        );
    }

    public function onDeviceDetection($mj)
    {
        /** @var MjDevice $mjDevice */
        $mjDevice = $mj->device;

        $markup = $this->params->get('markup', '');
        if ($markup) {
            $mjDevice->markup = $markup;
        }
    }
}
