<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die ('Restricted access');

/** @var Joomla\Registry\Registry $params */
/** @var stdClass $module */
/** @var array $attribs */

include_once dirname(__FILE__) . '/helper.php';

$module_id = $params->get('module_id', 0);

$refModule = mjProxyModuleQuery($module_id);

if ($refModule !== null) {
    $refModule = clone $refModule;
    $refModule->showtitle = $module->showtitle;

    $moduleclass_sfx = $params->get('moduleclass_sfx', '');
    if ($moduleclass_sfx !== '') {
        if (version_compare(JVERSION, '1.6', '>=')) {
            $refParams = new JRegistry($refModule->params);
            $refParams->set('moduleclass_sfx', trim($refParams->get('moduleclass_sfx', '') . ' ' . $moduleclass_sfx));
            $refModule->params = (string)$refParams;
        } else {
            $refParams = new JParameter($refModule->params);
            $refParams->set('moduleclass_sfx', trim($refParams->get('moduleclass_sfx', '') . ' ' . $moduleclass_sfx));
            $refModule->params = $refParams->toString();
        }
    }

    echo mjProxyModuleRender($refModule, $attribs);
}

$module->showtitle = 0;
$params->set('moduleclass_sfx', 'nostyle');
