<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die ('Restricted access');

/**
 * @param int $module_id
 * @return stdClass
 */
function mjProxyModuleQuery($module_id)
{
    $joomlaWrapper = MjJoomlaWrapper::getInstance();
    $db = $joomlaWrapper->getDbo();

    $query = new MjQueryBuilder($db);
    $result = $query
        ->select('module', 'title', 'position')
        ->from('#__modules')
        ->where($query->qn('id') . '=' . (int)$module_id)
        ->setQuery()
        ->loadObject();
    if (!is_object($result)) {
        return null;
    }

    $name = substr($result->module, 4);

    $moduleObj =& JModuleHelper::getModule($name, $result->title);
    if (!is_object($moduleObj) || $moduleObj->id === 0) {
        return null;
    }
    if ($moduleObj->id !== $module_id) {
        $modules =& JModuleHelper::getModules($result->position);
        foreach ($modules as &$module) {
            if ($module->id === $module_id) {
                $moduleObj =& $module;
                break;
            }
        }
    }
    return $moduleObj;
}

/**
 * @param stdClass $module
 * @param array $attribs
 * @return string
 */
function mjProxyModuleRender($module, $attribs)
{
    $doc = JFactory::getDocument();
    /** @var JDocumentRendererModule $renderer */
    $renderer = $doc->loadRenderer('module');
    return $renderer->render($module, $attribs);
}
