<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die('Restricted access');

include_once dirname(dirname(__FILE__)) . '/classes/mjmodel.php';

class MjSettingsModel extends MjModel
{
    /** @var array */
    private $data;

    /** @var stdClass  */
    private $defaults;

    /**
     * @param MjJoomlaWrapper $joomlaWrapper
     */
    public function __construct($joomlaWrapper)
    {
        parent::__construct($joomlaWrapper);

        $this->data = $this->joomlaWrapper->dbSelectAll('#__mj_settings', 'name', 'value');
        $this->data['enabled'] = $this->joomlaWrapper->isMjPluginEnabled();
        $this->data['nomjitems'] = empty($this->data['nomjitems']) ? array() : explode(',', $this->data['nomjitems']);

        $this->defaults = json_decode(file_get_contents(dirname(dirname(__FILE__)) . '/defconfig.json'));
        if (!is_object($this->defaults)) {
            $this->defaults = new stdClass;
        }
    }

    /**
     * Get list of all key-value pairs
     * @return array
     */
    public function getAll()
    {
        return $this->data;
    }

    /**
     * @param string $name
     * @param mixed $default
     * @return mixed
     */
    public function get($name, $default = null)
    {
        if (isset($this->data[$name])) {
            return $this->data[$name];
        }
        if ($default === null && isset($this->defaults->$name)) {
            return $this->defaults->$name;
        }
        return $default;
    }

    /**
     * @param string $name
     * @param mixed $value
     */
    public function set($name, $value)
    {
        $this->data[$name] = $value;
    }

    /**
     * @param array $data
     * @return bool
     */
    public function bind($data)
    {
        foreach ($data as $key => $value) {
            $this->data[$key] = $value;
        }
        return true;
    }

    /**
     * @param string|array $keys
     * @param mixed $value
     * @return bool
     */
    public function def($keys, $value = null)
    {
        if (is_array($keys) || is_object($keys)) {
            foreach ($keys as $key => $val) {
                if (!isset($this->data[$key])) {
                    $this->data[$key] = $val;
                }
            }
        } elseif (!isset($this->data[$keys])) {
            $this->data[$keys] = $value;
        }
        return true;
    }

    /**
     * @return bool
     */
    public function save()
    {
        $data = $this->data;
        unset($data['enabled']);
        if (isset($data['nomjitems'])) {
            if (isset($data['nomjitems'][0]) && $data['nomjitems'][0] === '') {
                array_shift($data['nomjitems']);
            }
            $data['nomjitems'] = implode(',', $data['nomjitems']);
        }

        if (!$this->joomlaWrapper->dbSaveAll($data, '#__mj_settings', 'name', 'value')) {
            return false;
        }

        if (!$this->joomlaWrapper->enableMjPlugin($this->data['enabled'])) {
            return false;
        }

        // @todo check unlink/copy results, chmod for .htaccess
        $srcDir = JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/assets/ress';
        if (!is_dir($srcDir)) {
            //
            return false;
        }

        $destDir = JPATH_ROOT . '/media/mj';
        switch ($data['distribmode']) {
            case '':
                @unlink($destDir . '/.htaccess');
                break;
            case 'php':
                @unlink($destDir . '/.htaccess');
                copy($srcDir . '/f.php.sample', $destDir . '/f.php');
                break;
            case 'apache':
                copy($srcDir . '/sample_apache.htaccess', $destDir . '/.htaccess');
                break;
            case 'apachephp':
                copy($srcDir . '/sample_php.htaccess', $destDir . '/.htaccess');
                copy($srcDir . '/f.php.sample', $destDir . '/f.php');
                break;
        }

        return true;
    }
}